

const currency_efb = ["USD (United State dollar)","AED (United Arab Emirates dirham, درهم إماراتي)","AFN (Afghan afghani)","ALL (Albania Lek)","AMD (Armenian dram, Հայկական Դրամ)","ANG (Netherlands Antillean guilder, Antilliaanse gulden)","AOA (Angolan kwanza)","ARS (Argentine peso,Peso argentino)","AUD (Australian dollar)","AWG (Aruban florin, Arubaanse florin)","AZN (Azerbaijani manat, Azərbaycan manatı)","BAM (Bosnia and Herzegovina convertible mark, Конвертибилна марка)","BBD (Barbadian dollar)","BDT (Bangladeshi taka, টাকা)","BGN (Bulgarian lev, Български лев)","BIF (franc burundais)","BMD (Bermudian dollar)","BND (Brunei dollar, ringgit Brunei)","BOB  (Bolivian boliviano, boliviano)","BRL  (Brazilian real, Real brasileiro)","BSD (Bahamian dollar)","BWP (Botswana pula)","BYN (Belarusian ruble, беларускі рубель)","BZD (Belize dollar)","CAD (Canadian dollar, dollar canadien)","CDF (Congolese franc, franc congolais)","CHF (Swiss franc)","CLP  (Chilean peso, Peso chileno)","CNY (Renminbi, 人民币)","COP  (Colombian peso, peso colombiano)","CRC  (Costa Rican colón, colón costarricense)","CVE  (Cape Verdean escudo, escudo cabo-verdiano)","CZK (Czech koruna, koruna česká)","DJF  (Djiboutian franc, الفرنك الجيبوتي)","DKK (Danish krone, dansk krone)","DOP (Dominican peso, peso dominicano)","DZD (Algerian dinar, دينار جزائري)","EGP (Egyptian pound, جنيه مصرى)","ETB (Ethiopian birr)","EUR (Euro)","FJD (Fijian dollar)","FKP  (Falkland Islands pound)","GBP (Pound sterling)","GEL (Georgian lari,  ქართული ლარი)","GIP (Gibraltar pound)","GMD (Gambian dalasi)","GNF  (Guinean franc, franc guinéen)","GTQ  (Guatemalan quetzal,  quetzal guatemalteco)","GYD (Guyanese dollar)","HKD (Hong Kong dollar, 港元)","HNL  (Honduran lempira, lempira hondureño)","HRK (Croatian kuna, hrvatska kuna)","HTG (Haitian gourde, gourde haïtienne)","HUF (Hungarian forint, Magyar forint)","IDR (Indonesian rupiah)","ILS (Israeli new shekel, שקל חדש)","INR (Indian rupee)","ISK (Icelandic krona, króna)","JMD (Jamaican dollar)","JPY (Japanese yen, 日本円)","KES (Kenyan shilling, Kenyan shilling)","KGS (Kyrgyzstani som, Кыргыз сому)","KHR (Cambodian riel, រៀលកម្ពុជា/រៀលខ្មែរ)","KMF (Comorian franc)","KRW (South Korean won, 대한민국 원)","KYD (Cayman Islands dollar)","KZT (Kazakhstani tenge, Қазақстан теңгесі)","LAK (Lao kip,ເງີນກີບລາວ)","LBP (Lebanese pound, Livre libanaise)","LKR (Sri Lankan rupee, ශ්‍රී ලංකා රුපියල්)","LRD (Liberian dollar)","LSL (Lesotho loti)","MAD (Moroccan dirham, ⴰⴷⵔⵀⵎ ⵏ ⵍⵎⵖⵔⵉⴱ)","MDL (Moldovan leu, leu moldovenesc)","MGA (Malagasy ariary,ariary malgache)","MKD (Macedonian denar,денар)","MMK (Myanmar kyat)","MNT (Mongolian tögrög, Монгол төгрөг)","MOP (Macanese pataca)","MRO (Mauritanian ouguiya, أوقية موريتانية)","MUR (Mauritian rupee, Roupie mauricienne)","MVR (Maldivian rufiyaa)","MWK (Malawian kwacha)","MXN (Mexican peso, Peso Mexicano)","MYR (Malaysian ringgit, Ringgit Malaysia)","MZN (Mozambican metical, Metical moçambicano)","NAD (Namibian dollar)","NGN (Nigerian naira)","NIO (Nicaraguan córdoba, córdoba nicaragüense)","NOK (Norwegian krone, norsk krone)","NPR (Nepalese rupee, रुपैयाँ)","NZD (New Zealand dollar)","PAB (Panamanian balboa, Balboa panameño)","PEN (Peruvian sol, sol peruano)","PGK (Papua New Guinean kina)","PHP (Philippine peso, Piso ng Pilipinas)","PKR (Pakistani rupee)","PLN (Polish złoty, Polski złoty)","PYG (Paraguayan guaraní, Guaraní paraguayo)","QAR (Qatari riyal, ريال قطري)","RON (Romanian leu, Leu românesc)","RSD (Serbian dinar, Cрпски динар)","RUB (Russian ruble, Российский рубль)","RWF (Rwandan franc, franc rwandais)","SAR (Saudi riyalSaudi riyal, ريال سعودي)","SBD (Solomon Islands dollar)","SCR (Seychellois rupee, roupie seychelloise)","SEK (Swedish krona, svensk krona )","SGD (Singapore dollar, Dolar Singapura)","SHP (Saint Helena pound)","SLL (Sierra Leonean leone)","SOS (Somali shilling, Shilin Soomaali)","SRD (Surinamese, Surinamese )","STD (São Tomé and Príncipe dobra, dobra são-tomense)","SZL (Swazi lilangeni)","THB (Thai baht, บาทไทย)","TJS (Tajikistani somoni, Сомонӣ)","TOP (Tonga Pa'anga)","TRY (Turkish New Lira)","TTD (Trinidad/Tobago Dollar)","TWD (Taiwan Dollar)","TZS (Tanzania Shilling)","UAH (Ukraine Hryvnia)","UGX (Uganda Shilling)","UYU (Uruguay Peso)","UZS (Uzbekistani soʻm, Oʻzbek soʻmi)","VND (Vietnam Dong)","VUV (Vanuatu Vatu)","WST (Samoa Tala)","XAF (CFA Franc BEAC)","XCD (East Caribbean Dollar)","XOF (CFA Franc BCEAO)","XPF (CFP Franc)","YER (Yemen Rial)","ZAR (South Africa Rand)","ZMW (Zambian kwacha)"];
const lan_con_efb = {af:"ZA",ak:"AK",sq:"AL",hy:"AM",rup_MK:"en",as:"as",az_TR:"AZ",ba:"RU",eu:"ES",bel:"BY",bn_BD:"BD",bs_BA:"BA",my_MM:"MM",ca:"ES",bal:"ES",co:"FR",hr:"HR",dv:"MV",nl_NL:"NL",eo:"EO",fo:"FO",fr_BE:"FR",fy:"NL",fuc:"CM",gl_ES:"ES",ka_GE:"GE",gn:"BO",gu_IN:"IN",haw_US:"US",haz:"AF",is_IS:"IS",ido:"FI",jv_ID:"ID",kn:"IN",km:"KH",kin:"RW",ky_KY:"KG",ckb:"IQ",lo:"LA",li:"BE",lin:"CG",lb_LU:"LU",mk_MK:"MK",mg_MG:"MG",ml_IN:"IN",mr:"IN",xmf:"GA",mn:"MN",me_ME:"ME",ne_NP:"NP",nn_NO:"NO",ory:"IN",os:"IR",ps:"PK",fa_AF:"AF",pa_IN:"IN",rhg:"BD",ro_RO:"RO",ru_UA:"UA",rue:"SK",sah:"RU",sa_IN:"IN",srd:"IT",gd:"GB",sr_RS:"CS",sd_PK:"IN",si_LK:"LK ",sl_SI:"SI ",so_SO:"SO",azb:"IR",es_AR:"AR",es_CL:"CL",es_CO:"CO",es_MX:"MX",es_PE:"PE",es_PR:"PR ",es_ES:"ES",es_VE:"VE",su_ID:"SD",sw:"KE",sv_SE:"SE",gsw:"CH",tl:"PH",tg:"TJ ",tzm:"MA",ta_IN:"IN",ta_LK:"LK",tt_RU:"RU",te:"IN",th:"TH",bo:"CH",tir:"ET",tr_TR:"TR",tuk:"TM",ug_CN:"CN",uk:"UA",ur:"PK",uz_UZ:"UZ",vi:"VN",wa:"BE",cy:"GB ",yor:"NG",en_AU:"AU",en_CA:"CA",en_GB:"GB",en_NZ:"NZ",en_US:"US",en_ZA:"ZA",cs_CZ:"CZ",da_DK:"DK",de_AT:"AT",de_CH_informal:"CH",de_DE:"DE",ar:"SA",fa_IR:"IR",ja:"JA",zh_CN:"CN",zh_HK:"HK",zh_SG:"SG",zh_TW:"TW",pl_PL:"PL",pt_AO:"AO",pt_BR:"BR",pt_PT:"PT",ro_RO:"RO",ru_RU:"RU",sk_SK:"SK",ms_MY:"MY",nb_NO:"NO",nl_BE:"BE",ko_KR:"KR",he_IL:"IL",hi_IN:"IN",hu_HU:"HU",id_ID:"ID",it_IT:"IT",fi:"fi",fr_CA:"CA",fr_FR:"FR"};
const fields_efb = [
  { name: efb_var.text.text, icon: 'bi-file-earmark-text', id: 'text', pro: false,  tag:'basic all'},
  { name: efb_var.text.name, icon: 'bi-person-circle', id: 'name', pro: false,   tag:'basic all'},
  { name: efb_var.text.password, icon: 'bi-lock', id: 'password', pro: false, tag:'basic all' },
  { name: efb_var.text.email, icon: 'bi-envelope', id: 'email', pro: false,  tag:'basic all' },
  { name: efb_var.text.number, icon: 'bi-pause', id: 'number', pro: false,  tag:'basic all' },

  { name: efb_var.text.textarea, icon: 'bi-card-text', id: 'textarea', pro: false, tag:'basic all' },
  { name: efb_var.text.step, icon: 'bi-file', id: 'steps', pro: false, tag:'advance all' },
  { name: efb_var.text.checkbox, icon: 'bi-check-square', id: 'checkbox', pro: false, tag:'basic all'},
  { name: efb_var.text.radiobutton, icon: 'bi-record-circle', id: 'radio', pro: false, tag:'basic all' },
  { name: efb_var.text.select, icon: 'bi-check2', id: 'select', pro: false , tag:'basic all'},
  { name: efb_var.text.multiselect, icon: 'bi-check-all', id: 'multiselect', pro: false, tag:'advance all' },
  { name: efb_var.text.tel, icon: 'bi-telephone', id: 'tel', pro: false, tag:'basic all' },
  { name: efb_var.text.mobile, icon: 'bi-phone', id: 'mobile', pro: true, tag:'advance all' },

  { name: efb_var.text.range, icon: 'bi-arrow-left-right', id: 'range', pro: false, tag:'basic all' },
  { name: efb_var.text.ddate, icon: 'bi-calendar-date', id: 'date', pro: false, tag:'basic all' },
  { name: efb_var.text.file, icon: 'bi-file-earmark-plus', id: 'file', pro: false, tag:'basic all' },
  { name: efb_var.text.dadfile, icon: 'bi-plus-square-dotted', id: 'dadfile', pro: true, tag:'advance all' },
  { name: efb_var.text.address, icon: 'bi-geo-alt', id: 'address', pro: true, tag:'advance all' },


  { name: efb_var.text.payCheckbox, icon: 'bi-basket2', id: 'payCheckbox', pro: true, tag:'payment all' },
  { name: efb_var.text.payRadio, icon: 'bi-basket3', id: 'payRadio', pro: true, tag:'payment all' },
  { name: efb_var.text.prcfld, icon: 'bi-bag-plus', id: 'prcfld', pro: true, tag:'payment all' },
  { name: efb_var.text.ttlprc, icon: 'bi-cash', id: 'ttlprc', pro: true, tag:'payment all' },
  { name: efb_var.text.locationPicker, icon: 'bi-pin-map', id: 'maps', pro: true, tag:'advance all' },
  /* { name: efb_var.text.paySelect, icon: 'bi-bag-check', id: 'paySelect', pro: true, tag:'payment all' },
  { name: efb_var.text.payMultiselect, icon: 'bi-bag-plus', id: 'payMultiselect', pro: true, tag:'payment all' },  */
  { name: efb_var.text.stripe, icon: 'bi-credit-card', id: 'stripe', pro: true, tag:'payment all' },
  { name: efb_var.text.url, icon: 'bi-link-45deg', id: 'url', pro: false, tag:'basic all' },
  { name: efb_var.text.conturyList, icon: 'bi-flag', id: 'conturyList', pro: true, tag:'advance all' },
  { name: efb_var.text.stateProvince, icon: 'bi-triangle-fill', id: 'stateProvince', pro: true, tag:'advance all' },
  { name: efb_var.text.cityList, icon: 'bi-circle', id: 'cityList', pro: true, tag:'advance all' },
  { name: efb_var.text.esign, icon: 'bi-pen', id: 'esign', pro: true, tag:'advance all' },
  { name: efb_var.text.switch, icon: 'bi-toggle2-on', id: 'switch', pro: true, tag:'advance all' },
  { name: efb_var.text.chlCheckBox, icon: 'bi-card-checklist', id: 'chlCheckBox', pro: true, tag:'advance all' },
  //{ name: efb_var.text.chlRadio, icon: 'bi-card-list', id: 'chlRadio', pro: true, tag:'advance all' },
  { name: efb_var.text.heading, icon: 'bi-fonts', id: 'heading', pro: true, tag:'advance all' },

  { name: efb_var.text.color, icon: 'bi-palette', id: 'color', pro: true, tag:'basic all' },
  { name: efb_var.text.rating, icon: 'bi-star', id: 'rating', pro: true, tag:'advance all' },
  { name: efb_var.text.yesNo, icon: 'bi-hand-index', id: 'yesNo', pro: true, tag:'advance all' },
  { name: efb_var.text.link, icon: 'bi-link-45deg', id: 'link', pro: true, tag:'advance all' },
  { name: efb_var.text.htmlCode, icon: 'bi-code-square', id: 'html', pro: true, tag:'advance all' },
 /*  { name: efb_var.text.smartcr, icon: 'bi-globe', id: 'smartcr', pro: true, tag:'advance all' }, */
  { name: efb_var.text.pr5, icon: 'bi-heart', id: 'pointr5', pro: true, tag: 'advance all' },
  { name: efb_var.text.nps_, icon: 'bi-square', id: 'pointr10', pro: true, tag: 'advance all' },
  { name: efb_var.text.imgRadio, icon: 'bi-images', id: 'imgRadio', pro: true, tag:'advance all' },
  { name: efb_var.text.pdate, icon: 'bi-calendar-date', id: 'pdate', pro: true, tag:'advance all' },
  { name: efb_var.text.ardate, icon: 'bi-calendar-date', id: 'ardate', pro: true, tag:'advance all' },

  //{ name: efb_var.text.product, icon: 'bi-bag-check-fill', id: 'product', pro: true, tag:'payment all' },
  /* { name: efb_var.text.pricingTable, icon: 'bi-tags', id: 'pricingTable', pro: true, tag:'payment all' }, */
  { name: efb_var.text.terms, icon: 'bi-shield-check', id: 'trmCheckbox', pro: true, tag:'advance all' },

  { name: efb_var.text.nps_tm, icon: ' bi-table', id: 'table_matrix', pro: true, tag: 'advance all' },

]

const paymentMethodEls =(idset)=>{

  return`<label for="paymentMethodEl" class="efb mt-3 bi-wallet2 mx-2 efb"> ${efb_var.text.methodPayment}</label>
  <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="paymentMethodEl"  data-tag="${valj_efb[0].type}">
  <option value="charge" ${valj_efb[0].paymentmethod=='charge' ? 'selected' :''}>${efb_var.text.onetime}</option>
  <option value="day" ${valj_efb[0].paymentmethod=='day' ? 'selected' :''}>${efb_var.text.dayly}</option>
  <option value="week" ${valj_efb[0].paymentmethod=='week' ? 'selected' :''}>${efb_var.text.weekly}</option>
  <option value="month" ${valj_efb[0].paymentmethod=='month' ? 'selected' :''}>${efb_var.text.monthly}</option>
  <option value="year" ${valj_efb[0].paymentmethod=='year' ? 'selected' :''}>${efb_var.text.yearly}</option>

  </select>`;
}
const formTypeEls =()=>{

  return`<label for="formTypeEl" class="efb mt-3 mx-2 efb">${efb_var.text.frmtype}</label>
  <select data-id="formSet" class="efb elEdit form-select efb border-d rounded-4"  id="formTypeEl"  data-tag="${valj_efb[0].type}">
  <option value="form" ${valj_efb[0].type=='form' ? 'selected' :''}>${efb_var.text.form}</option>
  <option value="payment" ${valj_efb[0].type=='payment' ? 'selected' :''}>${efb_var.text.payment}</option>
  <option value="survey" ${valj_efb[0].type=='survey' ? 'selected' :''}>${efb_var.text.survey}</option>
  <option value="subscribe" ${valj_efb[0].type=='subscribe' ? 'selected' :''}>${efb_var.text.subscribe}</option>
  <option value="login" ${valj_efb[0].type=='login' ? 'selected' :''} disabled>${efb_var.text.login}</option>
  <option value="register" ${valj_efb[0].type=='register' ? 'selected' :''} disabled>${efb_var.text.register}</option>
  </select>`;
}

const textEls=(id , name ,el_type,value ,attr ,idset) =>{

  return`<div id="${idset}_lab_g" class="efb m-0 p-0"><label for="textEl" class="efb form-label mt-2 mb-1 efb">${name}<span class="efb  mx-1 efb text-danger">*</span></label>
<input type="${el_type}"  data-id="${idset}" data-atr="${attr}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1"  data-id="${id}" id="textEl" required value="${value}"></div>`
}

const currencyTypeEls=(idset)=>{

  let op = `<-- options -->`;
  for(let i of currency_efb){
    op += `<option value="${i.toLowerCase()}" ${valj_efb[0].currency.toUpperCase()==i.slice(0, 3) ? 'selected' :''}>${i}</option>`
  }
  return `
  <label for="currencyTypeEl" class="efb mt-3 bi-cash mx-2 efb"> ${efb_var.text.currency}</label>
                    <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="currencyTypeEl"  data-tag="${valj_efb[0].currency}">
                       ${op}
                    </select>
  `

}

const paymentPersianPayEls =(idset)=>{

  return`<label for="paymentPersianPayEl" class="efb mt-3 bi-wallet2 mx-2 efb">درگاه</label>
  <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="paymentPersianPayEl"  data-tag="${valj_efb[0].type}">
  <option value="zarinPal" ${valj_efb[0].persiaPay=='zarinPal' ? 'selected' :''}>زرین پال</option>
  <option disabled value="efb" ${valj_efb[0].persiaPay=='efb' ? 'selected' :''}>وایت استادیو</option>
  <option disabled value="efb" ${valj_efb[0].persiaPay=='melt' ? 'selected' :''}>ملت</option>
  </select>`;
}

const ElementAlignEls = (side ,indx ,idset) => {
  const left = side == 'label' ? 'txt-left' : 'justify-content-start'
  const right = side == 'label' ? 'txt-right' : 'justify-content-end'
  const center = side == 'label' ? 'txt-center' : 'justify-content-center'
  let value = valj_efb[indx].label_align;
  let t = efb_var.text.label
  if (side == 'description') {
    value = valj_efb[indx].message_align;
    t = efb_var.text.description
  }
  const lab = efb_var.text[side] || side;
  return `
  <div class="efb  row">
  <label for="labelPostionEl" class="efb  mt-3 col-12 bi-align-center mx-2">${lab} | ${efb_var.text.align}</label>
    <div class="efb  btn-group btn-group-toggle col-12 " data-toggle="buttons" data-side="${side}" data-id="${idset}"  id="ElementAlignEl">
      <label class="efb ntb btn-primary bi-align-start ${value == left ? `active` : ''}" onClick="funSetAlignElEfb('${idset}','${left}','${side}')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="labelPostionEl" value="left" >${efb_var.text.left}</label>
      <span class="efb border-right border border-light "></span>
      <label class="efb ntb btn-primary bi-align-center ${value == center ? `active` : ''}" onClick="funSetAlignElEfb('${idset}','${center}','${side}')">
        <input type="radio" name="options" class="efb opButtonEfb elEdit" data-id="${idset}"  id="labelPostionEl" value="center">${efb_var.text.center}</label>
      <span class="efb border-right border border-light "></span>
      <label class="efb ntb btn-primary bi-align-end ${value == right ? `active` : ''}" onClick="funSetAlignElEfb('${idset}','${right}','${side}')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit" data-id="${idset}"  id="labelPostionEl" value="right">${efb_var.text.right}</label>
    </div></div>`;
}

const countries_list_el_select=(el_type ,idset,indx)=>{

  let opt =`<option selected disabled>${efb_var.text.nothingSelected}</option>`;
  let country = valj_efb[indx].hasOwnProperty("country") ? valj_efb[indx].country : null;

  if (country==null){
    country  = lan_con_efb.hasOwnProperty(efb_var.language) ? lan_con_efb[efb_var.language] :'US';
  }
  counstries_list_efb.sort((a, b) => a.n.localeCompare(b.n));
  for (let i of counstries_list_efb) {

    opt +=`<option value="${i.s2.toLowerCase()}" ${ i.s2.toLowerCase()==country.toLowerCase() ? `selected` : ''}>${i.l} (${i.s2})</option>`
  }
  return `
  <div class="efb mx-1 mt-3">
  <label for="countriesListEl" class="efb mt-3 bi-aspect-ratio mx-2 efb"> ${efb_var.text.sctdlosp}</label>
  <select  data-id="${idset}" data-type="${el_type}" class="efb elEdit form-select efb border-d rounded-4"  id="countriesListEl"  data-tag="${valj_efb[indx].type}">
  ${opt}
  </select>
  </div>
  `
}
const state_list_el_select=(el_type ,idset,indx)=>{

  let opt =`<!--efb---!>`;
  let country = valj_efb[indx].hasOwnProperty("country") ? valj_efb[indx].country : 'GB';
  let statePov = valj_efb[indx].hasOwnProperty("statePov") ? valj_efb[indx].statePov : 'Antrim_Newtownabbey';
  country= country.toLowerCase();


  if (country==null){
    country  = lan_con_efb.hasOwnProperty(efb_var.language) ? lan_con_efb[efb_var.language] :'US';
  }


    if(country=='gb'){
      state_list_efb=fun_state_of_UK(idset,indx) ;
    for (let i of state_list_efb) {

      opt +=`<option value="${i.s2.toLowerCase()}" ${ i.s2.toLowerCase()==statePov.toLowerCase() ? `selected` : ''}>${i.value} (${i.s2})</option>`
    }
  }else{
    opt=  callFetchStatesPovEfb('statePovListEl',country,indx,'getStatesPovEfb');

  }
  return `
  <div class="efb mx-1 mt-1">
  <label for="statePovListEl" class="efb mt-3 bi-aspect-ratio mx-2 efb"> ${efb_var.text.sctdlocp}</label>
  <select  data-id="${idset}" data-type="${el_type}" class="efb elEdit form-select efb border-d rounded-4"  id="statePovListEl"  data-tag="${valj_efb[indx].type}">
  ${opt}
  </select>
  </div>
  `
}
const SingleTextEls = (side,idset,indx) => {
  let text = "";
  let t = ""
  if (side == "Next") { text = valj_efb[0].button_Next_text; t = efb_var.text.next; }
  else if (side == "Previous") { text = valj_efb[0].button_Previous_text; t = efb_var.text.previous; }
  else { text = valj_efb[indx].button_single_text }
  /* side == "Next" ? text = valj_efb[0].button_Next_text : text = valj_efb[0].button_Previous_text;
  side == "" ? text = valj_efb[indx].button_single_text : 0; */
  side == "Next" ? text = valj_efb[0].button_Next_text : text = valj_efb[0].button_Previous_text;
  side == "" ? text = valj_efb[indx].button_single_text : 0;
  return `<label for="SingleTextEl" class="efb  form-label  mt-2">${t} ${efb_var.text.text}</label>
  <input type="text" data-id="${idset}" class="efb  elEdit text-muted border-d rounded-4 form-control h-d-efb mb-1" data-side="${side}" placeholder="${efb_var.text.text}" id="SingleTextEl" required value="${text ? text : ''}">`
}

const cornerEls = (side,indx,idset) => {

  return `
    <div class="efb  row">
    <label for="cornerEl" class="efb  mt-3 col-12 bi-bounding-box-circles">${efb_var.text.corners}>${efb_var.text.rounded}</label>
    <div class="efb  btn-group col-12  btn-group-toggle" data-toggle="buttons" data-side="${side}" data-id="${idset}-set" data-tag="${valj_efb[indx].type}" id="cornerEl">
      <label class="efb  ntb  btn-primary bi-app ${valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner == 'efb-square' || valj_efb[indx].corner =="0"  ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','rounded-0')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="cornerEl" value="rounded-4" >0</label>
      <label class="efb  ntb  btn-primary bi-app ${valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner =="1" ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','rounded-1')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="cornerEl" value="rounded-4" >1</label>
      <label class="efb  ntb  btn-primary bi-app ${valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner =="2" ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','rounded-2')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="cornerEl" value="rounded-4" >2</label>
      <label class="efb  ntb  btn-primary bi-app ${valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner =="3" ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','rounded-3')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="cornerEl" value="rounded-4" >3</label>
      <label class="efb  ntb  btn-primary bi-app ${valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner =="4" ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','rounded-4')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="cornerEl" value="rounded-4" >4</label>
      <label class="efb  ntb  btn-primary bi-app ${valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner == 'rounded-4' || valj_efb[indx].corner =="5" ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','rounded-5')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit "  data-id="${idset}"  id="cornerEl" value="rounded-4" >5</label>
        <!-- <span class="efb  border-right border border-light "></span>
      <label class="efb  ntb btn-primary bi-diamond ${!valj_efb[indx].hasOwnProperty('corner') && valj_efb[indx].corner == 'efb-square' ? `active` : ''}" onClick="funSetCornerElEfb('${idset}','efb-square')">
        <input type="radio" name="options" class="efb  opButtonEfb elEdit" data-id="${idset}"  id="cornerEl" value="efb-square"> ${efb_var.text.square}</label>-->
    </div></div>`
}

const btnColorEls =(idset,indx) =>{

  color = valj_efb[indx].button_color;

  const hex=ColorNameToHexEfbOfElEfb(color.slice(4),indx,'btn')
  addColorTolistEfb(hex);
  idset =  valj_efb[indx].type =="esign" ? idset+'-id' :idset;
  return `<label for="btnColorEl" class="efb mt-3 bi-paint-bucket mx-2 efb">${efb_var.text.buttonColor}</label>
  <input type="color" id="btnColorEl" class="efb elEdit form-select efb border-d rounded-4" data-id="${idset}" data-el="button" data-type="button"  data-tag="${valj_efb[indx].type}" value="${hex!=''?hex:'#fff000'}" name="btnColorEl"  id="${idset}" >
  `
}

const hrefEls = (idset,indx) => {
  return `<label for="hrefEl" class="efb mt-3 bi-box-arrow-up-right mx-2 efb">${efb_var.text.link}</label>
  <input type="url" id="hrefEl" class="efb  elEdit text-muted form-control border-d rounded-4 efb mb-3 mb-1" data-id="${idset}" data-el="link" data-type="border" placeholder="https://"  data-tag="${valj_efb[indx].type}" value="${valj_efb[indx].href}" name="hrefEls"  id="${idset}" >
  `
}

const selectBorderColorEls = (forEl,indx,idset) => {
  let color = valj_efb[indx].el_border_color;
  let t = ''
  const hex=ColorNameToHexEfbOfElEfb(color.slice(7),indx,'border')
  addColorTolistEfb(hex);
  return `<label for="selectBorderColorEl" class="efb mt-3 bi-paint-bucket mx-2 efb">${efb_var.text.borderColor}</label>
  <input type="color" id="selectBorderColorEl" class="efb elEdit form-select efb border-d rounded-4" data-id="${idset}" data-el="${forEl}" data-type="border"  data-tag="${valj_efb[indx].type}" value="${hex!=''?hex:'#fff000'}" name="selectColorEl"  id="${idset}" >
  `
}
const fontSizeEls = (idset,indx) => {
  return `
    <label for="fontSizeEl" class="efb  mt-3 bi-arrow-down-up mx-2">${efb_var.text.height}</label>
    <select  data-id="${idset}" class="efb  rounded-4 elEdit form-select"  id="fontSizeEl" data-tag="${valj_efb[indx].type}">
    <option value="display-1"  ${valj_efb[indx].el_text_size ==  'display-1' ? `selected` : ''}>${efb_var.text.xxxlarge}</option>
    <option value="display-2"  ${valj_efb[indx].el_text_size == 'display-2' ? `selected` : ''} >${efb_var.text.xxlarge}</option>
    <option value="display-3"  ${valj_efb[indx].el_text_size == 'display-3' ? `selected` : ''} >${efb_var.text.xlarge}</option>
    <option value="display-4"  ${valj_efb[indx].el_text_size == 'display-4' ? `selected` : ''} >${efb_var.text.large}</option>
    <option value="display-5"  ${valj_efb[indx].el_text_size == 'display-5' ? `selected` : ''} >${efb_var.text.medium }</option>
    <option value="display-6"  ${valj_efb[indx].el_text_size == 'display-6' ? `selected` : ''} >${efb_var.text.small }</option>
    <option value="display-7"  ${valj_efb[indx].el_text_size == 'display-7' ? `selected` : ''} >${efb_var.text.xsmall}</option>
    <option value="display-8"  ${valj_efb[indx].el_text_size == 'display-8' ? `selected` : ''} >${efb_var.text.xxsmall}</option>
    </select>
    `
}
const selectHeightEls = (idset,indx) => {

  return `
    <label for="selectHeightEl" class="efb  mt-3 bi-arrow-down-up mx-2">${efb_var.text.height}</label>
    <select  data-id="${idset}" class="efb  rounded-4 elEdit form-select"  id="selectHeightEl" data-tag="${valj_efb[indx].type}">
    <option value="h-d-efb" ${ valj_efb[indx].el_height == 'h-d-efb' ? `selected` : ''}>${efb_var.text.default}</option>
    <option value="h-l-efb"  ${ valj_efb[indx].el_height == 'h-l-efb' ? `selected` : ''} >${efb_var.text.large}</option>
    <option value="h-xl-efb"  ${ valj_efb[indx].el_height == 'h-xl-efb' ? `selected` : ''} >${efb_var.text.xlarge}</option>
    <option value="h-xxl-efb"  ${ valj_efb[indx].el_height == 'h-xxl-efb' ? `selected` : ''} >${efb_var.text.xxlarge}</option>
    <option value="h-xxxl-efb"  ${ valj_efb[indx].el_height == 'h-xxxl-efb' ? `selected` : ''} >${efb_var.text.xxxlarge}</option>
    </select>
    `
}
const ElcountriesListSelections = (idset,indx) => {
  const rndm = idset;
 let optn = `<!--opt-->`;
 let selectData =""
 let value ="";
 let c_c =[];
 if(valj_efb[indx].hasOwnProperty("c_c")){
  for(let i of valj_efb[indx].c_c){

   c_c.push(i);
   value +=i + ","
   selectData +=i + " @efb!"
  }
 }
  for (const i of counstries_list_efb) {


    const s2 = i.s2.trim().toLowerCase();

    const v = i.l!=i.n  ? `(${i.l})` :''
    optn += `<tr   class="efb   efblist " data-indx="${indx}" data-id="${s2}" data-code="${i.c_c}" data-name="${s2}" data-row="${s2}" data-state="0" data-visible="1">
    <th scope="row" class="efb ${c_c.indexOf(s2)!=-1 ? 'bi-check-square text-info' : 'bi-square'}" onClick="fun_test(this)" data-indx="${indx}" data-id="${s2}" data-code="${i.c_c}" data-name="${s2}" ></th><td class="efb ms col-12"  onClick="fun_test(this)" data-indx="${indx}" data-id="${s2}" data-code="${i.c_c}" data-name="${s2}">${i.n} ${v}</td>
  </tr>  `

  }//end for
   return `
    <label for="${rndm}-f" class="efb  mt-3 bi-arrow-down-up mx-2">${efb_var.text.scdnmi}</label>
    <div class="efb col-sm-12 listSelect mx-0 ttEfb show"   id='${rndm}-f' data-id="${rndm}-el" >
    <div class="efb efblist  mx-0  inplist  h-d-efb rounded-4 border-d bi-chevron-down" data-id="menu-${rndm}"   data-no="145" data-min="" data-parent="1" data-icon="1" data-select="${selectData}"  data-vid='${rndm}' id="${rndm}_options" > ${value.length>1 ? value :efb_var.text.selectOption}</div>

    <div class="efb efblist mx-1  listContent d-none rounded-bottom  bg-light" data-id="menu-${rndm}" data-list="menu-${rndm}">
    <table class="efb table menu-${rndm}">
     <thead class="efb efblist">
       <tr> <div class="efb searchSection efblist p-2 bg-light">
       <!-- <i class="efb efblist searchIcon  bi-search text-primary "></i> -->
           <input type="text" class="efb efblist search searchBox my-1 col-12 rounded " data-id="menu-${rndm}" data-tag="search" placeholder="🔍 ${efb_var.text.search}" onkeyup="FunSearchTableEfb('menu-${rndm}')"> </div>
     </tr> </thead>
     <tbody class="efb fs-7">
      ${optn}
     </tbody>
   </table>
  </div>
    `
}
function fun_test(t){

  const idx = t.dataset.indx;
  const c= t.dataset.name;
  const n= t.dataset.code;
 if( valj_efb[idx].hasOwnProperty("c_c")==false){
  valj_efb[idx].c_c=[c]
  valj_efb[idx].c_n=[n];
  return;
 }else{
   const indx = valj_efb[idx].c_c.indexOf(c)
   if(indx!=-1){

    valj_efb[idx].c_c.splice(indx,1)
    valj_efb[idx].c_n.splice(indx,1)
    return;
  }else{
    valj_efb[idx].c_c.push(c)
    valj_efb[idx].c_n.push(n)
  }
 }

}
function show_setting_window_efb(idset) {

  if(document.getElementById('sideBoxEfb').classList.contains('show')){
    sideMenuEfb(0);

    return};

    state_view_efb=1;
    document.getElementById('sideMenuConEfb').innerHTML=efbLoadingCard();
    sideMenuEfb(1)


    let el = idset != "formSet" ? document.querySelector(`[data-id="${idset}"]`) : { dataset: { id: 'formSet', tag: 'formSet' } }
    let body = ``;

    const indx = idset != "button_group" && idset != "formSet" ? valj_efb.findIndex(x => x.dataId == idset) : 0;

    if (indx == 0 && idset != "formSet") el = document.getElementById(`f_btn_send_efb`);

    const labelEls = `<div id="${idset}_lab_g" class="efb m-0 p-0"><label for="labelEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.label}<span class="efb  mx-1 efb text-danger">*</span></label>
    <input type="text"  data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1"  placeholder="${efb_var.text.label}" id="labelEl" required value="${valj_efb[indx].name ? valj_efb[indx].name : ''}"></div>`
    const idHidden = `
    <!-- <input type="hide"  class="efb d-none" data-id="${idset}" data-hide="idhide" id="${valj_efb[indx].id_}" >-->`


    const desEls = `<label for="desEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.description}</label>
    <input type="text" data-id="${idset}" class="efb elEdit form-control text-muted efb border-d rounded-4 h-d-efb mb-1" placeholder="${efb_var.text.description}" id="desEl" required value="${valj_efb[indx].message ? valj_efb[indx].message : ''}">`



    const miLenEls = ()=>{
    let label =  efb_var.text.min;
    let type = "number"

    if(valj_efb[indx].type=="range" || valj_efb[indx].type=="number") {label = efb_var.text.min}
    else if(valj_efb[indx].type=="date") {
      label = efb_var.text.mindt; ;

      type =  'text'}

    return  `<label for="miLenEl" class="efb form-label mt-2 mb-1 efb">${label}</label>
    <input type="${type}" data-id="${idset}" class="efb elEdit form-control text-muted efb border-d rounded-4 h-d-efb mb-1" placeholder="${label}" id="miLenEl" required value="${valj_efb[indx].hasOwnProperty('milen') ? valj_efb[indx].milen : ''}" min="0">`
  }

  const mLenEls = ()=>{
    let label =  efb_var.text.max;
    let type = "number"

    if(valj_efb[indx].type=="range" || valj_efb[indx].type=="number") {label = efb_var.text.max}
    else if(valj_efb[indx].type=="date") {
      label = efb_var.text.mxdt;
      type =  'text'}
      return `<label for="mLenEl" class="efb form-label mt-2 mb-1 efb">${label}</label>
      <input type="${type}" data-id="${idset}" class="efb elEdit form-control text-muted efb border-d rounded-4 h-d-efb mb-1" placeholder="${label}" id="mLenEl" required value="${valj_efb[indx].hasOwnProperty('mlen') ? valj_efb[indx].mlen : ''}" min="0">`
  }

  const requireEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="requiredEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('required') && Number(valj_efb[indx].required) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label pt-1" for="requiredEl">${efb_var.text.required}</label>
    </div>`;

    const hiddenEls = `<div class="efb mx-0 my-1 efb">
    <button type="button" id="hiddenEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('hidden') && Number(valj_efb[indx].hidden) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="hiddenEl">${efb_var.text.hField}</label>
    </div>`;
    const disabledEls = `<div class="efb mx-0 my-1 efb">
    <button type="button" id="disabledEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('disabled') && Number(valj_efb[indx].disabled) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="disabledEl">${efb_var.text.dField}</label>
    </div>`;

    const hideLabelEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="hideLabelEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('hflabel') && Number(valj_efb[indx].hflabel) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
        <div class="efb handle"></div>
      </button>
    <label class="efb form-check-label" for="hideLabelEl">${efb_var.text.hflabel}</label>
    </div>`;
    const cardEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="cardEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('dShowBg') && Number(valj_efb[indx].dShowBg) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label pt-1" for="cardEl">${efb_var.text.dNotShowBg}</label>
    </div>`;
    const offLineEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="offLineEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('AfLnFrm') && Number(valj_efb[indx].AfLnFrm) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="offLineEl">${efb_var.text.AfLnFrm}</label>
    </div>`;

    const emailEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="SendemailEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${ (valj_efb[indx].hasOwnProperty('noti') && Number(valj_efb[indx].noti) ==1) ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}" data-vid="${valj_efb[indx].id_}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label pt-1" for="SendemailEl">${efb_var.text.thisEmailNotificationReceive} </label> <i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="EmailNoti"> </i>
    </div>`;
    const adminFormEmailEls = `<label for="adminFormEmailEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.enterAdminEmailReceiveNoti}<i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="EmailNoti"> </i></label>
    <input type="text" data-id="${idset}" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb" placeholder="${efb_var.text.email}" id="adminFormEmailEl" required value="${valj_efb[0].email ? valj_efb[0].email : ''}">`
    const FormEmailSubjectEls = () =>{

      let value = efb_var.text.default

      if(valj_efb[0].hasOwnProperty('email_sub') && valj_efb[0].email_sub!='') value =  valj_efb[0].email_sub;
      return `
      ${pro_efb==true ?"":funProEfb()}
      <label for="FormEmailSubjectEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.mlsbjt}</label>
      <input type="text" data-id="${idset}" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb" placeholder="${efb_var.text.mlsbjt}" id="FormEmailSubjectEl" required value="${value}">`

    }
    const EmailNotiContainsEls =() =>{
      const val = valj_efb[0].hasOwnProperty('email_noti_type') ? valj_efb[indx].email_noti_type : 'cc';

      return `
    <label for="emailNotiContainsEl" class="efb mt-2 mb-1   efb">${efb_var.text.emlc}</label>
                        <select  class="efb elEdit form-select efb border-d rounded-4 mb-1" data-id="${idset}"  id="emailNotiContainsEl" >
                            <option value="cc" ${val == 'cc' ? `selected` : ''}>${efb_var.text.emlacl}</option>
                            <option value="msg" ${val == 'msg' ? `selected` : ''}>${efb_var.text.emlml}</option>
                        </select>

    `};
    const trackingCodeEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="trackingCodeEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('trackingCode') && Number(valj_efb[indx].trackingCode) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="trackingCodeEl">${efb_var.text.activeTrackingCode}</label>
    </div>`;
    const captchaEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="captchaEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('captcha') && Number(valj_efb[indx].captcha) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="captchaEl">${efb_var.text.addGooglereCAPTCHAtoForm}</label>
    </div>`;
    const showSIconsEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="showSIconsEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('show_icon') && Number(valj_efb[indx].show_icon) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="showSIconsEl">${efb_var.text.dontShowIconsStepsName}</label>
    </div>`;
    const showSprosiEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="showSprosiEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('show_pro_bar') && Number(valj_efb[indx].show_pro_bar) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="showSprosiEl">${efb_var.text.dontShowProgressBar}</label>
    </div>`;
    let disable =valj_efb[0].type!="register" && valj_efb[0].type!="login"  ? '' : 'disabled';
    const m_tankYouMessage = valj_efb[0].type!="register" ? efb_var.text.thankYouMessage:efb_var.text.createAcountDoneM;
    const thankYouMessageEls = `<div class="efb tnxmsg mt-1  ${valj_efb[0].thank_you=="msg" ? 'd-block' :'d-none'}"><label for="thankYouMessageEl" class="efb form-label mt-2 mb-1 efb">${ efb_var.text.thankYouMessage }</label>
    <input ${disable} type="text" data-id="${idset}" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb" placeholder="${efb_var.text.thankYouMessage}" id="thankYouMessageEl" required value="${valj_efb[0].thank_you_message.thankYou ? valj_efb[0].thank_you_message.thankYou : m_tankYouMessage}"></div>`;
    const thankYouMessageDoneEls = `<div class="efb tnxmsg mt-1 ${valj_efb[0].thank_you=="msg" ? 'd-block' :'d-none'}"><label for="thankYouMessageDoneEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.done} ${efb_var.text.message}</label>
    <input ${disable} type="text" data-id="${idset}" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb" placeholder="${efb_var.text.done}" id="thankYouMessageDoneEl" required value="${valj_efb[0].thank_you_message.done ? valj_efb[0].thank_you_message.done : efb_var.text.done}"></div>`;
    const thankYouMessageConfirmationCodeEls = `<div class="efb tnxmsg mt-1 ${valj_efb[0].thank_you=="msg" ? 'd-block' :'d-none'}"><label for="thankYouMessageConfirmationCodeEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.trackingCode} ${efb_var.text.message}</label>
    <input ${disable} type="text" data-id="${idset}" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb" placeholder="${efb_var.text.trackingCode}" id="thankYouMessageConfirmationCodeEl" required value="${valj_efb[0].thank_you_message.trackingCode ? valj_efb[0].thank_you_message.trackingCode : efb_var.text.trackingCode}"></div>`;


    const showformLoggedEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="showformLoggedEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${valj_efb[indx].hasOwnProperty('stateForm') && Number(valj_efb[indx].stateForm) == 1 ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label" for="showformLoggedEl">${efb_var.text.showTheFormTologgedUsers}</label>
    </div>`;


    const smsEnableEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="smsEnableEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${ (valj_efb[indx].hasOwnProperty('smsnoti') && Number(valj_efb[indx].smsnoti) ==1) ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}" data-vid="${valj_efb[indx].id_}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label pt-1" for="smsEnableEl">${efb_var.text.esmsno} </label> <i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="SMSNoti"> </i>
    </div>`;
    const enableConEls = `<div class="efb mx-1 my-3 efb">
    <button type="button" id="enableConEl" data-state="off" data-name="disabled" class="efb mx-0 btn h-s-efb  btn-toggle ${ (valj_efb[indx].hasOwnProperty('logic') && Number(valj_efb[indx].logic) ==1) ? 'active' : ''}" data-toggle="button" aria-pressed="false" autocomplete="off"  data-id="${idset}" data-vid="${valj_efb[indx].id_}"  onclick="fun_switch_form_efb(this)" >
    <div class="efb handle"></div>
    </button>
    <label class="efb form-check-label pt-1" for="enableConEl">${efb_var.text.condlogic} </label> <i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="condi"> </i>
    </div>`;

    const languageSelectPresentEls = `
                     <label for="languageSelectPresentEl" class="efb mt-3 px-1 bi-translate mx-2 efb"> ${efb_var.text.stsd}</label>
                      <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="languageSelectPresentEl"  data-tag="${valj_efb[indx].type}">
                      <option value="1" ${ valj_efb[indx].hasOwnProperty('stylish')==false || valj_efb[indx].stylish == 1 ? `selected` : ''} >${efb_var.text.nlan} (${efb_var.text.elan})</option>
                      <option value="2" ${ valj_efb[indx].stylish == 2 ? `selected` : ''}>${efb_var.text.nlan}</option>
                      <option value="3" ${ valj_efb[indx].stylish == 3 ? `selected` : ''}>${efb_var.text.elan}</option>

                      </select>`;



    const qtyPlcEls = valj_efb[indx].hasOwnProperty('pholder_chl_value')? `<label for="qtyPlclEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.label}<span class="efb  mx-1 efb text-danger">*</span></label> <input type="number"  data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1"  placeholder="${efb_var.text.placeholder}" id="qtyPlcEl" required value="${valj_efb[indx].pholder_chl_value ? valj_efb[indx].pholder_chl_value : ''}">` :'';


    const Nadvanced = `
    ${idHidden}
    ${labelEls}
    ${hideLabelEls}
    ${el.dataset.tag != 'ttlprc' ? requireEls : ''}
    ${desEls}`
    const labelFontSizeEls = `
      <label for="labelFontSizeEl" class="efb mt-3 bi-aspect-ratio mx-2 efb">${efb_var.text.labelSize}</label>
                        <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="labelFontSizeEl"  data-tag="${valj_efb[indx].type}">
                            <option value="fs-6" ${ valj_efb[indx].label_text_size == 'fs-6' ? `selected` : ''}>${efb_var.text.default}</option>
                            <option value="fs-7" ${ valj_efb[indx].label_text_size == 'fs-7' ? `selected` : ''}>${efb_var.text.small}</option>
                            <option value="fs-5" ${ valj_efb[indx].label_text_size == 'fs-5' ? `selected` : ''} >${efb_var.text.large}</option>
                            <option value="fs-4" ${ valj_efb[indx].label_text_size == 'fs-4' ? `selected` : ''} >${efb_var.text.xlarge}</option>
                            <option value="fs-3" ${ valj_efb[indx].label_text_size == 'fs-3' ? `selected` : ''} >${efb_var.text.xxlarge}</option>
                        </select>`;
    const optnsStyleEls = `
      <label for="optnsStyleEl" class="efb mt-3 bi-layout-split mx-2 efb">${efb_var.text.cols}</label>
                        <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="optnsStyleEl"  data-tag="${valj_efb[indx].type}">
                            <option value="1" ${ !valj_efb[indx].hasOwnProperty('op_style') || valj_efb[indx].op_style == '1' ? `selected` : ''}>${efb_var.text.default}</option>
                            <option value="2" ${ valj_efb[indx].op_style == '2' ? `selected` : ''}>${efb_var.text.col} 2</option>
                            <option value="3" ${ valj_efb[indx].op_style == '3' ? `selected` : ''} >${efb_var.text.col} 3</option>
                        </select>`;

      const thankYouTypeEls = `
      <label for="thankYouTypeEl" class="efb mt-3 bi-card-heading mx-0 mb-2 fs-6 form-text border-secondary  border-bottom text-secondary">${efb_var.text.landingTnx}</label>
                        <select  data-id="thankYouTypeEl" class="efb elEdit form-select efb border-d rounded-4"  id="thankYouTypeEl"  data-tag="${valj_efb[0].thank_you}">
                        <option value="rdrct" ${ valj_efb[0].thank_you == 'rdrct' ? `selected` : ''}>${efb_var.text.redirectPage}</option>
                        <option value="msg" ${ valj_efb[0].thank_you == 'msg' ? `selected` : ''}>${efb_var.text.thankYouMessage}</option>
                        </select>`;

    const thankYouredirectEls = `<div id="tnxrdrct" class="efb tnxrdrct my-1 ${ valj_efb[0].thank_you == 'rdrct'? 'd-block' :'d-none' }">
    ${pro_efb==true ?"":funProEfb()}
    <label for="thankYouredirectEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.redirectPage} <i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="redirectPage"> </i></label>
    <input type="url" data-id="thankYouredirectEl" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb" placeholder="${efb_var.text.url}" id="thankYouredirectEl" required value="${ valj_efb[0].hasOwnProperty('rePage') ? valj_efb[0].rePage.replace(/(@efb@)+/g, '/') : ''}"></div>`
    const paymentGetWayEls =()=>{
      return`<label for="paymentGetWayEl" class="efb mt-3 bi-wallet-fill mx-2 efb"> ${efb_var.text.paymentGateway}</label>
      <select  data-id="${idset}" class="efb elEdit form-select efb border-d rounded-4"  id="paymentGetWayEl"  data-tag="${valj_efb[0].type}">
          <option value="stripe" selected>${efb_var.text.stripe}</option>
      </select>`;
    }

     const currencyPersianPayEls= `<p for="currencyTypeEl" class="efb text-labelEfb fs-5 mt-3 bi-cash mx-2 efb"> ${efb_var.text.currency}: تومان</p>
      `;

    const labelPostionEls = `
    <div class="efb row efb">
    <label for="labelPostionEl" class="efb  mt-3 col-12 bi-arrows-angle-contract mx-2">${efb_var.text.labelPostion}</label>
      <div class="efb  btn-group btn-group-toggle col-12 " data-toggle="buttons" data-id="${idset}"  id="labelPostionEl">
        <label class="efb  ntb btn-primary bi-chevron-bar-down ${valj_efb[indx].label_position && valj_efb[indx].label_position == 'up' ? `active` : ''}" onClick="funSetPosElEfb('${idset}','up')">
          <input type="radio" name="options" class="efb  opButtonEfb elEdit "   data-id="${idset}"  id="labelPostionEl" value="up" >${efb_var.text.up}</label>
        <span class="efb  border-right border border-light "></span>
        <label class="efb  ntb btn-primary bi-chevron-bar-right ${valj_efb[indx].label_position && valj_efb[indx].label_position == 'beside' ? `active` : ''}" onClick="funSetPosElEfb('${idset}','besie')">
          <input type="radio" name="options" class="efb  opButtonEfb elEdit" data-id="${idset}"  id="labelPostionEl" value="beside"> ${efb_var.text.beside}
        </label>
      </div></div>`;


    const widthEls = `
      <label for="sizeEl" class="efb  mt-3 bi-arrow-left-right mx-2">${efb_var.text.width}</label>
      <select  data-id="${idset}" class="efb  rounded-4 elEdit form-select"  id="sizeEl" >
          <option value="8" ${valj_efb[indx].size == 8.3 ? `selected` : ''}>8%</option>
          <option value="17" ${valj_efb[indx].size == 17 ? `selected` : ''}>17%</option>
          <option value="25" ${valj_efb[indx].size == 25 ? `selected` : ''}>25%</option>
          <option value="33" ${valj_efb[indx].size == 33 ? `selected` : ''}>33%</option>
          <option value="42" ${valj_efb[indx].size == 42 ? `selected` : ''}>42%</option>
          <option value="50" ${valj_efb[indx].size == 50 ? `selected` : ''}>50%</option>
          <option value="58" ${valj_efb[indx].size == 58 ? `selected` : ''}>58%</option>
          <option value="67" ${valj_efb[indx].size == 67 ? `selected` : ''}>67%</option>
          <option value="75" ${valj_efb[indx].size == 75 ? `selected` : ''}>75%</option>
          <option value="83" ${valj_efb[indx].size == 80 || valj_efb[indx].size == 83 ? `selected` : ''} >83%</option>
          <option value="92" ${valj_efb[indx].size == 92 ? `selected` : ''} >92%</option>
          <option value="100" ${valj_efb[indx].hasOwnProperty('size')==false || valj_efb[indx].size == 100 ? `selected` : ''} >100%</option>
      </select>
      `
    const classesEls = `
      <label for="cssClasses" class="efb  mt-3 bi-journal-code mx-2">${efb_var.text.cSSClasses}</label>
      <input type="text"  data-id="${idset}" class="efb  elEdit text-muted form-control border-d rounded-4 efb mb-3 mb-1" id="classesEl" placeholder="${efb_var.text.cSSClasses}"  ${valj_efb[indx].classes && valj_efb[indx].classes.length > 1 ? `value="${valj_efb[indx].classes}"` : ''}>
      `
    const valueEls = `
    <label for="valueEl" class="efb  mt-3 bi-cursor-text mx-2">${efb_var.text.value}</label>
      <input type="${valj_efb[indx].type!="range" ? "text" :'number' }"  data-id="${idset}" class="efb elEdit text-muted form-control border-d rounded-4 efb mb-3" data-tag="${valj_efb[indx].type}" id="valueEl" placeholder="${efb_var.text.defaultValue}" ${valj_efb[indx].value && valj_efb[indx].value.length > 1 ? `value="${valj_efb[indx].value}"` : ''}>
      `
    const valueTextereaEls = `
    <label for="valueEl" class="efb  mt-3 bi-cursor-text mx-2">${efb_var.text.value}</label>
      <textarea type="text"  data-id="${idset}" class="efb elEdit text-muted form-control border-d rounded-4 efb mb-3" data-tag="${valj_efb[indx].type}" id="valueEl" placeholder="${efb_var.text.defaultValue}" ${valj_efb[indx].value && valj_efb[indx].value.length > 1 ? `value="${valj_efb[indx].value}"` : ''}  rows="3"></textarea>
      `

    const placeholderEls = `
      <label for="placeholderEl" class="efb  mt-3 bi-patch-exclamation mx-2">${efb_var.text.placeholder}</label>
      <input type="text"  data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1"id="placeholderEl" placeholder="${efb_var.text.placeholder}" ${valj_efb[indx].placeholder && valj_efb[indx].placeholder.length > 1 ? `value="${valj_efb[indx].placeholder}"` : ''}>
      `

    const iconEls = (side) => {
      let icon = "";
      let t = ""
      let iset ="";

      if (side == "Next") {iset=idset=side+"_"; icon = valj_efb[0].button_Next_icon; t = efb_var.text.next; }
      else if (side == "Previous") {iset=idset=side+"_"; icon = valj_efb[0].button_Previous_icon; t = efb_var.text.previous }
      else if ( side =='tnx') {

        if(valj_efb[0].thank_you_message.hasOwnProperty('icon')){
          iset=idset=side="DoneIconEfb"; icon=valj_efb[0].thank_you_message.icon; t=`${efb_var.text.thankYou}`;
        }else{
          return '<!-- Icon not exist for Done message-->';
        }
      }else {
       idset != "button_group" ? iset=idset=valj_efb[indx].id_: iset=idset="button_group_"
        if(isNumericEfb(iset))idset=iset="step-"+iset;

        icon = valj_efb[indx].icon }
      let list =`<tr class="efb efblist text-white" data-id="${iset}" data-name="bi-XXX" data-row="-2" data-state="0" data-visible="1">
      <th scope="row" class="efb bi-XXXXX"></th>
      <td>None</td>
     </tr>`
      bootstrap_icons.forEach((e,key )=> {
        const v= e.replace(`-`, ' ');
        list+=`<tr class="efb efblist text-white" data-id="${iset}" data-name="bi-${e}" data-row="${key}" data-state="0" data-visible="1">
        <th scope="row" class="efb bi-${e}"></th>
        <td>${v}</td>
      </tr>`
      });
      let iNo =''
      if (icon.length>1){
         iNo =bootstrap_icons.findIndex(x=>x==icon.replace('bi-',''));
      }


      return `
      <div class="efb ${ side!="DoneIconEfb"? '' :`tnxmsg mt-1 ${valj_efb[0].thank_you=="msg" ? 'd-block' :'d-none'}` }"> <label for="iconEl" class="efb form-label bi-heptagon mx-2 mt-2 mb-0" id="DoneIconEfb">${t} ${efb_var.text.icon} </label>
          <div class="efb  listSelect my-2">
            <div class="efb  efblist mx-1  p-2 inplist  h-d-efb elEdit border efb border-d rounded-4 bi-chevron-down" id="iconEl"
            data-id="${iset}" data-idset="${idset}" data-side="${side}"  data-no="1" data-parent="1" data-iconset="${iNo}"
            data-select="">${icon=="" ? efb_var.text.selectOption :icon!='bi-undefined'? icon :'None'}</div>
            <div class="efb  efblist mx-1  listContent d-none rounded-bottom  bg-secondary" data-id="${iset}" data-list="${iset}">
            <table class="efb  table ${iset}">
                    <thead class="efb  efblist">
                      <tr><div class="efb  searchSection efblist  p-2 bg-secondary">
                        <!--  <i class="efb  efblist  searchIcon  bi-search text-primary "></i> -->
                          <input type="text" class="efb  efblist search searchBox my-1 col-12 rounded " data-id="${iset}" data-tag="search" placeholder="🔍 ${efb_var.text.search}" onkeyup="FunSearchTableEfb('${iset}')">
                        </div></tr>
                    </thead> <tbody class="efb">
                    ${list}
                    </tbody></table>
            </div>
          </div>
      </div>
        `
    }


    const smsContentEls=(type)=>{



      if(type=="WeRecivedUrM"){
        if(valj_efb[0].hasOwnProperty('sms_msg_recived_usr')){
           value = efb_text_nr(valj_efb[0].sms_msg_recived_usr,0) }else{ value = efb_var.text.WeRecivedUrM + `\n ${efb_var.text.trackNo}: [confirmation_code]\n${efb_var.text.url}: [link_response]`};
      }else if(type == 'responsedMessage'){
        if( valj_efb[0].hasOwnProperty('sms_msg_responsed_noti')){value = efb_text_nr(valj_efb[0].sms_msg_responsed_noti,0)}else{value =efb_var.text.newResponse + `\n ${efb_var.text.trackNo}: [confirmation_code]\n${efb_var.text.url}: [link_response]`};
      }else if (type == "newMessageReceived"){
      if(valj_efb[0].hasOwnProperty('sms_msg_new_noti')) { value =efb_text_nr(valj_efb[0].sms_msg_new_noti,0) }else{

          value = efb_var.text.newMessageReceived + `\n ${efb_var.text.trackNo}: [confirmation_code]\n ${efb_var.text.url}: [link_response]`};
      }

      const disable = valj_efb[0].hasOwnProperty('smsnoti') && Number(valj_efb[0].smsnoti) == 1 ? '' : 'disabled d-none';
      const content =`
      <div class="efb smsmsg ${disable}">
      <textarea type="text" data-id="${type}" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb  sms-efb" placeholder="${value}" id="smsContentEl" required >${value}</textarea>
      </div>
      `
      return content;
    }


    const smsAdminsPhoneNoEls =()=>{
      let value = valj_efb[0].hasOwnProperty('sms_admins_phone_no') ? valj_efb[0].sms_admins_phone_no : '';
      const disable = valj_efb[0].hasOwnProperty('smsnoti') && Number(valj_efb[0].smsnoti) == 1 ? '' : 'disabled d-none';
      const content =`
      <div class="efb smsmsg ${disable}">
      <label for="smsAdminsPhoneNoEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.sms_admn_no}</label>
      <input type="text" data-id="smsAdminsPhoneNoEl" class="efb elEdit text-muted form-control h-d-efb border-d rounded-4  mb-1 efb sms-efb" placeholder="+11234567890, +11234567891" id="smsAdminsPhoneNoEl" required value="${value}" >
      </div>
      `

      return content;
    }



    const fileSizeMaxEls =()=>{
      const file_size = valj_efb[indx].hasOwnProperty('max_fsize') ? valj_efb[indx].max_fsize : 8;
      return`
      <div class="efb  mt-3">
      <label for="fileSizeMaxEl" class="efb  mt-3 bi-file-earmark-medical mx-2 ">${efb_var.text.maxfs} <small>(MB)</small> <i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="file_size" > </i></label>

      <input type="number" min="1" max="300" data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1 efb" placeholder=""${efb_var.text.exDot} 8" id="fileSizeMaxEl" required value="${file_size}">
      </div>
      `}





    const fileTypeEls = `
          <label for="fileTypeEl" class="efb  mt-3 bi-file-earmark-medical mx-2 ">${efb_var.text.fileType}</label>
          <select  data-id="${idset}" class="efb  elEdit form-select border-d rounded-4"  id="fileTypeEl" data-tag="${valj_efb[indx].type}">
          <option value="allformat" ${!valj_efb[indx].hasOwnProperty('file') || valj_efb[indx].file == 'allformat' ? `selected` : ''} >${efb_var.text.allformat}</option>
          <option value="document" ${valj_efb[indx].hasOwnProperty('file') && valj_efb[indx].file == 'document' ? `selected` : ''} >${efb_var.text.documents}</option>
          <option value="image" ${valj_efb[indx].hasOwnProperty('file') && valj_efb[indx].file == 'image' ? `selected` : ''}>${efb_var.text.image}</option>
          <option value="media" ${valj_efb[indx].hasOwnProperty('file') && valj_efb[indx].file == 'media' ? `selected` : ''} >${efb_var.text.media}</option>
          <option value="zip" ${valj_efb[indx].hasOwnProperty('file') && valj_efb[indx].file == 'zip' ? `selected` : ''} >${efb_var.text.zip}</option>
          ${ valj_efb[indx].type=='dadfile' ? `<option value="customize" ${valj_efb[indx].hasOwnProperty('file') && valj_efb[indx].file == 'customize' ? `selected` : ''} >${efb_var.text.cstm_rd}</option>` :''}
          </select>
      `

    const fileCustomizeTypleEls =()=>{
      let value =  'jpg, png, pdf';
      let show = 'd-none';

      if(valj_efb[indx].file=="customize"){
        value = valj_efb[indx].file_ctype;
        show = 'd-block';
      }

      return`
      <div class="efb mt-3 ${show}" id="fileCustomizeTypleEls">
      <label for="fileCustomizeTypleEl" class="efb  mt-3 bi-file-earmark-medical mx-2 ">${efb_var.text.file_cstm}</label>
      <input type="text" data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1 efb" placeholder="${efb_var.text.exDot} jpg, png, pdf" id="fileCustomizeTypleEl" required value="${value}">
      </div>
      `

    }

    const selectColorEls = (forEl ,f) => {


      let t = ''
      let color = '';
      let hex=''
      let cls="";
      if (forEl == 'icon') {
        color = valj_efb[indx].icon_color;

        t = efb_var.text.icon;
        if(color!="") hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'icon')
      } else if (forEl == 'description') {
        color = valj_efb[indx].message_text_color;

        t = efb_var.text.description
        if(color!="") hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'description')
      } else if (forEl == 'label') {
        color = valj_efb[indx].label_text_color;

        t = efb_var.text.label
        if(color!="") hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'label')
      } else if (forEl == "el") {
        color = valj_efb[indx].el_text_color;

        t = efb_var.text.field
        if(color!="") hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'el')
      }
      else if (forEl == "clrdoniconEfb") {
        color = valj_efb[0].hasOwnProperty("clrdoniconEfb") ? valj_efb[0].clrdoniconEfb :"#ff4b93" ;

        t = efb_var.text.icon
        hex = color;
        if(color!="" && color.includes('#')==false)  hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'el')
        cls="tnxmsg";
      }
      else if (forEl == "clrdoneMessageEfb") {
        color = valj_efb[0].hasOwnProperty("clrdoneMessageEfb") ? valj_efb[0].clrdoneMessageEfb :"#000000";

        t = efb_var.text.message
        cls="tnxmsg";
        hex = color;
        if(color!="" && color.includes('#')==false)  hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'el')
      }
      else if (forEl == "clrdoneTitleEfb") {
        color = valj_efb[0].hasOwnProperty("clrdoneTitleEfb")? valj_efb[0].clrdoneTitleEfb :"#000000";

        t = efb_var.text.title
        hex = color;
        if(color!="" && color.includes('#')==false) hex=ColorNameToHexEfbOfElEfb(color.slice(5),indx,'el')
        cls="tnxmsg";
      } else if (forEl == "progessbar"){
        color = valj_efb[0].hasOwnProperty("prg_bar_color")==true? valj_efb[0].prg_bar_color :"#4636f1";


         t = efb_var.text.pgbar
         hex = color;
       if(color!="" && color.includes('#')==false){

         hex=ColorNameToHexEfbOfElEfb(color.slice(4),indx,'btn')}

      } else if (forEl == "btnStripe" || forEl == "btnPerisa"){

      }
      addColorTolistEfb(hex);
      return `<span class="efb ${cls}"> <label for="selectColorEl" class="efb mt-3 bi-paint-bucket mx-2 efb">${t} ${efb_var.text.clr}</label>
      <input type="color" id="selectColorEl" class="efb elEdit form-select efb border-d rounded-4" data-id="${idset}" data-el="${forEl}" data-type="${f}"  data-tag="${valj_efb[indx].type}" value="${hex!=''?hex:'#fff000'}" name="selectColorEl"  id="${idset}" ></span>
      `
    }



    const selectMultiSelectEls = `<label for="labelEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.maxSelect}</label>
    <input type="number"  data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1"  placeholder="${efb_var.text.maxSelect}" id="selectMultiSelectMaxEl"  value="${valj_efb[indx].maxSelect ? valj_efb[indx].maxSelect : '2'}" >
    <label for="labelEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.minSelect}</label>
    <input type="number"  data-id="${idset}" class="efb  elEdit form-control text-muted border-d rounded-4 h-d-efb mb-1"  placeholder="${efb_var.text.minSelect}" id="selectMultiSelectMinEl"  value="${valj_efb[indx].minSelect ? valj_efb[indx].minSelect : '0'}" >`







    switch (el.dataset.tag) {
      case 'email':
      case 'text':
      case 'password':
      case 'tel':
      case 'number':
      case 'url':
      case "textarea":
      case 'pdate':
      case 'ardate':
      case 'mobile':
      case 'prcfld':
        body = `
                <div class="efb  mb-3">
                <!--  not   advanced-->
                ${Nadvanced}
                ${placeholderEls}
                ${el.dataset.tag == "mobile" ? smsEnableEls : ''}
                ${el.dataset.tag == "email" ? emailEls : ''}
                ${el.dataset.tag == "mobile" ? ElcountriesListSelections(idset,indx) : ''}
                <!--  not   advanced-->
                <div class="efb  d-grid gap-2">
                  <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
                        <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
                    </button>
                </div>
                <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                        <div class="efb  mb-3 px-3 row">

                        ${labelFontSizeEls}
                        ${selectColorEls('label','text')}
                        ${selectColorEls('description','text')}
                        ${selectColorEls('el','text')}
                        ${selectBorderColorEls('element',indx,idset)}
                        ${ el.dataset.tag != "ardate"  && el.dataset.tag != "pdate" && el.dataset.tag != "mobile"  ? miLenEls() :''}
                        ${el.dataset.tag != "textarea" && el.dataset.tag != "ardate"  && el.dataset.tag != "pdate"  && el.dataset.tag != "mobile" ? mLenEls() :''}

                        ${labelPostionEls}
                        ${ElementAlignEls('label',indx,idset)}
                        ${ElementAlignEls('description',indx,idset)}
                        ${widthEls}
                        ${selectHeightEls(idset,indx)}
                        ${cornerEls('',indx,idset)}
                        ${el.dataset.tag != "textarea" ? valueEls : valueTextereaEls}
                        ${classesEls}
                        ${disabledEls}
                        ${hiddenEls}
                        </div>
                    </div>
                </div><div class="efb  clearfix"></div>
                `
        break;
      case "heading":
        body = `
                <div class="efb  mb-3">
                <!--  not   advanced-->
                ${valueEls}
                ${selectColorEls('el','heading')}
                ${fontSizeEls(idset,indx)}
                ${widthEls}
                ${classesEls}
                <div class="efb  clearfix"></div>
                `
        break;
      case "link":
        body = `
                <div class="efb  mb-3">
                <!--  not   advanced-->
                ${valueEls}
                ${hrefEls(idset,indx)}
                ${selectColorEls('el','link')}
                ${selectHeightEls(idset,indx)}
                ${widthEls}
                ${classesEls}
                <div class="efb  clearfix"></div>
                `
        break;
      case "radio":
      case "checkbox":
      case "select":
      case "multiselect":
      case "conturyList":
      case "stateProvince":
      case "cityList":
      case "payCheckbox":
      case "payRadio":
      case "paySelect":
      case "chlCheckBox":
      case "chlRadio":
      case "payMultiselect":
      case "imgRadio":
      case "trmCheckbox":
        const objOptions = valj_efb.filter(obj => {
          return obj.parent === el.id
        })
        let s = el.dataset.tag;
        let o_c = s=="chlRadio" || s=="chlCheckBox" || s=="payRadio" || s=="payCheckbox" || s=="checkbox" || s=="radio" || s=="trmCheckbox"  ? true :false
        s= s=="payCheckbox" || s=="payRadio" || s=="paySelect" || s=="payMultiselect" ? true :false
        const newRndm = Math.random().toString(36).substr(2, 9);
        let opetions = `<!-- options --!>`;
        const col = s==true ||  form_type_emsFormBuilder=="smart"  ?'col-md-7':'col-md-12'

        if (objOptions.length > 0) {

          const ftyp=el.dataset.tag.includes("pay") ? 'payment':'';
          opetions=  efb_add_opt_setting(objOptions, el ,s ,newRndm ,ftyp)

        }

        body = `
                <div class="efb  mb-3">
                <!--notAdvanced-->
                ${Nadvanced}
                ${el.dataset.tag=="stateProvince" || el.dataset.tag=='cityList' ? countries_list_el_select(el.dataset.tag,idset,indx):""}
                ${el.dataset.tag=='cityList' ? state_list_el_select('statePovListEl',idset,indx):""}
                ${el.dataset.tag=="stateProvince" || el.dataset.tag=='cityList' ? languageSelectPresentEls:""}
                ${ el.dataset.tag == 'multiselect' ||el.dataset.tag == 'payMultiselect'? selectMultiSelectEls :''}
                <div class="efb m-0 p-0 col-md-12 row">
                <div for="optionListefb" class="efb  col-md-6">${efb_var.text.options}
                <button type="button" id="addOption" onClick="add_option_edit_pro_efb('${el.id.trim()}','${el.dataset.tag.trim()}' ,${valj_efb.length})" data-parent="${el.id}" data-tag="${el.dataset.tag}" data-id="${newRndm}"   class="efb btn efb btn-edit btn-sm elEdit" data-bs-toggle="tooltip" title="${efb_var.text.add}" >
                <i class="efb  bi-plus-circle  text-success"></i>
                  </button>
                </div>
                <div class="efb col-md-6 text-darkb align-self-center text-decoration-underline fs-7 show" id="showAtrEls" onClick="funShowAttrElsEfb(this)">${efb_var.text.shwattr}</div>
                </div>

                <div id="optionListeHeadfb" class="efb  mx-1 col-md-12 row ">
                    <div class="efb  col-md-7 text-capitalize">${efb_var.text.title}</div>

                    ${el.dataset.tag.includes('pay')?`<div class="efb  col-md-3">${efb_var.text.price}</div>`:''}
                </div>

                <div class="efb  mb-3"  id="optionListefb" data-idstate="false">
                 ${opetions}
                </div>
                ${qtyPlcEls}
                <!--notAdvanced-->

                <!--advanced-->
                <div class="efb  d-grid gap-2">
                  <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
                    <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
                  </button>
                </div>
                <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                        <div class="efb  mb-3 px-3 row">

                        ${o_c ? optnsStyleEls :''}
                        ${labelFontSizeEls}
                        ${selectColorEls('label','text')}
                        ${selectColorEls('description','text')}
                        ${fun_el_select_in_efb(el.dataset.tag)  ? cornerEls('',indx,idset) : ''}
                        ${fun_el_select_in_efb(el.dataset.tag) ? selectBorderColorEls('element',indx,idset) : ''}
                        ${el.dataset.tag != 'multiselect' && el.dataset.tag != 'payMultiselect' && el.dataset.tag != 'imgRadio'? selectColorEls('el','text') : ''}
                        ${labelPostionEls}
                        ${ElementAlignEls('label',indx,idset)}
                        ${ElementAlignEls('description',indx,idset)}
                        ${widthEls}
                        ${fun_el_select_in_efb(el.dataset.tag) ? selectHeightEls(idset,indx) : ''}
                        ${classesEls}
                        ${disabledEls}
                        ${hiddenEls}
                        </div>
                    </div>

                </div>
                <div class="efb  clearfix"></div>
                `
        break;
      case "date":
      case "color":
      case "range":
      case "esign":
      case "rating":
      case "switch":

        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        ${Nadvanced}
        <!--  not   advanced-->
        <div class="efb  d-grid gap-2">
            <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
              <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
            </button>
        </div>
        <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                <div class="efb  mb-3 px-3 row">

                ${el.dataset.tag == "switch" ?textEls(el.id.trim(),efb_var.text.lson ,'text',valj_efb[indx].on ,'on' ,idset):''}
                ${el.dataset.tag == "switch" ?textEls(el.id.trim(), efb_var.text.lsoff,'text',valj_efb[indx].off,'off',idset):''}
                ${labelFontSizeEls}
                ${selectColorEls('label','text')}
                ${selectColorEls('description','text')}

                ${el.dataset.tag == 'rating' || el.dataset.tag == 'range'  || el.dataset.tag == 'switch' ? "" : selectBorderColorEls('element',indx,idset)}
                ${labelPostionEls}
                ${ElementAlignEls('label',indx,idset)}
                ${ElementAlignEls('description',indx,idset)}
                ${el.dataset.tag == "range" || el.dataset.tag == "date" ?miLenEls():''}
                ${el.dataset.tag == "range" || el.dataset.tag == "date" ? mLenEls() :''}
                ${el.dataset.tag == "range" ?valueEls:''}


                ${el.dataset.tag == 'rating' ? '' : widthEls}
                ${el.dataset.tag != 'range' ? selectHeightEls(idset,indx) :''}
                ${el.dataset.tag == 'rating' || el.dataset.tag == 'switch' || el.dataset.tag == 'range' ? '' : cornerEls('',indx,idset)}
                ${/* el.dataset.tag == 'esign' ? selectColorEls('icon') : '' */ ''}
                ${el.dataset.tag == 'esign' ? iconEls('') : ''}
                ${el.dataset.tag == 'esign' ? btnColorEls(idset,indx) : ''}
                ${el.dataset.tag == 'esign' ? SingleTextEls('',idset,indx) : ''}
                ${disabledEls}
                ${hiddenEls}
                </div>
            </div>
        </div><div class="efb  clearfix"></div>
        `
        break;
      case "file":
      case "dadfile":

        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        ${Nadvanced}
        ${fileTypeEls }
        ${el.dataset.tag == 'dadfile' ? fileCustomizeTypleEls() : '<!--efb.app-->'}
        ${fileSizeMaxEls()}
        <!--  not   advanced-->
        <div class="efb  d-grid gap-2">
          <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
            <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
          </button>
        </div>
        <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                <div class="efb  mb-3 px-3 row">

                ${labelFontSizeEls}
                ${selectColorEls('label','text')}
                ${selectColorEls('description','text')}
                ${el.dataset.tag == 'dadfile' ? selectColorEls('icon','text') : ''}
                ${el.dataset.tag == 'dadfile' ? btnColorEls(idset,indx) : ''}
                ${selectBorderColorEls('element',indx,idset)}
                ${labelPostionEls}
                ${ElementAlignEls('label',indx,idset)}
                ${ElementAlignEls('description',indx,idset)}
                ${widthEls}
                ${selectHeightEls(idset,indx)}
                ${cornerEls("",indx,idset)}
                ${classesEls}
                ${disabledEls}
                ${hiddenEls}
                <!-- select type of file -->
                </div>
            </div>
        </div><div class="efb  clearfix"></div>
        `
        break;
      case "maps":


        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        ${Nadvanced}
        <label for="letEl" class="efb  form-label  mt-2">${efb_var.text.latitude}</label>
        <input type="text" data-id="${idset}" class="efb elEdit text-muted form-control border-d rounded-4 efb h-d-efb mb-1" placeholder="${efb_var.text.exDot} 49.24803870604257" id="letEl" required value="${valj_efb[indx].lat}">
        <label for="lonEl" class="efb  form-label  mt-2">${efb_var.text.longitude}</label>
        <input type="text" data-id="${idset}" class="efb elEdit text-muted form-control border-d rounded-4 efb h-d-efb mb-1" placeholder="${efb_var.text.exDot}  -123.10512829684463" id="lonEl" required value="${valj_efb[indx].lng}">
        <label for="lonEl" class="efb  form-label  mt-2">${efb_var.text.zoom}</label>
        <input type="text" data-id="${idset}" class="efb elEdit text-muted form-control border-d rounded-4 efb h-d-efb mb-1" placeholder="13 " id="zoomMapEl" required value="${valj_efb[indx].zoom}">
        <label for="marksEl" class="efb  form-label  mt-2">${efb_var.text.points.toUpperCase()}
        <i class="efb bi-patch-question fs-7 text-success pointer-efb ec-efb" data-eventform="links" data-linkname="pickupByUser"> </i>
        </label>
        <input type="text" data-id="${idset}" class="efb elEdit text-muted form-control border-d rounded-4 efb h-d-efb mb-1" placeholder=${efb_var.text.exDot}  1" id="marksEl" required value="${valj_efb[indx].mark}">
        <!--  not   advanced-->
        <div class="efb  d-grid gap-2">
          <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
            <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
          </button>
        </div>
        <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                <div class="efb  mb-3 px-3 row">

                ${labelPostionEls}
                ${ElementAlignEls('label',indx,idset)}
                ${ElementAlignEls('description',indx,idset)}
                ${widthEls}
                ${labelFontSizeEls}
                ${selectColorEls('label','text')}
                ${selectColorEls('description','text')}
                ${disabledEls}
                ${hiddenEls}
                </div>
            </div>
        </div><div class="efb  clearfix"></div>
        `

        break;
      case "html":
        let valHTML = valj_efb[indx].value.replace(/@!/g,`"`);
         valHTML = valj_efb[indx].value.replace(/@efb@nq#/g,`\n`);

        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        <label for="htmlCodeEl" class="efb  form-label mt-2 mb-1"><i class="efb  bi-code-square mx-2" ></i>${efb_var.text.code}</label>
        <small class="efb text-info text-danger bg-muted  efb">${efb_var.text.pleaseDoNotAddJsCode}</small>
        <textarea placeholder="${efb_var.text.htmlCode}"
        class="efb elEdit form-control efb  h-d-efb   mb-1"
         data-id="${valj_efb[indx].id_}" id="htmlCodeEl" rows="13" >${valHTML}</textarea>
        </div><div class="efb  clearfix"></div>
        `
        break;
      case "yesNo":
        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        ${Nadvanced}
        <!--  not   advanced-->
        <div class="efb  d-grid gap-2">
          <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
            <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
          </button>
        </div>
        <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                <div class="efb  mb-3 px-3 row">
                ${labelFontSizeEls}
                ${selectColorEls('label','text')}
                ${selectColorEls('description','text')}
                ${selectColorEls('el','text')}
                ${btnColorEls(idset,indx)}
                ${labelPostionEls}
                ${ElementAlignEls('label',indx,idset)}
                ${ElementAlignEls('description',indx,idset)}

                ${widthEls}
                ${selectHeightEls(idset,indx)}
                ${cornerEls('yesNo',indx,idset)}
                <label for="valueEl" class="efb  mt-3 mb-0 bi-cursor-text mx-2">${efb_var.text.button1Value}</label>
                <input type="text"  data-id="${idset}" class="efb elEdit border-d rounded-4 text-muted form-control efb mb-3" id="valueEl" data-tag="yesNo" data-no="1" placeholder="${efb_var.text.exDot} ${efb_var.text.yes}" value="${valj_efb[indx].button_1_text}">
                <label for="valueEl" class="efb  mt-0 mb-1 bi-cursor-text mx-2">${efb_var.text.button2Value}</label>
                <input type="text"  data-id="${idset}" class="efb elEdit border-d rounded-4 text-muted form-control efb mb-3" id="valueEl" data-tag="yesNo" data-no="2" placeholder="${efb_var.text.exDot} ${efb_var.text.no}" value="${valj_efb[indx].button_2_text}">
                ${classesEls}
                ${disabledEls}
                ${hiddenEls}
                </div>
            </div>
        </div><div class="efb  clearfix"></div>
        `
        break;
      case "ttlprc":
        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        ${Nadvanced}
        ${currencyTypeEls(idset)}
        <!--  not   advanced-->
        <div class="efb  d-grid gap-2">
          <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
            <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
          </button>
        </div>
        <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                <div class="efb  mb-3 px-3 row">
                ${labelFontSizeEls}
                ${selectColorEls('label','text')}
                ${selectColorEls('description','text')}
                ${selectColorEls('el','text')}

                ${labelPostionEls}
                ${ElementAlignEls('label',indx,idset)}
                ${ElementAlignEls('description',indx,idset)}

                ${widthEls}
                ${selectHeightEls(idset,indx)}

                ${classesEls}
                ${hiddenEls}
                </div>
            </div>
        </div><div class="efb  clearfix"></div>
        `
        break;
      case "booking":
        break;
      case "steps":

        idset=Number(idset);
        const logic_steps =idset>1 && false ? logic_section(idset) :"<!--efb-->";
        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
        ${labelEls}
        ${desEls}


        </div>
        <!--  not   advanced-->
        <div class="efb  d-grid gap-2">
          <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
            <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
          </button>
        </div>
        <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
                <div class="efb  mb-3 px-3 row">
                ${iconEls('')}

                ${selectColorEls('label','text')}
                ${selectColorEls('description','text')}
                ${selectColorEls('icon','text')}
                ${classesEls}
                </div>
            </div>
        </div>
        ${logic_steps}
        <div class="efb  clearfix"></div>
        `
        break;
      case "buttonNav":

        let content = `
        ${SingleTextEls('',idset,indx)}
        ${iconEls('')}
        ${selectColorEls('el','text')}
        ${selectColorEls('icon','text')}
        ${btnColorEls(idset,indx)}
        ${ElementAlignEls('buttons',indx,idset)}
        ${cornerEls('Next',indx,idset)}
        ${selectHeightEls(idset,indx)}
        `


        if (valj_efb[0].button_state != "single") {
          content = `
             ${SingleTextEls("Previous",idset,indx)}
             ${iconEls("Previous")}
             ${SingleTextEls("Next",idset,indx)}
             ${iconEls("Next")}
             ${selectColorEls('el','text')}
             ${selectColorEls('icon','text')}
             ${btnColorEls(idset,indx)}
             ${ElementAlignEls('buttons',indx,idset)}
             ${cornerEls('Next',indx,idset)}
             ${selectHeightEls(idset,indx)}
             `
        }
        body = `
        <div class="efb  mb-3">
        <!--  not   advanced-->
                    ${content}
        </div>
        `
        break;
      case 'formSet':
        body = `
          <label for="formNameEl" class="efb form-label mt-2 mb-1 efb">${efb_var.text.formName}<span class="efb  mx-1 efb text-danger">*</span></label>
           <input type="text"  data-id="${idset}" class="efb elEdit text-muted form-control efb  h-d-efb  mb-1"  placeholder="${efb_var.text.formName}" id="formNameEl" required value="${valj_efb[0].formName}">
          ${trackingCodeEls}
          ${captchaEls}
          ${showSIconsEls}
          ${showSprosiEls}
          ${showformLoggedEls}
          ${cardEls}
          ${offLineEls}
          ${adminFormEmailEls}
          ${FormEmailSubjectEls()}
          ${valj_efb[0].type=="form" || valj_efb[0].type=="payment" ?  EmailNotiContainsEls() :'<!--efb-->'}
          ${selectColorEls('progessbar','btn')}


          <!-- sms section --!>
            <div class="efb  d-grid gap-2">
              <button class="efb btn btn-outline-light mt-3" id="sms_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSMS" aria-expanded="false" aria-controls="collapseSMS">
              <i class="efb   bi-chat-left-dots me-1" id="sms_collapse_id"></i>${efb_var.text.sms}
              </button>
            </div>
            <div class="efb mb-3 mt-3 collapse" id="collapseSMS">
                <div class="efb  mb-3 px-3 row">
                ${smsEnableEls}
                ${smsAdminsPhoneNoEls()}
                ${`<span class="efb  my-3 fs-7 smsmsg ${valj_efb[0].hasOwnProperty('smsnoti') && Number(valj_efb[0].smsnoti) == 1 ? '' : 'd-none'}">${efb_var.text.messages}</span>`}
                ${smsContentEls('newMessageReceived')}
                ${valj_efb[0].type!="login" && valj_efb[0].type!="register" ? smsContentEls('WeRecivedUrM') :''}
                ${valj_efb[0].type!="login" && valj_efb[0].type!="register" ? smsContentEls('responsedMessage') :''}

                </div>
                </div>
            </div>
        <!-- sms section  end --!>
          <!-- condi section
            <div class="efb  d-grid gap-2">
              <button class="efb btn btn-outline-light mt-3" id="login_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseLogic" aria-expanded="false" aria-controls="collapseLogic">
              <i class="efb   bi-chat-left-dots me-1" id="sms_collapse_id"></i>${efb_var.text.conlog}
              </button>
            </div>
            <div class="efb mb-3 mt-3 collapse" id="collapseLogic">
                <div class="efb  mb-3 px-3 row">
                ${enableConEls}

                </div>
                </div>
            </div>
            --!>
        <!-- condi section  end --!>
          <div class="efb  d-grid gap-2">
            <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
            <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
            </button>
          </div>
          <div class="efb mb-3 mt-3 collapse show" id="collapseAdvanced">
              <div class="efb  mb-3 px-3 row">
          ${thankYouTypeEls}
          ${valj_efb[0].type!="login" ? iconEls('tnx'):''}
          ${valj_efb[0].type!="register" && valj_efb[0].type!="login" ? thankYouMessageDoneEls :''}
          ${valj_efb[0].type!="login" ? thankYouMessageEls :''}
          ${valj_efb[0].type!="register" && valj_efb[0].type!="login"  ? thankYouMessageConfirmationCodeEls :''}
          ${valj_efb[0].type!="login" ?selectColorEls('clrdoneTitleEfb','text'):''}
          ${valj_efb[0].type!="login" ?selectColorEls('clrdoniconEfb','text'):''}
          ${valj_efb[0].type!="login" ?selectColorEls('clrdoneMessageEfb','text'):''}
          ${thankYouredirectEls}
          ${formTypeEls()}
         <!-- content_colors_setting_efb() -->
          </div>
          </div>
      </div>

      <div class="efb  clearfix"></div>

          `
        break;
      case 'stripe':


        body = `<div class="efb  mb-3">
        <!--  not   advanced-->
          <h2 class="efb  text-muted">${efb_var.text.stripe}</h2>
          ${valj_efb[0].type=="payment" ? currencyTypeEls(idset) :''}
          ${valj_efb[0].type=="payment" ? paymentMethodEls(idset) :''}
        <div class="efb  clearfix"></div>
        </div>`

        break;
        case 'persiaPay':
          body = `<div class="efb  mb-3">
          <h2 class="efb  text-muted">${efb_var.text.paymentGateway}</h2>
          <!--  not   advanced-->
                ${valj_efb[0].type=="payment" ? currencyPersianPayEls :''}
            ${valj_efb[0].type=="payment" ? paymentPersianPayEls(idset) :''}
          <div class="efb  clearfix"></div>
          </div>`
        break;
        case "table_matrix":









          const obj_r_matrix = valj_efb.filter(obj => {
            return obj.parent === el.id
          })


          const newRndmm = Math.random().toString(36).substr(2, 9);
          let r_matrixs = `<!-- options --!>`;


          if (obj_r_matrix.length > 0) {


            for (let ob of obj_r_matrix) {
              let cont = ` <div class="efb  btn-edit-holder newop" id="deleteOption" data-parent_id="${ob.parent}">
                <button type="button" id="deleteOption"  onClick="delete_option_efb('${ob.id_op}')" data-parent="${el.id}" data-tag="${el.dataset.tag}"  data-id="${ob.id_op}" class="efb btn efb btn-edit btn-sm elEdit" data-bs-toggle="tooltip" title="${efb_var.text.delete}">
                    <i class="efb  efb bi-x-lg text-danger"></i>
                </button>
                <button type="button" id="addOption" onClick="add_r_matrix_edit_pro_efb('${el.id.trim()}','${el.dataset.tag.trim()}' ,${valj_efb.length})" data-parent="${el.id}" data-tag="${el.dataset.tag}" data-id="${newRndmm}" class="efb btn efb btn-edit btn-sm elEdit" data-bs-toggle="tooltip" title="${efb_var.text.add}" >
                    <i class="efb  bi-plus-circle  text-success"></i>
                </button>

              </div>`
              r_matrixs += `<div id="${ob.id_op}-gs" class="efb mx-0 col-sm-12 row opt">
              <div id="${ob.id_op}-v" class="efb col-sm-12 mx-0 px-0">
              <input type="text" placeholder="${efb_var.text.name}" id="EditOption"  value="${ob.value}" data-parent="${el.id}" data-op="${el.id}" data-id="${ob.id_op}" data-tag="${el.dataset.tag}" class="efb  col-md-12  text-muted mb-1 fs-6 border-d rounded-4 elEdit">
              ${cont}
              </div>
              </div>`
            }
          }


          body = `
                    <div class="efb  mb-3">
                    <!--notAdvanced-->
                    ${Nadvanced}


                    ${el.dataset.tag == 'multiselect' || el.dataset.tag == 'payMultiselect' ? selectMultiSelectEls : ''}
                    <label for="optionListefb" class="efb  ">${efb_var.text.options}

                    </label>
                    <div id="optionListeHeadfb" class="efb  mx-1 col-md-12 row ">
                        <div class="efb  col-md-7 text-capitalize">${efb_var.text.title}</div>
                    </div>
                    <div class="efb  mb-3" id="optionListefb" data-idstate="false">
                     ${r_matrixs}
                    </div>
                    ${type_field_efb == "radio" ? addOtherslEls : ''}
                    <!--notAdvanced-->

                    <!--advanced-->
                    <div class="efb  d-grid gap-2">
                      <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
                        <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
                      </button>
                    </div>
                    <div class="efb mb-3 mt-3 collapse  d-none" id="collapseAdvanced">
                            <div class="efb  mb-3 px-3 row">

                            ${labelFontSizeEls}




                            ${labelPostionEls}
                            ${ElementAlignEls('label',indx,idset)}
                            ${ElementAlignEls('description',indx,idset)}
                            ${widthEls}

                            ${classesEls}
                            </div>
                        </div>

                    </div>
                    <div class="efb  clearfix"></div>
                    `
          break;
        case "pointr10":
        case "pointr5":

              body = `
                        <div class="efb  mb-3">
                        <!--  not   advanced-->
                        ${Nadvanced}
                        <!--  not   advanced-->
                        <div class="efb  d-grid gap-2">
                          <button class="efb btn btn-outline-light mt-3" id="advanced_collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdvanced" aria-expanded="true" aria-controls="collapseAdvanced">
                           <i class="efb  bi-arrow-down-circle-fill me-1" id="advanced_collapse_id"></i>${efb_var.text.advanced}
                          </button>
                        </div>
                        <div class="efb mb-3 mt-3 collapse  d-none" id="collapseAdvanced">
                                <div class="efb  mb-3 px-3 row">
                                ${labelPostionEls}
                                ${ElementAlignEls('label',indx,idset)}
                                ${ElementAlignEls('description',indx,idset)}
                                ${widthEls}
                                ${classesEls}
                                </div>
                            </div>
                        </div><div class="efb  clearfix"></div>
                        `
              break;

    }







    document.getElementById('sideMenuConEfb').innerHTML=body;

    for (const el of document.querySelectorAll(`.elEdit`)) {
      if(el.tagName!="DIV"){el.addEventListener("change", (e) => { change_el_edit_Efb(el);})}
      else{ }
    }

  }



function remove_other_noti_Efb(){
  window.onload=(()=>{

      setTimeout(() => {
          for (const el of document.querySelectorAll(".notice")) {
               if(!el.classList.contains('efb'))el.remove()
          }
      },50)
  })
}


function creator_form_builder_Efb() {
  remove_other_noti_Efb()
  if (valj_efb.length < 2) {
    const btn_pois = Number(efb_var.rtl) == 1 ? 'justify-content-center' : 'justify-content-center';
    step_el_efb = 1;
    const smail =efb_var.setting.emailSupporter!=''  ? true :false
    valj_efb.push({
      type: form_type_emsFormBuilder, steps: 1, formName: efb_var.text.form, email: efb_var.setting.emailSupporter, trackingCode: true, EfbVersion: 2,
      button_single_text: efb_var.text.submit, button_color: pub_bg_button_color_efb, icon: 'bi-ui-checks-grid', button_Next_text: efb_var.text.next, button_Previous_text: efb_var.text.previous,
      button_Next_icon: 'bi-chevron-right', button_Previous_icon: 'bi-chevron-left', button_state: 'single',  label_text_color: pub_label_text_color_efb,
      el_text_color: pub_txt_button_color_efb, message_text_color: pub_message_text_color_efb, icon_color: pub_txt_button_color_efb, el_height: 'h-d-efb', email_to: false, show_icon: true,
      show_pro_bar: true, captcha: false, private: false, sendEmail: smail, font: true, stateForm: 0,dShowBg:true, btns_align: btn_pois,
      thank_you: 'msg',
      thank_you_message: { icon: 'bi-hand-thumbs-up', thankYou: efb_var.text.thanksFillingOutform, done: efb_var.text.done, trackingCode: efb_var.text.trackingCode, error: efb_var.text.error, pleaseFillInRequiredFields: efb_var.text.pleaseFillInRequiredFields }, email_temp: '', font: true,
    });

    if (form_type_emsFormBuilder == "payment") {
      Object.assign(valj_efb[0], { getway: 'stripe', currency: 'usd', paymentmethod: 'charge' })
    }

  }


  let els = "<!--efb.app-->";
  let dragab = true;
  let disable = "disable";
  let formType = valj_efb[0].type

  const ond = `onClick="alert_message_efb('${efb_var.text.error}','${efb_var.text.thisElemantNotAvailable}',7,'danger')"`
  if (formType == "login") {
    dragab = false;
    disable = ond;

  }

  if( efb_var.language=='fa_IR')fields_efb.push( { name: efb_var.text.persiaPayment, icon: 'bi-credit-card-2-front', id: 'persiaPay', pro: true, tag:'payment all' });
  for (let ob of fields_efb) {

    if (formType == "login") { if (ob.id == "html" || ob.id == "link" || ob.id == "heading") { dragab = true; disable = "disable" } else { dragab = false; disable = ond } }

    if(ob.id=="stripe" && efb_var.addons.AdnSPF !=1){

      disable = `onClick="alert_message_efb('${efb_var.text.error}', '${efb_var.text.IMAddonP}', 20 , 'info')"`
      dragab = false;
    }else if(ob.id=="persiaPay" && efb_var.addons.AdnPPF !=1){

      disable = `onClick="alert_message_efb('${efb_var.text.error}', '${efb_var.text.IMAddonP}', 20 , 'info')"`
      dragab = false;
    }else if (ob.id=="pdate" && (efb_var.addons.hasOwnProperty('AdnPDP')==false || efb_var.addons.AdnPDP !=1)){

      disable = `onClick="alert_message_efb('${efb_var.text.iaddon}', '${efb_var.text.IMAddonPD}', 20 , 'info')"`
      dragab = false;
    }else if (ob.id=="ardate" && (efb_var.addons.hasOwnProperty('AdnADP')==false || efb_var.addons.AdnADP !=1)){

      disable = `onClick="alert_message_efb('${efb_var.text.iaddon}', '${efb_var.text.IMAddonAD}', 20 , 'info')"`
      dragab = false;
    }
    els += `
    <div class="efb tag efb-col-3 draggable-efb ${ob.tag}" draggable="${dragab}" id="${ob.id}" ${mobile_view_efb ? `onClick="add_element_dpz_efb('${ob.id}')"` : ''}>
     ${ob.pro == true && pro_efb == false ? ` <a type="button"  onClick='pro_show_efb(1)' class="efb pro-version-efb" data-bs-toggle="tooltip" data-bs-placement="top" title="${efb_var.text.fieldAvailableInProversion}" data-original-title="${efb_var.text.fieldAvailableInProversion}"><i class="efb  bi-gem text-light"></i></a>` : ''}
      <button type="button" class="efb btn efb btn-select-form float-end ${disable != "disable" ? "btn-muted" : ''}" id="${ob.id}_b" ${disable}><i class="efb  ${ob.icon}"></i><span class="efb d-block text-capitalize">${ob.name}</span></button>
    </div>
    `
    dragab = true;
    disable = "disable";
  }

  let navs = [
    { name: efb_var.text.save, icon: 'bi-save ec-efb', fun: `saveFormEfb(1)` },
    { name: efb_var.text.pcPreview, icon: 'bi-display ec-efb', fun: `previewFormEfb('pc')` },
    { name: efb_var.text.formSetting, icon: 'bi-sliders ec-efb', fun: `show_setting_window_efb('formSet')` },
    { name: efb_var.text.help, icon: 'bi-question-lg ec-efb', fun: `Link_emsFormBuilder('createSampleForm')` },
    { name: efb_var.text.prvnt, icon: 'bi-box-arrow-up-right ec-efb', fun: `previewFormEfb('new')` }

  ]
  let nav = "<!--efb.app-->";
  const st = document.getElementById('navbarSupportedContent') ? 1 :0;
  for (let ob in navs) {
    if( typeof navs[ob] == 'object') {
      nav += `<li id='NavBtnEFB-${ob}' class="efb nav-item ${ob == 4 && st!=1 ? 'd-none' : ''}"><a class="efb nav-link efb btn text-capitalize ${ob == 2 ? 'BtnSideEfb' : ''} ${ob != 0 ? '' : 'btn-outline-pink'}  " ${navs[ob].fun.length > 2 ? `onClick="${navs[ob].fun}""` : ''} ><i class="efb ${navs[ob].icon} mx-1 "></i>${navs[ob].name}</a></li>`;
    }
  }

  document.getElementById(`content-efb`).innerHTML = `
  <div class="efb ${mobile_view_efb ? 'my-2 mx-1' : 'my-2 mx-0'}" id="pCreatorEfb" >
  <div id="panel_efb">
      <nav class="efb navbar navbar-expand-lg navbar-light bg-light my-2 bg-response efb">
          <div class="efb container-fluid">
              <button class="efb navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarTogglerDemo01" aria-controls="navbarTogglerDemo01" aria-expanded="false" aria-label="Toggle navigation"><span class="efb navbar-toggler-icon"></span></button>
              <div class="efb collapse navbar-collapse py-1" id="navbarTogglerDemo01"><ul class="efb navbar-nav me-auto mb-2 mb-lg-0">${nav}</ul></div>
          </div>
      </nav>
      <div class="efb row">
      <!-- over page -->
      <div id="overlay_efb" class="efb d-none">${efbLoadingCard('bg-white')}</div>
      <!--end  over page -->
          <div class="efb  col-md-4" id="listElEfb">

            <ul class="efb my-2 row" id="listCatEfb">
                <li class="efb efb-col-3">
                  <a class="efb nav-link cat fs-6 efb active all" aria-current="page" onclick="funUpdateLisetElEfb('all')" role="button">${efb_var.text.all}</a>
                </li>
                <li class="efb efb-col-3">
                  <a class="efb nav-link cat fs-6 efb basic" onclick="funUpdateLisetElEfb('basic')"  role="button">${efb_var.text.basic}</a>
                </li>
                <li class="efb efb-col-3">
                  <a class="efb nav-link cat fs-6 efb payment" onclick="funUpdateLisetElEfb('payment')"  role="button">${efb_var.text.payment}</a>
                </li>
                <li class="efb efb-col-3">
                  <a class="efb nav-link cat fs-6 efb advance" onclick="funUpdateLisetElEfb('advance')"  role="button">${efb_var.text.advanced}</a>
                </li>
                <hr class="efb hr">
            </ul>
          <div class="efb row">${els}</div></div>
         <div class="efb  col-md-8 body-dpz-efb"><div class="efb crd efb  drag-box"><div class="efb card-body dropZoneEFB row items px-0 mx-0" id="dropZoneEFB">

        <div id="efb-dd" class="efb text-center ">
        <h1 class="efb text-muted display-1  bi-plus-circle-dotted"> </h1>
        <div class="efb text-muted fs-5 efb">${!mobile_view_efb ? efb_var.text.dadFieldHere : ''}</div>
        </div>

         </div></div></div></div>
      </div>
  <div class="efb modal fade " id="settingModalEfb" aria-hidden="true" aria-labelledby="settingModalEfb"  role="dialog" tabindex="-1" data-backdrop="static" >
      <div class="efb modal-dialog modal-dialog-centered " id="settingModalEfb_" >
          <div class="efb modal-content efb " id="settingModalEfb-sections">
                  <div class="efb modal-header efb"> <h5 class="efb modal-title efb" ><i class="efb bi-ui-checks mx-2" id="settingModalEfb-icon"></i><span id="settingModalEfb-title" class="efb fs-3">${efb_var.text.editField}</span></h5></div>
                  <div class="efb modal-body" id="settingModalEfb-body">
                     ${efbLoadingCard('')}
                  </div>
  </div></div></div>
  </div></div>

  `

  create_dargAndDrop_el();
  items_dd_efb();
}

function funUpdateLisetElEfb(cat){
  change_active_cat_efb(cat);
  change_visible_el_efb(cat);


}

 change_active_cat_efb=(cat)=>{
  let els = document.querySelectorAll('.efb.cat');
  for(let i =0;i<els.length;i++){
    els[i].classList.remove('active');
    els[i].classList.contains(cat) ? els[i].classList.add('active') : '';
  }

}
change_visible_el_efb=(cat)=>{
  let els = document.querySelectorAll('.efb.tag');
  for(let i =0;i<els.length;i++){
    els[i].classList.remove('d-none');
    els[i].classList.contains(cat) ? '' : els[i].classList.add('d-none');
  }
}

function funUpdateLisetcardTitleEfb(cat){
  change_active_cat_efb(cat);
  change_visible_el_efb(cat);
}


items_dd_efb = () => {
  jQuery(function () {

    jQuery(".items").sortable({

      items: "setion:not(.unsortable)",
      start: function (event, ui) {
        ui.item.toggleClass("highlight");
        if (ui.item.hasClass('unsortable')) {
          return;
        }
      },
      stop: function (event, ui) {
        ui.item.hasClass('ui-state-disabled') ? ui.item.removeData('sortableItem') : false;
        ui.item.toggleClass("highlight");
        sort_obj_el_efb_();
      }
    });
    jQuery("#items").disableSelection();
  });
}

items_dd_refresh_efb = () => {
  jQuery(function () {
    jQuery(".items").sortable("refresh");
  })
}

efb_powered_by=()=>{
  const ws = efb_var.language != "fa_IR" ? "https://whitestudio.team/" : 'https://easyformbuilder.ir';
  return `<div class="efb fs-8 p-0  m-0 text-muted btn" id="wpfooter"><a href="https://wordpress.org/plugins/easy-form-builder/" target="_blank" class="efb nounderline">Easy Form Builder</a> Powered by <a href="https://wordpress.org/plugins/easy-form-builder/" target="_blank" class="efb nounderline">WordPress</a>, <a href="https://getbootstrap.com/" target="_blank" class="efb nounderline">Bootstrap</a> and Bootstrap Icon. Created by <a href="${ws}" target="_blank" class="efb nounderline">Whitestudio.team</a></div>`;
}


efb_add_opt_setting= (objOptions, el ,s ,newRndm ,ftyp)=>{
 const col = s==true ||  form_type_emsFormBuilder=="smart"  ?'col-sm-7':'col-sm-12'

 let t = "radio";

 let opetions = `<!-- options --!>`;
 let parent = valj_efb.find(x=>x.id_ == objOptions[0].parent)
 const vl =parent ? parent.value :'';
  let l_b = mobile_view_efb ? 'd-block' : 'd-none';
  const tp = parent.type.toLowerCase();

 for (let ob of objOptions) {
   if(parent){
     if(tp.indexOf("multi")>-1  || tp.includes("checkbox")==true || tp.includes("multiselect")==true  ) t="checkbox"

   }
    const price = ob.hasOwnProperty("price") ? ob.price : 0;

    const id = ob.hasOwnProperty('id') ? ob.id : ob.id_;
    const id_old = ob.hasOwnProperty("id_old") ? ob.id_old :'null'
    let checked= "";



    if((tp.includes("radio")==true ||( tp.includes("select")==true &&  tp.includes("multi")==false))  && (vl == id || vl==id_old)){ checked="checked";
    }else if((tp.includes("multi")==true || tp.includes("checkbox")==true) &&  typeof vl!="string" &&  vl.findIndex(x=>x==id || x==id_old)!=-1 ){checked="checked"
    }else if((tp.includes("stateprovince")==true || tp.includes("conturylist")==true) &&  (vl==id || vl==id_old) ){checked="checked"}

    opetions +=add_option_edit_admin_efb(price,parent.id_,t,ob.id_op,el.dataset.tag.trim(),ob.id_ob,ob.value,col,s,l_b,ftyp,id,checked)
  }
  return opetions
}


const add_option_edit_admin_efb=(price,parentsID,t,idin,tag,id_ob,value,col,s,l_b,ftyp,id_value,checked)=>{

  const fun_imgRadio =()=>{
    let r ='<!-efb-->'
    const u = (url)=>{
      url = url.replace(/(http:@efb@)+/g, 'http://');
      url = url.replace(/(https:@efb@)+/g, 'https://');
      url = url.replace(/(@efb@)+/g, '/');

      return url;
     }

    if(tag=="imgRadio"){
      let row = valj_efb.find(x=>x.id_==id_value);

      if (typeof row == "undefined") r ='<!-efb-->';
      const url = u(row.src);
      r =`
      <input type="text" placeholder="${efb_var.text.description}" id="imgRadio_sub_value"  value="${row.sub_value}" data-value="${value}" data-parent="${parentsID}" data-id="${idin}" data-tag="${tag}" class="efb  ${col}  text-muted mb-1 fs-6 border-d rounded-4 elEdit" >
      <input type="text" placeholder="${efb_var.text.iimgurl}" id="imgRadio_url"  value="${url}" data-value="${url}" data-parent="${parentsID}" data-id="${idin}" data-tag="${tag}" class="efb  ${col}  text-muted mb-1 fs-6 border-d rounded-4 elEdit" >
      `
    }

    return r ;
  }
  const fun_bookingAttr =()=>{
    let r ='<!-efb-->'


    if(valj_efb[0].hasOwnProperty('booking')==true && valj_efb[0].booking==true && (tag=='radio' || tag=='checkbox' || tag=='select' || tag=='imgRadio')){
      let row = valj_efb.find(x=>x.id_==id_value);

      if (typeof row == "undefined") r ='<!-efb-->';

      const date_v =row.hasOwnProperty('dateExp') && row.dateExp.length>1 ? row.dateExp : '';
      r =`
      <input type="date" placeholder="${efb_var.text.date}" id="bookDateExpEl"  value="${date_v}" data-value="${date_v}" data-id="${row.id_}" data-parent="${parentsID}" data-id="${idin}" data-tag="${tag}" class="efb  ${col}  text-muted mb-1 fs-6 border-d rounded-4 elEdit" >
      <input type="number" data-id="${row.id_}" class="efb elEdit form-control text-muted efb border-d rounded-4 h-d-efb mb-1" placeholder="${efb_var.text.max}" id="mLenEl" required value="${row.hasOwnProperty('mlen') ? row.mlen : ''}" >
      `
    }

    return r ;
  }
  const imgRadio = fun_imgRadio();
  const booking = fun_bookingAttr();
  const s_show_id = document.getElementById('optionListefb') && document.getElementById('optionListefb').dataset.idstate =="true" ? true : false;
  let id_v = `  <div class="efb mx-0 px-0 col-sm-12 elIds ${s_show_id==true ? '' :'d-none'}">
    <label  for="ElIdOptions" class="efb form-label mx-1 my-0 py-0 fs-6 col-sm-2 " >${efb_var.text.id}</label>
    <input type="text" placeholder="${efb_var.text.id}" id="ElIdOptions"  value="${id_value}" data-parent="${parentsID}" data-id="${idin}" data-tag="${tag}" class="efb  text-muted mb-1 fs-7 border-d rounded-4 elEdit col-sm-9">

    </div>`
    row_col_size ='col-sm-11'
    const selected_options =() =>{
      if(tag=="table_matrix"){
        row_col_size ='col-sm-12'
        return `<!--efb--!>`;
      }
      return    `
      <div id="" class="efb mx-0 px-0 col-sm-1 form-check">
      <input class="efb  emsFormBuilder_v form-check-input  fs-6 m-0 p-0 elEdit" name="${parentsID}-g" type="${t}" data-parent="${parentsID}" data-id="${idin}" data-tag="${tag}" id="ElvalueOptions" ${checked}>
      <label  for="ElvalueOptions" class="efb form-label mx-1 my-0 py-0 ${l_b} fs-6" >${efb_var.text.dslctd}</label>
      </div>
      `

        }

  return `<div class="efb mx-0 col-sm-12 row opt" id="${idin}-gs">
  ${selected_options()}
  <div id="${id_ob}-v" class="efb ${row_col_size} mx-0 px-0">
  <input type="text" placeholder="${efb_var.text.name}" id="EditOption"  value="${value}" data-value="${value}" data-parent="${parentsID}" data-op="${idin}" data-id="${idin}" data-tag="${tag}" class="efb  ${col}  text-muted mb-1 fs-6 border-d rounded-4 elEdit" >
  ${imgRadio}
  ${booking}
  ${s==true ? `<label  for="paymentOption" class="efb form-label mx-1 ${l_b} fs-6 col-sm-6 my-0 py-0"">${efb_var.text.price}</label><input type="number" placeholder="$"  value='${typeof price=="string" ? price : 0}' data-value="" min="0" id="paymentOption" data-parent="${parentsID}" data-id="${idin}" data-tag="${tag}-payment"  class="efb  ${ mobile_view_efb ? "col-sm-6" :"col-sm-2"} text-muted mb-1 fs-6 border-d rounded-4 elEdit">` :''}
  <div class="efb  btn-edit-holder ${ftyp=="payment" ||  ftyp=="smart" ?'pay':'newop' }" id="deleteOption" data-parent_id="${parentsID}">
  <button type="button" id="deleteOption"  onClick="delete_option_efb('${idin}')" data-parent="${parentsID}" data-tag="${tag}"  data-id="${idin}" class="efb btn efb btn-edit btn-sm elEdit" data-bs-toggle="tooltip" title="${efb_var.text.delete}">
  <i class="efb  efb bi-x-lg text-danger"></i>
  </button>
  <button type="button" id="addOption" onClick="add_option_edit_pro_efb('${parentsID.trim()}','${tag.trim()}' ,${valj_efb.length})" data-parent="${parentsID}" data-tag="${tag}" data-id="${idin}" class="efb btn efb btn-edit btn-sm elEdit" data-bs-toggle="tooltip" title="${efb_var.text.add}" >
  <i class="efb  bi-plus-circle  text-success"></i>
  </button>

  </div>
  ${id_v}
</div>
</div>
`
}

function funShowAttrElsEfb(el){

  let ol = document.getElementById('optionListefb').dataset;
  if(el.classList.contains('show')){
    el.classList.remove('show');
    el.classList.add('hide');
    ol.idstate = "true" ;
    el.innerHTML= efb_var.text.hdattr
  }else{
    el.classList.remove('hide');
    el.classList.add('show');
    ol.idstate = "false" ;
    el.innerHTML= efb_var.text.shwattr
  }

  for(let ob of document.querySelectorAll(`.elIds`)){
    ol.idstate=="true" ? ob.classList.remove('d-none') : ob.classList.add('d-none');

  }

}

const optionSmartforOptionsEls = (idset ,fid , s_op)=>{


  let two ="";

  if(s_op==0 && valj_efb[0].hasOwnProperty('conditions')){
   const step_no= valj_efb[0].conditions.findIndex(x=>x.id_==fid);

   if (step_no!=-1){
    two= valj_efb[0].conditions[step_no].condition[0].two;
    s_op =  valj_efb[0].conditions[step_no].condition[0].one!=""  ? valj_efb[0].conditions[step_no].condition[0].one : 0;

   }else{
    s_op=0;
   }
  }else if (valj_efb[0].hasOwnProperty('conditions')==true){
    const step_no= valj_efb[0].conditions.findIndex(x=>x.id_==fid);

    if(step_no!=-1){
      const row = valj_efb[0].conditions[step_no].condition.findIndex(x=>x.no ==idset);
      if (row !=-1) two = valj_efb[0].conditions[step_no].condition[row].two;

    }
  }

 let row= get_list_name_otions_field_efb(s_op);
 let op =`<option selected disabled>${efb_var.text.nothingSelected}</option>`;

 for (let i =0 ; i< row.length ; i++){

  op +=`<option value="${row[i].id_}"  id="ocsso-${row[i].id_}" data-idset="${idset}" data-fid="${fid}"  data-op="${s_op}" ${ row[i].id_==two ? `selected` : ''} >${row[i].name}</option>`;
 }
 return `<select  data-id="oso-${idset}" data-no="${idset}" data-fid="${fid}" class="efb w-100 elEdit form-select border-d rounded-4 ps-1 pe-4"  id="optiontSmartforOptionsEls" data-tag="list_otiones">
 ${op}
 <select>`
}



const selectSmartforOptionsEls = (idset ,fid)=>{

  let c = -1;
  const n = valj_efb[0].hasOwnProperty('conditions')==true ? valj_efb[0].conditions.findIndex(x=>x.id_ ==fid):-1;

  if(n!=-1){ c= valj_efb[0].conditions[n].condition.find(x=>x.no ==idset);

  }
  if (typeof c =="undefined") c= valj_efb[0].conditions[n].condition[0];

 let row= get_list_name_selecting_field_efb();
 let op =`<option disabled>${efb_var.text.nothingSelected}</option>`;


 for (let i =0 ; i< row.length ; i++){

  op +=`<option value="${row[i].id_}" id="opsso-${row[i].id_}" data-idset="${idset}" data-fid="${fid}" ${c.one == row[i].id_ ? `selected` : ''} >${row[i].name}</option>`;
 }
 return `<select  data-id="sso-${idset}" data-no="${idset}" data-fid="${fid}" class="efb w-100 elEdit form-select border-d rounded-4 ps-1 pe-4"  id="selectSmartforOptionsEls" data-tag="list_selected">
 ${op}
 <select>`
}

fun_translate_check_efb=()=>{
  const l= ['en_US' ,'fa_IR' ,'ar']
  if(l.findIndex(x=>x==efb_var.wp_lan)!=-1 ) return true;
  return false;
}

const test=fun_translate_check_efb();



const fun_state_of_UK =(rndm,iVJ)=>{
  return [{
      "id_": "NIR",
      "dataId": "NIR-id",
      "parent": rndm,
      "type": "option",
      "s2": "NIR",
      "value": "Northern Ireland",
      "id_op": "_N_o_r_t_h_e_r_n_ I_r_e_l_a_n_d_",
      "step": valj_efb[iVJ].step,
      "amount": valj_efb[iVJ].amount
    },
    {
      "id_": "ENG",
      "dataId": "ENG-id",
      "parent": rndm,
      "type": "option",
      "s2": "ENG",
      "value": "England",
      "id_op": "_E_n_g_l_a_n_d_",
      "step": valj_efb[iVJ].step,
      "amount": valj_efb[iVJ].amount
    },
    {
      "id_": "SCO",
      "dataId": "SCO-id",
      "parent": rndm,
      "type": "option",
      "s2": "SCO",
      "value": "Scotland",
      "id_op": "_S_c_o_t_l_a_n_d_",
      "step": valj_efb[iVJ].step,
      "amount": valj_efb[iVJ].amount
    },
    {
      "id_": "WAL",
      "dataId": "WAL-id",
      "parent": rndm,
      "type": "option",
      "s2": "WAL",
      "value": "Wales",
      "id_op": "_W_a_l_e_s_",
      "step": valj_efb[iVJ].step,
      "amount": valj_efb[iVJ].amount
    }
  ];
}

efbLoadingCard = (bgColor)=>{

  return `<div class='efb row justify-content-center card-body text-center efb mt-5 pt-3'>
  <div class='efb col-12 col-sm-3 mx-0 my-1 d-flex flex-column align-items-center ${bgColor}'>
      <img class='efb w-50' src='${efb_var.images.logoGif}'>
      <h3 class='efb fs-3 text-darkb'>${efb_var.text.easyFormBuilder}</h3>
      <h3 class='efb fs-2 text-dark'>${efb_var.text.pleaseWaiting}</h3>
  </div>
</div> `
}

