const mix = require('laravel-mix');

let fs = require('fs');


let getAllFilesInDirectory = function (dir, extension) {
    extension = extension || false;

    return fs.readdirSync(dir).filter(file => {
        if (extension && file.split('.').pop() === extension) {
            return fs.statSync(`${dir}/${file}`).isFile();
        }

        if (! extension) {
            return fs.statSync(`${dir}/${file}`).isFile();
        }

    });
};

mix.combine([
    'public/theme/css/reset.css',
    'public/theme/css/plugins.css',
    'public/theme/css/style.css',
    'public/theme/css/dashboard-style.css',
    'public/theme/css/forms.css',
    'public/theme/css/rtl-style.css',
    'public/theme/css/color.css',
], 'public/final/css/all.css').options({
    processCssUrls: true
});

mix.combine([
    'public/theme/js/jquery.min.js',
    'public/theme/js/plugins.js',
    'public/theme/js/scripts.js'
], 'public/final/js/all.js').options({
    processCssUrls: true
});

mix.minify('public/theme/js/pages/submit/submit.js');

getAllFilesInDirectory('public/core/js/scripts/', 'js').forEach(function (file_path) {
    if (file_path.indexOf('.min.js') < 0) {
        mix.minify('public/core/js/scripts/' + file_path, 'js');
    }
});

/*---------------------------------------------------
*                   Admin
----------------------------------------------------*/

mix.combine([
    'adm-kodes/vendors/perfect-scrollbar/css/perfect-scrollbar.css',
    'adm-kodes/vendors/tether/dist/css/tether.min.css',
    'adm-kodes/vendors/bootstrap-select/dist/css/bootstrap-select.min.rtl.css',
    'adm-kodes/vendors/select2/dist/css/select2.min.css',
    'adm-kodes/vendors/dropzone/dist/dropzone.min.rtl.css',
    'adm-kodes/vendors/animate.css/animate.rtl.css',
    'adm-kodes/vendors/toastr/build/toastr.min.rtl.css',
    'adm-kodes/vendors/sweetalert2/dist/sweetalert2.min.rtl.css',
    'adm-kodes/vendors/socicon/css/socicon.css',
    'adm-kodes/vendors/vendors/line-awesome/css/line-awesome.min.css',
    'adm-kodes/vendors/vendors/flaticon/css/flaticon.css',
    'adm-kodes/vendors/vendors/metronic/css/styles.css',
    'adm-kodes/vendors/vendors/fontawesome5/css/all.min.css',
], 'adm-kodes/assets/final/css/vendors.css').options({
    processCssUrls: false
});

mix.combine([
    'adm-kodes/assets/demo/base/style.bundle.rtl.min.css',
    'adm-kodes/assets/demo/custom/custom.css'
], 'adm-kodes/assets/final/css/styles.css').options({
    processCssUrls: false
});

mix.combine([
    'adm-kodes/vendors/jquery/dist/jquery.min.js',
    'adm-kodes/vendors/popper.js/dist/umd/popper.min.js',
    'adm-kodes/vendors/bootstrap/dist/js/bootstrap.min.js',
    'adm-kodes/vendors/js-cookie/src/js.cookie.js',
    'adm-kodes/vendors/moment/min/moment.min.js',
    'adm-kodes/vendors/tooltip.js/dist/umd/tooltip.min.js',
    'adm-kodes/vendors/perfect-scrollbar/dist/perfect-scrollbar.min.js',
    'adm-kodes/vendors/wnumb/wNumb.js',
    'adm-kodes/vendors/block-ui/jquery.blockUI.min.js',
    'adm-kodes/vendors/bootstrap-select/dist/js/bootstrap-select.min.js',
    'adm-kodes/vendors/select2/dist/js/select2.full.min.js',
    'adm-kodes/vendors/select2/dist/js/i18n/fa.js',
    'adm-kodes/vendors/typeahead.js/dist/typeahead.bundle.min.js',
    'adm-kodes/vendors/handlebars/dist/handlebars.min.js',
    'adm-kodes/vendors/autosize/dist/autosize.min.js',
    'adm-kodes/vendors/dropzone/dist/dropzone.js',
    'adm-kodes/vendors/bootstrap-notify/bootstrap-notify.min.js',
    'adm-kodes/vendors/js/framework/components/plugins/base/bootstrap-notify.init.js',
    'adm-kodes/vendors/toastr/build/toastr.min.js',
    'adm-kodes/vendors/waypoints/lib/jquery.waypoints.min.js',
    'adm-kodes/vendors/es6-promise-polyfill/promise.min.js',
    'adm-kodes/vendors/sweetalert2/dist/sweetalert2.min.js',
    'adm-kodes/vendors/js/framework/components/plugins/base/sweetalert2.init.js',
    'adm-kodes/assets/demo/base/scripts.bundle.min.js',
], 'adm-kodes/assets/final/js/vendors.js');

mix.minify('adm-kodes/assets/demo/custom/helpers.js');