<?php
function submitLink() {
    return siteroot() . 'new';
}
function pageLink($page_slug) {
    return siteroot() . "page/{$page_slug}";
}
function priceListLink() {
    return siteroot() . 'pricing';
}
function contactUsLink() {
    return pageLink('contact-us');
}
function termsLink() {
    return pageLink('terms');
}
function dashboardLink() {
    return siteroot() . "account";
}
function myListingsLink() {
    return accountRoot() . 'my-listing';
}
function favouritesLink() {
    return accountRoot() . 'favourites';
}
function commentsLink() {
    return accountRoot() . 'comments';
}
function affiliateBannersLink() {
    return accountRoot() . 'affiliate-banners';
}
function affiliateHistoryLink() {
    return accountRoot() . 'affiliate-history';
}
function myPaymentHistoryLink() {
    return accountRoot() . 'payments-history';
}
function myProfileEditLink() {
    return accountRoot() . 'profile-edit';
}
function changePasswordLink() {
    return accountRoot() . 'profile-change-password';
}
function changeAvatarLink() {
    return accountRoot() . 'profile-avatar';
}
function logoutLink() {
    return accountRoot() . 'logout';
}
function loginLink() {
    return siteroot() . 'auth/login';
}
function registerLink() {
    return siteroot() . 'auth/register';
}
function mailboxLink() {
    return accountroot() . 'messages-email';
}
function smsboxLink() {
    return accountroot() . 'messages-sms';
}
function blogLink() {
    return blogRoutes('blog');
}
function rssLink() {
    return siteroot() . 'rss';
}
function searchLink() {
    return siteroot() . 'search';
}
function categoriesLink() {
    return siteroot() . 'all-categories';
}
function androidDownloadLink() {
    return siteroot() . 'download/android';
}
function demoRestrictUrl() {
    return siteroot() . 'demo-restrict';
}

/**
 * Returns the link to view an Order receipt
 *
 * @param  int $order_id
 * @return String $url
 */
function viewOrderLink($order_id) {
    return siteroot() . "account/payments/{$order_id}/invoice";
}

/**
 * Returns link for reset password
 *
 * @param  String $token
 * @return String
 */
function resetPasswordLink($token) {
    return resetPasswordRoot() . "?action=reset&token={$token}";
}

/**
 * Returns link for reset password
 *
 * @return String
 */
function forgotPasswordLink() {
    return siteroot() . 'auth/forgot-pass';
}

/**
 * Returns link for reset password
 *
 * @return String
 */
function forgotPasswordVerifyCodeLink() {
    return siteroot() . 'auth/forgot-pass/verify';
}

/**
 * Returns the link for account activation
 *
 * @return String
 */
function emailActivationLink() {
    return siteroot() . 'auth/activate-email';
}

/**
 * Returns the link for activating account via sms
 *
 * @return String
 */
function smsActivationLink() {
    return siteroot() . 'auth/activate-sms';
}

/**
 * Returns the link to send activation code for auth
 *
 * @return string
 */
function sendActivationCodeLink() {
    return siteroot() . 'auth/activation-code?action=send-activation-code';
}

/**
 * Returns the link to send activation code for auth
 *
 * @return string
 */
function checkActivationCodeLink() {
    return siteroot() . 'auth/activation-code?action=check-activation-code';
}

/**
 * Returns full activation link
 *
 * @param  String $activation_code
 * @return String
 */
function fullActivationLink($activation_code) {
    return addHttp(setting('SITE_URL')) . "/auth/activation?token={$activation_code}";
}

/**
 * Returns the link for submit and verifying an email
 *
 * @return String $url
 */
function submitEmailLink() {
    return accountroot() . 'profile-submit-email';
}

/**
 * Returns the link for submit and verifying a mobile
 *
 * @return String $url
 */
function submitMobileLink() {
    return accountroot() . 'profile-submit-mobile';
}

/**
 * Returns the routes for global ajax requests
 *
 * @param  string $type
 * @return string $yrl
 */
function ajaxRoute($type)
{
    switch ($type) {
        case 'locations':
            return siteroot() . 'ajax/locations';
            break;
        case 'captcha':
            return siteroot() . 'ajax/captcha';
            break;
    }

    return false;
}

/**
 * Returns the route for rss pages
 *
 * @param null $type
 * @param null $category_id
 * @param null $subcategory_id
 * @return string
 */
function rssRoute($type = null, $category_id = null, $subcategory_id = null) {

    if ($type === 'categories') {
        return siteroot() . "rss/categories";
    }
    if ($type === 'new-ads') {
        return siteroot() . "rss/newest";
    }
    if ($type === 'category') {
        return siteroot() . "rss/{$category_id}";
    }
    if ($type === 'subcategory') {
        return siteroot() . "rss/{$category_id}/{$subcategory_id}";
    }
    if ($type === 'posts') {
        return siteroot() . "rss/posts";
    }


    return siteroot() . "rss";
}

/**
 * Returns the routes for payments
 *
 * @param $type
 * @param null $data
 * @return bool|string
 */
function paymentRoutes($type, $data = null)
{
    if ($type === 'callback') {
        return siteroot() . "payment/{$data}/callback";
    }

    if ($type === 'callback_message') {
        return siteroot() . "payment/callback/message?".http_build_query($data);
    }

    return false;
}

/**
 * Returns the routes links for blog
 *
 * @param $type
 * @param null $data
 * @return bool|string
 */
function blogRoutes($type, $data = null) {
    if ($type === 'blog') {
        return siteroot() . 'blog';
    }

    if ($type === 'category') {
        return siteroot() . 'postcat/'. $data[0] .'/'. $data[1]. '/';
    }

    return false;
}

/**
 * Returns the route to pages CRUD
 *
 * @param null $action
 * @param null $id
 * @return String Route
 */
function pagesRoute($action = null, $id = null)
{
    if ($action === 'edit') {
        return adminroot() . "pages/{$id}/edit";
    }

    return '';
}

/**
 * Returns the route to ads CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return string Route
 */
function adsRoute($action = null, $id = null)
{
    if ($action === 'edit') {
        return adminroot() . "ads/{$id}/edit";
    }

    return '';
}

/**
 * Returns the route to coupons CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return String Route
 */
function postsRoute($action = null, $id = null)
{
    if ($action === 'edit') {
        return adminroot() . "posts/{$id}/edit";
    }

    return '';
}