<?php

$protocol = httpProtocol();

$user_agent = mobile_user_agent();

$hideInAndroid = $hideInIos = $hideInMobile = $isMobile = $isAndroid = $isIos =  false;
if ($user_agent == 'android' || $user_agent == 'iphone') {
    $hideInMobile = ' hide ';
    $isMobile  = true;
}
if ($user_agent == 'android') {
    $hideInAndroid = ' hide ';
    $isAndroid = true;
}
if ($user_agent == 'iphone') {
    $isIos = true;
}

$SUPER_ADMIN = _e('SUPER_ADMIN', true);
$ADMIN       = _e('ADMIN', true);
$EDITOR      = _e('EDITOR', true);
$USER        = _e('USER', true);
$UserlevelsArray = compact('SUPER_ADMIN', 'ADMIN', 'EDITOR', 'USER');
$widgets_data = [];

$periods_discount = [
    1 => 0,
    2 => 10,
    3 => 15,
    5 => 20
];

$report_reasons = [
    'content' => 'محتوای آگهی',
    'image' => 'عکس آگهی',
    'contact-info' => 'اطلاعات تماس',
    'price' => 'قیمت',
    'fraud' => 'کلاهبرداری، نقض قانون یا وقوع جرم',
    'address' => 'آدرس و نقشه',
    'owner' => 'مشکلات با صاحب آگهی',
    'not-found' => 'ناموجودبودن مورد آگهی'
];

$base_widgets = [
    ['id' => 1, 'slug' => 'blog-search',                'name' => 'جستجو در بلاگ',       'icon' => 'flaticon-search',        'handler' => App\Widget\BlogSearchWidget::class],
    ['id' => 2, 'slug' => 'blog-categories',            'name' => 'گروه بندی مطالب',    'icon' => 'flaticon-squares-3',     'handler' => App\Widget\BlogCategoriesWidget::class],
    ['id' => 3, 'slug' => 'latest-posts',               'name' => 'تازه ترین مطالب',    'icon' => 'flaticon-list',          'handler' => App\Widget\LatestPostsWidget::class],
    ['id' => 4, 'slug' => 'latest-ads',                 'name' => 'تازه ترین آگهی ها',  'icon' => 'flaticon-bell-1',        'handler' => App\Widget\LatestAdsWidget::class],
    ['id' => 5, 'slug' => 'site-links',                 'name' => 'لینک های سایت',      'icon' => 'flaticon-signs-1',       'handler' => App\Widget\LinksWidget::class],
    ['id' => 6, 'slug' => 'ads-categories',             'name' => 'دسته بندی آگهی ها',  'icon' => 'flaticon-layers',        'handler' => App\Widget\AdsCategoriesWidget::class],
    ['id' => 7, 'slug' => 'locations',                  'name' => 'استان ها',           'icon' => 'flaticon-map-location',  'handler' => App\Widget\LocationsWidget::class],
    ['id' => 8, 'slug' => 'banners',                    'name' => 'بنرها',              'icon' => 'flaticon-imac',          'handler' => App\Widget\BannersWidget::class],
    ['id' => 9, 'slug' => 'banners-by-id',              'name' => 'بنر با شناسه',       'icon' => 'flaticon-imac',          'handler' => App\Widget\BannersByIdWidget::class, 'description' => 'برای نمایش بنرهای سایدبار دلخواه بر اساس شناسه، از این ابزارک استفاده کنید'],
    ['id' => 10,'slug' => 'banners-for-categories',     'name' => 'بنر مخصوص دسته بندی','icon' => 'flaticon-imac',          'handler' => App\Widget\BannersForCategoriesWidget::class, 'description' => ' حهت نمایش بنرهایی که برای دسته بندی ها نعریف شدند، از این ابزارک استفاده کنید (تنها در صفحات مربوط به نمایش آگهی دسته و زیردسته و ... کاربرد دارد)'],
    ['id' => 11,'slug' => 'custom-html',                'name' => 'کد HTML',            'icon' => 'flaticon-arrows',          'handler' => App\Widget\CustomHtmlWidget::class, 'description' => 'از این ابزارک می توانید برای قرار دادن کدهای html دلخواهتان نظیر کدهای تبلیغاتی و ... استفاده نمایید'],
];

$image_sizes = [
    'main' => [
        'size' => '765x510',
        'resize_type' => setting('IMAGES__CROP_MODE'),
        'add_watermark' => (setting("ADD_WATERMARK") === 'YES'),
        'watermark_position '=> 'bottom-right'
    ],
    'thumb' => [
        'size' => '265x175',
        'resize_type' => setting('IMAGES__CROP_MODE'),
        'add_watermark' => (setting("ADD_THUMB_WATERMARK") === 'YES'),
        'watermark_position '=> 'bottom-right'
    ],
    'mini' => [
        'size' => '92x62',
        'resize_type' => 'FIT',
        'add_watermark' => false,
        'watermark_position '=> 'bottom-right'
    ],
    'slider' => [
        'size' => '295x195',
        'resize_type' => setting('IMAGES__CROP_MODE'),
        'add_watermark' => (setting("ADD_THUMB_WATERMARK") === 'YES'),
        'watermark_position '=> 'bottom-right'
    ],
    'large' => [
        'size' => '1200x800',
        'resize_type' => 'LARGE',
        'add_watermark' => (setting("ADD_WATERMARK") === 'YES'),
        'watermark_position '=> 'bottom-right'
    ]
];


$post_image_sizes = [
    'main' => [
        'size' => '768x512',
        'resize_type' => setting('IMAGES__CROP_MODE'),
        'add_watermark' => (setting("ADD_WATERMARK") === 'YES'),
        'watermark_position '=> 'bottom-right'
    ],
    'thumb' => [
        'size' => '345x230',
        'resize_type' => setting('IMAGES__CROP_MODE'),
        'add_watermark' => (setting("ADD_WATERMARK") === 'YES'),
        'watermark_position '=> 'bottom-right'
    ],
    'mini' => [
        'size' => '80x55',
        'resize_type' => 'FIT',
        'add_watermark' => false,
        'watermark_position '=> 'bottom-right'
    ],
    'large' => [
        'size' => '810x540',
        'resize_type' => 'LARGE',
        'add_watermark' => true,
        'watermark_position '=> 'bottom-right'
    ]
];

$editor_image_sizes = [
    'main' => [
        'size' => '725x550',
        'resize_type' => 'MAX-WIDTH',
        'add_watermark' => false
    ]
];