dynamicSelect('category', '#category-dynamic-select', 'ajax/category?type=register', dynamicCategoryDropdownCallback, removeCategoryCallback);
dynamicSelect('location', '#location-dynamic-select', 'ajax/locations', dynamicLocationDropdownCallback);

initFormInputs();

// event listener for after custom field load
$(document).on("customFieldsCalled", function (e) {
    $('#subcategory_input').trigger('input');
    if (e.hasResult) {
        $('.hide-when-custom-has-fields').slideUp();
    } else {
        $('.hide-when-custom-has-fields').slideDown();
    }
});

// event listener for after location selected
$(document).on("locationUpdated", function () {
    $('#city_input').trigger('input');
});

// event listener for removing selected category
$(document).on("dynamicSelectRemoved", function (e) {
    if (e.content === 'category') {
        $('#subcategory_input').trigger('input');
        $('.hide-when-custom-has-fields').slideUp();
    }
    if (e.content === 'location') {
        $('#city_input').trigger('input');
    }
});

// handles change plan
$("#frm_plan_type").on('change', function (e) {
    var planId = $(this).val();
    
    var help_block = $(this).siblings('.help-block').first();
    help_block.html(help_block.data('default-text'));

    addPageLoading();

    $.ajax({
        url: "process/pr_ajax_calls.php",
        type: "POST",
        dataType: "JSON",
        data: {
            action: "ads-type-changed",
            planId: planId
        },
        success: function (data) {

            removePageLoading();

            if (data.has_link) {
                $("#link-placeholder").slideDown();
            } else {
                $("#link-placeholder").slideUp();
            }

            $("#tags-input-help").attr('data-tooltip', _e('POPUP_ADS_TAGS_HELP_TITLE', data.tags_count));

            $.event.trigger({
                type: "planChanged",
                response: data
            });
        }
    })
});

// initiate tags
initiateSelect2Tags('.advanced-select-tags');

// validation fields
var fields = [
    {id: 'frm_title', input: $('#frm_title'), validate: {rule: 'required', min_length: 10}},
    {id: 'frm_plan_type', input: $('#frm_plan_type'), validate: {rule: 'selectbox'}},
    {id: 'frm_description', input: $('#frm_description'), validate: {rule: 'required', min_length: 20}},
    {
        id: 'category-dynamic-select',
        input: {
            category: $('#category_input'),
            subcategory: $('#subcategory_input'),
            subsidiary: $('#subsidiary_input')
        },
        parent: $("#category-form-group"),
        help_block: $("#category-help-block"),
        validate: {rule: 'category'}
    },
    {
        id: 'location-dynamic-select',
        input: {state: $('#state_input'), city: $('#city_input')},
        parent: $("#location-form-group"),
        help_block: $("#location-help-block"),
        validate: {rule: 'location'}
    },
    {
        id: 'accept_terms',
        input: $('#accept_terms'),
        validate: {rule: 'checkbox'},
        help_block: $('#accept_terms_help_block')
    },
    {id: 'register_param', input: $('#register_param'), validate: {rule: 'username', should_visible: true}},
    {
        id: 'login_password',
        input: $('#login_password'),
        validate: {rule: 'submit_auth_password', needs_auth_password: false}
    }
]

// start validation
validate(
    '#submit-item-form',
    fields,
    null,
    submitSuccessCallback,
    {
        submit_url: submit_url,
        custom_fields: {
            has_custom_fields: true,
            wrapper_id: '#custom-fields-wrapper'
        },
        submitErrorCallback: submitErrorCallback
    }
);

/**
 * Callback for form submit success
 *
 * @param e
 * @param response
 * @param form
 */
function submitSuccessCallback(e, response, form) {
    if (form.activation_modal) {
        form.activation_modal.close();
    }

    if (response.menu_html) {
        replaceAuthMenu(response.menu_html);
    }

    successToast(response.message);

    scrollToElement('body');

    if (response.needs_to_pay) {
        form.form.fadeOut("slow", function () {
            $("#invoice").html(response.html);
            $("#ads_id").val(response.ads_id);
            $("#submit-choose-gateway-wrapper").fadeIn("slow");
            form.form.remove();
        });

        validate(
            '#payment-form',
            {},
            null,
            null,
            {submit_url: gateway_url}
        )
    } else {
        form.form.fadeOut("slow", function () {
            form.form_parent.hide().append(response.html).fadeIn("slow");
            form.form.remove();
        });
    }

    form.form.slideUp();
}

/**
 * Callback for form submit error
 *
 * @param response
 * @param form
 */
function submitErrorCallback(response, form) {
    
    if (response.errors.needs_activation) {
        if (response.errors.menu_html) {
            replaceAuthMenu(response.errors.menu_html);
        }

        var activation_modal_id = response.errors.method + '-activation-modal';
        form.activation_modal = $('[data-remodal-id=' + activation_modal_id + ']').remodal({
            hashTracking: false,
            closeOnOutsideClick: false,
            closeOnEscape: false
        });
        form.activation_modal.open();

        handleCheckActivationCode(form.activation_modal, form, activationSuccessCallback);

        setTimeout(function () {
            startTimer(response.errors.resend_time, response.errors.method);
        }, 5000);
    } else {
        errorToast(response.errors);
        scrollToElement('#submit-item-form');
    }
}

function activationSuccessCallback() {
    infoToast(_e('SENDING_DATA') + ' ...');
    $.event.trigger({
        type: "authActivationSuccess",
        status: true
    });
}

initiateLocationPicker('map-convas', default_lat, default_long, 8);


// handles auth
let typingTimer;
let register_input = $("#register_param");
let doneTypingInterval = 300;

register_input.on('input keyup blur', function () {
    clearTimeout(typingTimer);
    typingTimer = setTimeout(doneTyping, doneTypingInterval);
}).on('keydown', function () {
    clearTimeout(typingTimer);
});

/**
 * Function to be called after user finished typing register_param
 */
function doneTyping() {
    var param_val = register_input.val();

    var status = true;
    if (GLOBE__username_type === 'email' && !isEmail(param_val)) {
        status = false;
    }
    if (GLOBE__username_type === 'mobile' && !isMobile(param_val)) {
        status = false;
    }
    if (GLOBE__username_type === 'all' && !isEmail(param_val) && !isMobile(param_val)) {
        status = false;
    }

    if (!status) {
        $("#auth-fields-password").slideUp();
        $("#auth-field-description").slideUp();
        return false;
    }

    addInputLoading(register_input);

    $.ajax({
        url: 'process/pr_ajax_calls.php',
        dataType: 'json',
        type: 'post',
        data: {
            action: 'check-login-param',
            login_param: param_val
        },
        beforeSend: function (xhr) {
            xhr.setRequestHeader('X-CSRF-TOKEN', $("#submit-item-form").find("input[name='token']").val());
        },
        success: function (response) {

            removeInputLoading(register_input);

            if (response.status) {
                if (response.found) {
                    fields[7].validate.needs_auth_password = true;

                    $("#auth-fields-password").slideDown();
                    $("#auth-field-description").slideDown();
                } else {
                    fields[7].validate.needs_auth_password = false;

                    $("#auth-fields-password").slideUp();
                    $("#auth-field-description").slideUp();
                }
            }
        }
    });
}

/**
 * Replace Top Auth menu with the given html
 *
 * @param html
 */
function replaceAuthMenu(html) {
    $("#top-menu-account").find('.header-user-menu').html(html).siblings('.top-auth-button').remove();
}
