initFormInputs();

var CaptchaCallback = initCaptcha('comment-recaptcha');

$('*[data-toggle-favourite]').on('click', function(e) {
    e.preventDefault();

    var $this = $(this);
    var action = $this.attr('data-action');

    $.ajax({
        url : 'ajax/favourite',
        dataType : 'json',
        type : 'post',
        data : {
            link_id: $this.attr('data-linkId'),
            action: action
        },
        success : function(response){

            if (response.status && response.action === 'added') {
                console.log('1');
                $this.attr('data-action', 'remove')
                $this.find('i').removeClass('not-saved');
                return;
            }

            if (response.status && response.action === 'deleted') {
                console.log(2);
                $this.attr('data-action', 'add')
                $this.find('i').addClass('not-saved');
                return;
            }

            errorToast(response.errors);
        }
    });
});

fetchContactInfo();

if (page__enable_voting === '2') {
    initiateVoting('ads', page__link_id);
}

validate('#report-form', [
    {
        id: 'report_reason',
        selector: "input[name='report_reason']",
        input: $("input[name='report_reason']"),
        validate: {rule: 'radio-group'},
        help_block: $('#report-help')
    },
]);

var fields = [
    { id: 'comment_body',  input: $('#comment_body'), validate: {rule: 'required'} },
]

validate('#submit-comment', fields);

var contact_fields = [
    { id: 'message',  input: $('#message'), validate: {rule: 'required', min_length: 5} },
]

if (logged_in === '1') {
    contact_fields.push(
        { id: 'name',  input: $('#name'), validate: {rule: 'required', min_length: 3} },
    );
    contact_fields.push(
        { id: 'email', input: $('#email'), validate: {rule: 'email'} }
    );
    contact_fields.push(
        { id: 'phone', input: $('#phone'), validate: {rule: 'mobile'} }
    );
}

validate('#contact-form', contact_fields, null, null, {
    submit_url: submit_contact_url,
});

if (map_show == 2) {
    simpleMap('singleMap', map_latitude, map_longitude, 12, false, map_title);
}

