initFormInputs();

$(function(){

    $('.should-confirm').on('submit', function(e){
        e.preventDefault();
        var $this = $(this);

        $.confirm({
            icon: 'fa fa-question-circle',
            title: _e('ACTION_CONFIRM'),
            content: '',
            theme: 'modern',
            closeIcon: true,
            animation: 'scale',
            type: 'orange',
            buttons: {
                'confirm': {
                    text: _e('YES'),
                    btnClass: 'btn-green',
                    action: function(){
                        $this[0].submit();
                    }
                },
                'cancel': {
                    text: _e('NO'),
                }
            }
        });
    });

    $(".select-plan-for-extension").on('change', function() {
        var adsId = $(this).attr('data-item-id');
        var plans_wrapper = "#extension-plans-wrappers-" + adsId;

        $.ajax({
            url:"process/pr_ajax_calls.php",
            type:"GET",
            dataType: "JSON",
            data:{
                plan_id: $(this).val(),
                ads_id: adsId, action: 'fetch-extension-plans'
            },
            success:function(data){
                if(data.status) {
                    $(plans_wrapper).html(data.html);
                }
            }
        })
    })
})