dynamicSelect('category', '#category-dynamic-select', 'ajax/category?type=register', dynamicCategoryDropdownCallback, removeCategoryCallback);
dynamicSelect('location', '#location-dynamic-select', 'ajax/locations', dynamicLocationDropdownCallback);

initFormInputs();

price_field_remover('price');
price_field_remover('mortgage');
price_field_remover('rent');

var confirmModal = $('[data-remodal-id=confirm-edit-modal]').remodal({
    hashTracking: false,
    closeOnOutsideClick: false,
    closeOnEscape: false
});

// event listener for after custom field load
$(document).on("customFieldsCalled", function (e) {
    $('#subcategory_input').trigger('input');
    if (e.hasResult) {
        $('.hide-when-custom-has-fields').slideUp();
    } else {
        $('.hide-when-custom-has-fields').slideDown();
    }
});

// event listener for after location selected
$(document).on("locationUpdated", function () {
    $('#city_input').trigger('input');
});

// event listener for removing selected category
$(document).on("dynamicSelectRemoved", function (e) {
    if (e.content === 'category') {
        $('#subcategory_input').trigger('input');
        $('.hide-when-custom-has-fields').slideUp();
    }
    if (e.content === 'location') {
        $('#city_input').trigger('input');
    }
});

// initiate tags
initiateSelect2Tags('.advanced-select-tags');

var fields = [
    {id: 'frm_title', input: $('#frm_title'), validate: {rule: 'required', min_length: 10}},
    {id: 'frm_description', input: $('#frm_description'), validate: {rule: 'required', min_length: 20}},
    {
        id: 'category-dynamic-select',
        input: {
            category: $('#category_input'),
            subcategory: $('#subcategory_input'),
            subsidiary: $('#subsidiary_input')
        },
        parent: $("#category-form-group"),
        help_block: $("#category-help-block"),
        validate: {rule: 'category'}
    },
    {
        id: 'location-dynamic-select',
        input: {state: $('#state_input'), city: $('#city_input')},
        parent: $("#location-form-group"),
        help_block: $("#location-help-block"),
        validate: {rule: 'location'}
    }
]

// start validation
validate(
    '#submit-item-form',
    fields,
    submitSuccessCallback,
    null,
    {
        custom_fields: {
            has_custom_fields: true,
            wrapper_id: '#custom-fields-wrapper'
        }
    }
);



function submitSuccessCallback() {
    confirmModal.open();

    $("#confirm-update").on('click', function() {
        $.event.trigger({
            type: "modalConfirmSuccess",
            modal: confirmModal
        });

        $(this).off('click');
    });
}



initiateLocationPicker('map-convas', default_lat, default_long, 8);

