(function () {

    let uploaded_images = [];
    let all_uploaded_images = [];

    let hidden_form_input = $("#uploaded_images_input");
    let hidden_all_images_input = $("#all_uploaded_images_input");
    let uploader_wrapper = $("#upload_images_part");
    let uploader_div = $("#uploader-part");

    let upload_url = (typeof GLOBE__upload_url !== 'undefined') ? GLOBE__upload_url : 'process/uploads/_ajax_upload.php';

    /**
     * handles removing of uploaded images
     */
    uploader_wrapper.on('click', '*[data-click-removes-image]', function () {
        let $this = $(this);
        let image_id = $this.attr("data-id");
        let parent_wrapper = $this.parent();

        parent_wrapper.html("<div class='drop-images uploading'><span class='hover-icon'><i class='fa fa-spinner fa-spin'></i><br/>" + _e('DELETING') + "</span></div>");

        $.ajax({
            url: "process/pr_delete.php",
            type: "POST",
            data: {
                name: getImageName(image_id),
                action: "remove-uploaded-image"
            },
            success: function () {
                removeFromImages(image_id);
                parent_wrapper.html("<div class='drop-images' data-click-starts-choose-file id='upload_btn_" + image_id + "'><span class='hover-icon'><i class='fa fa-plus'></i><br/>" + _e('ADD_PICTURE') + "</span></div>");
                create_new_bind_event_for_upload(image_id);
            }
        })
    });

    /**
     * bind event on upload forms
     *
     * @param form_id
     */
    function create_new_bind_event_for_upload(form_id) {
        let btn = $('#upload_btn_' + form_id);
        let parent_wrapper = btn.parent();
        let field_id = parent_wrapper.attr("data-field-id");

        new ss.SimpleUpload({
            button: btn,
            url: upload_url,
            name: 'estateImages',
            multipart: true,
            hoverClass: 'hover',
            focusClass: 'focus',
            responseType: 'json',
            customHeaders: {
                'X-CSRF-TOKEN': getCsrfToken()
            },
            startXHR: function (xhr) {
            },
            onSubmit: function () {
                btn.addClass('uploading');
                btn.find('.hover-icon').html("<i class='fa fa-spinner fa-spin'></i><br/>" + _e('UPLOADING') + " ... ");
            },
            onComplete: function (filename, response) {

                if (!response) {
                    btn.removeClass('uploading').addClass('upload-error');
                    return;
                }

                if (response.status) {

                    addToImages(field_id, response.file_name);

                    btn.removeClass('uploading').addClass('upload-success');

                    btn.remove();
                    parent_wrapper.html("<img src='" + response.file_path + "' class='drop-images'/>");
                    parent_wrapper.append("<figcaption data-click-removes-image data-id='" + field_id + "' class='figcaption'><i class='fa fa-times'></i></figcaption>")
                } else {
                    errorToast(response.errors);
                    btn.removeClass('uploading').addClass('upload-error');
                    btn.find('.hover-icon').html("<i class='fa fa-times'></i><br> " + _e('ADD_PICTURE'));
                }
            },
            onError: function () {
                btn.removeClass('uploading').addClass('upload-error');
                btn.find('.hover-icon').html("<i class='fa fa-times'></i><br> " + _e('ADD_PICTURE'));
            },
            onSizeError: function () {
                btn.removeClass('uploading').addClass('upload-error');
                errorToast(_e('MAX_FILE_SIZE_ERROR'));
            }
        });
    }

    function addToImages(image_id, file_name) {
        let index = findIndexOfImage(image_id);

        uploaded_images[index] = {
            id: image_id,
            name: file_name
        };

        all_uploaded_images.push(file_name);
        updateFormInput();
    }

    function removeFromImages(image_id) {
        let index = findIndexOfImage(image_id);

        uploaded_images[index] = {
            id: image_id,
            name: null
        };

        updateFormInput();
    }

    function getImageName(image_id) {
        let index = findIndexOfImage(image_id);

        return uploaded_images[index].name;
    }

    function findIndexOfImage(image_id) {

        let indexes = $.map(uploaded_images, function (obj, index) {
            if (obj.id == image_id) {
                return index;
            }
        });

        return indexes[0];
    }

    function updateFormInput() {
        hidden_form_input.val(JSON.stringify(uploaded_images));
        hidden_all_images_input.val(JSON.stringify(all_uploaded_images));
    }

    function initiate() {
        let start = 1;

        if (preuploaded_images_count > 0) {
            start = parseInt(preuploaded_images_count) + 1;
            for (let i = 1; i < start; i++) {
                uploaded_images.push({id: i, name: i + '.jpg'});
            }
        }

        for (let i = start; i <= images_count; i++) {
            create_new_bind_event_for_upload(i);
            uploaded_images.push({id: i, name: null});
        }

        $(".hover-wrapper").hover(
            function () {
                $(this).find('.figcaption').animate({'opacity': 0.8})
            },
            function () {
                $(this).find('.figcaption').animate({'opacity': 0})
            }
        )

        // event listener for changing plan
        $(document).on("planChanged", function (e) {
            images_count = e.response.images_count;
            reInitiate();
        });
    }

    function reInitiate() {

        if (images_count > 0) {
            uploader_div.slideDown();
        }

        if (shouldDeleteUploaders()) {
            deleteRedudantUploaders();
            uploaded_images.length = images_count;
        }

        if (shouldAddUploader()) {
            addNeededUploaders();
        }

        if (images_count == 0) {
            uploader_div.slideUp();
        }

    }

    function shouldAddUploader() {
        return (images_count > uploaded_images.length);
    }

    function addNeededUploaders() {
        let start = (uploaded_images.length) + 1;
        let end = images_count;

        for (let i = start; i <= end; i++) {
            addAnUploader(i);
        }
    }

    function addAnUploader(uploader_id) {
        let html = " <figure class='hover-wrapper' data-field-id='" + uploader_id + "'> <div class='drop-images' data-click-starts-choose-file id='upload_btn_" + uploader_id + "'> <span class='hover-icon'><i class='fa fa-plus'></i><br/>" + _e('ADD_PICTURE') + "</span> </div> </figure> ";
        uploader_wrapper.append(html);
        create_new_bind_event_for_upload(uploader_id);
        uploaded_images.push({id: uploader_id, name: null});
    }


    function shouldDeleteUploaders() {
        return (uploaded_images.length > images_count);
    }

    function deleteRedudantUploaders() {
        let start = parseInt(images_count) + 1;
        let end = uploaded_images.length;

        for (let i = start; i <= end; i++) {
            deleteUploader(i);
        }
    }

    function deleteUploader(id) {
        uploader_wrapper.find("[data-field-id='" + id + "']").remove();
    }

    // $("#frm_plan_type").on('change', function () {
    //     let planId = $(this).val();
    //
    //     $.blockUI({
    //         message: $("#state-loading"),
    //         css: {
    //             top: ($(window).height() - 200) / 2 + "px",
    //             left: ($(window).width() - 300) / 2 + "px",
    //             width: "auto",
    //             border: "0 solid transparent",
    //             backgroundColor: "transparent"
    //         }
    //     });
    //
    //     $.ajax({
    //         url: "process/pr_ajax_calls.php",
    //         type: "POST",
    //         dataType: "JSON",
    //         data: {
    //             action: "ads-type-changed",
    //             planId: planId
    //         },
    //         success: function (data) {
    //             $.unblockUI({fadeOut: 200});
    //
    //             if (data.has_link) {
    //                 $("#link-placeholder").slideDown();
    //             } else {
    //                 $("#link-placeholder").slideUp();
    //             }
    //
    //             $("#allowed-tags-count").html(data.tags_count);
    //             images_count = data.images_count;
    //             reInitiate();
    //         }
    //     })
    // });

    function getCsrfToken() {
        return uploader_wrapper.closest('form').find("input[name='token']").val();
    }

    initiate();

})();