function showInput(a, b, c) {
    $(a).slideDown(), $(b).html(c).selectpicker("refresh");
}

function removeInput(a, b) {
    b = b || "", "" != b && $(b).html("<option value='any'>همه</option>").selectpicker("refresh"),
        $(a).slideUp();
}

function price_field_remover(a) {
    $("#" + a + "-type").change(function () {
        var b = $(this).val(), c = $("#" + a + "-wrapper");
        "price" !== b ? c.slideUp() : c.slideDown();
    });
}

function errorToast(a) {
    toastr.options = {
        progressBar: !0,
        positionClass: "toast-top-right",
        preventDuplicates: !1,
        showDuration: "300",
        hideDuration: "300",
        timeOut: "3000",
        rtl: !0
    }, toastr.error(a);
}

function successToast(a) {
    toastr.options = {
        progressBar: !0,
        positionClass: "toast-top-right",
        preventDuplicates: !1,
        showDuration: "300",
        hideDuration: "300",
        timeOut: "3000",
        rtl: !0
    }, toastr.success(a);
}

function infoToast(a) {
    toastr.options = {
        progressBar: !0,
        positionClass: "toast-top-right",
        preventDuplicates: !1,
        showDuration: "300",
        hideDuration: "300",
        timeOut: "3000",
        rtl: !0
    }, toastr.info(a);
}

function clearToasts() {
    toastr.clear();
}

function scrollToElement(element_selector, timer) {
    timer = timer || 500;

    $("html, body").animate({
        scrollTop: $(element_selector).offset().top
    }, timer);
}

function addPageLoading() {
    $("#top-page-loading").attr("aria-busy", !0);
}

function removePageLoading() {
    $("#top-page-loading").attr("aria-busy", !1);
}

/**
 * Adds loading status to given button and whole page
 *
 * @param button
 * @param text
 */
function addButtonLoading(button, text) {
    text = text || _e('SENDING_DATA');
    button.attr('disabled', 'disabled');
    addPageLoading();
    button.html(text + ' ... <i class="fa fa-spinner fa-spin top2"></i>');
}

/**
 * Remove loading status from given button and whole page
 *
 * @param button
 */
function removeButtonLoading(button) {
    button.html(button.data('default-text'));
    button.removeAttr('disabled');
    removePageLoading();
}

/**
 * Adds loading to given input
 *
 * @param element
 */
function addInputLoading(element) {
    element.siblings(".input-loading").first().html('<i class="fa fa-spinner fa-spin"></i>');
}

/**
 * Removes loading from given input
 *
 * @param element
 */
function removeInputLoading(element) {
    element.siblings(".input-loading").first().html("");
}


function handleDemoGear() {
    $("#side-bar-control").click(function () {
        var a = $("#side-bar-control"), b = $("#side-bar");

        b.hasClass("visible") ? (b.animate({
            left: "-150px",
            height: "50"
        }).removeClass("visible"), a.animate({
            left: "0",
            height: "50",
            "font-size": "30",
            "line-height": "57"
        })) : (b.removeClass("hidden").animate({
            left: "0",
            height: 260
        }).addClass("visible"), a.animate({
            left: "150",
            height: 260,
            "font-size": "40",
            "line-height": "170"
        }));
    });
    $("#template-changer").change(function () {
        document.location.href = $(this).find(":selected").attr("data-page");
    });
    $(function () {
        $("#theme-stylizer .color-changer").click(function () {
            const color = $(this).attr("data");
             $.ajax({
                url: "process/pr_ajax_calls.php",
                type: "GET",
                data: {
                    colorName: color
                },
                 success: function() {
                    location.reload();
                 }
            });
        });
    });
}

function isEmail(a) {
    a = persianToEnglishDigits(a);
    var b = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return b.test(a);
}

function isMobile(a) {
    a = persianToEnglishDigits(a);
    var b = /09(0[1-9]|1[0-9]|3[0-9]|2[0-1]|9[0-9])-?[0-9]{3}-?[0-9]{4}$/;
    return b.test(a);
}

/**
 * Converts Persian Digits to English
 *
 * @param b
 * @returns {string}
 */
function persianToEnglishDigits(b) {
    if (!(-1 !== $.inArray(b, [ 46, 8, 9, 27, 13, 190 ]) || 65 == b && a.ctrlKey === !0 || b >= 35 && 39 >= b)) {
        b = b.toString();
        for (var c = "", d = 0; d < b.length; d++) {
            var e = b.charCodeAt(d), f = null;
            e >= 1776 && 1785 >= e ? (f = e - 1728, c += String.fromCharCode(f)) : e >= 1632 && 1641 >= e ? (f = e - 1584,
                c += String.fromCharCode(f)) : c += String.fromCharCode(e);
        }
        return c;
    }
}

/**
 * Check if source of map is GoogleMaps or not
 *
 * @return boolean
 */
function isGoogleMaps() {
    return (GLOBE__maps_source === 'GOOGLE');
}

/**
 * Check if source of map is CedarMaps or not
 *
 * @return boolean
 */
function isCedarMaps() {
    return (GLOBE__maps_source === 'CEDAR');
}

/**
 * Check if source of map is CedarMaps or not
 *
 * @return boolean
 */
function isOSMMaps() {
    return (GLOBE__maps_source === 'OSM');
}

/**
 * Check if map is presented by leafletJs or not
 *
 * @return boolean
 */
function isLeafletMaps() {
    return (GLOBE__maps_source !== 'GOOGLE' && GLOBE__maps_source !== 'NESHAN');
}

/**
 * Check if map is presented by neshan webSDK or not
 *
 * @return boolean
 */
function isNeshanMaps() {
    return (GLOBE__maps_source === 'NESHAN');
}

/**
 * Strip tags from string
 *
 * @param string
 * @returns {string|boolean}
 */
function stripTags(string) {
    if ((string === null) || (string === '')) {
        return false;
    }

    string = string.toString();
    return string.replace(/<[^>]*>/g, '');
}

/**
 * Handles Dynamic select boxes
 *
 * @param wrapper_id
 * @param ajax_url
 * @param successCallbackFunction
 * @param removeItemCallbackFunction
 */
function dynamicSelect(type, wrapper_id, ajax_url, successCallbackFunction, removeItemCallbackFunction) {
    var wrapper = $(wrapper_id);
    var self = {
        wrapper: wrapper,
        launcher: wrapper.find('.select-group--dynamic .dynamic-select').first(),
        dropdown: wrapper.find('.dynamic-select-dropdown').first(),
        inputs_wrapper: null,
        default_template: null,
        dropdown_list: null,
        remove_selected: null,
        search_input: null,
    }
    self.inputs_wrapper = self.dropdown.find('.dropdown-inputs').first();
    self.default_template = self.dropdown.find('.dropdown-template').first().html();
    self.dropdown_list = self.dropdown.find('.dropdown-body .dropdown-list').first();
    self.remove_selected = self.launcher.siblings('.remove-selected-item').first();
    self.search_input = self.dropdown.find('.dropdown-header .dropdown-search .dropdown-search-input').first();

    self.launcher.on('click', function() {
        self.dropdown.show();

        //
        $(document).mouseup(function(e){
            if(! self.dropdown.is(e.target) && self.dropdown.has(e.target).length === 0){
                closeDropdown();
            }
        });
    })

    self.dropdown.on('click', '.dropdown-list-item', function() {
        var $this = $(this);

        $this.addClass('active');

        $.ajax({
            url : ajax_url,
            dataType : 'json',
            type : 'post',
            data : $this.data(),
            success : function(response) {

                $this.removeClass('active');

                if (response.status && ! response.errors) {
                    if (response.result) {
                        $.when(self.dropdown_list.fadeOut(100))
                            .done(function() {
                                self.dropdown_list.html(response.result);
                            })
                            .done(function() {
                                self.dropdown_list.fadeIn(100);
                            })
                        self.search_input.val('');
                    } else {
                        successCallbackFunction(self, $this, response);

                        self.launcher.html($this.html());
                        self.remove_selected.show();
                        self.dropdown.hide();
                        resetDropdown();
                    }
                }
            }
        });
    });

    self.dropdown.find('.close-dropdown').first().on('click', function() {
        closeDropdown();
    });

    self.remove_selected.on('click', function() {
        removeSelect(removeItemCallbackFunction);

        // fire event
        $.event.trigger({
            type: "dynamicSelectRemoved",
            content: type
        });

        self.remove_selected.hide();
    });

    function resetDropdown() {
        self.dropdown_list.html(self.default_template);
        self.search_input.val('');
    }

    function removeSelect(removeItemCallbackFunction) {
        self.launcher.html(self.launcher.attr('data-default-text'));
        self.inputs_wrapper.find('input').val('');

        if (removeItemCallbackFunction) {
            removeItemCallbackFunction();
        }
    }

    function closeDropdown() {
        resetDropdown();
        self.dropdown.hide();
        $(document).unbind('mouseup');
    }

    var search_item = null;
    var filter_text = null;
    self.search_input.keyup(function(){

        filter_text = $(this).val();

        self.dropdown_list.find('li').each(function(){
            search_item = $(this);

            if (search_item.text().includes(filter_text)) {
                search_item.show();
            } else {
                search_item.hide();
            }
        });
    });
}

/**
 * callback for selecting a category on dynamic select
 *
 * @param self
 * @param $this
 * @param response
 */
function dynamicCategoryDropdownCallback(self, $this, response) {
    self.inputs_wrapper.find("input[name='category']").val($this.data('category'));
    self.inputs_wrapper.find("input[name='subcategory']").val($this.data('subcategory'));
    self.inputs_wrapper.find("input[name='subsidiary']").val($this.data('subsidiary'));

    var custom_fields_inner = $("#custom-fields-wrapper .custom-fields-placeholder").first();

    if (response.custom_fields) {
        custom_fields_inner.html(response.custom_fields).parent().show();
        $.event.trigger({
            type: "customFieldsCalled",
            hasResult: true
        });
    } else {
        custom_fields_inner.html('').parent().hide();
        $.event.trigger({
            type: "customFieldsCalled",
            hasResult: false
        });
    }
}

/**
 * callback for removing selected category from dynamic select
 */
function removeCategoryCallback() {
    $("#custom-fields-wrapper .custom-fields-placeholder").first().html('').parent().hide();
}

/**
 * callback for selecting a location on dynamic select
 *
 * @param self
 * @param $this
 * @param response
 */
function dynamicLocationDropdownCallback(self, $this, response) {
    self.inputs_wrapper.find("input[name='state']").val($this.data('state'));
    self.inputs_wrapper.find("input[name='city']").val($this.data('city'));

    $.event.trigger({
        type: 'locationUpdated',
        lat: $this.data('latitude'),
        long: $this.data('longitude')
    })
}

/**
 * Initiates From input functionalities
 */
function initFormInputs() {
    var forms = $('form');


    forms.on('focus', '.form-group--float .form-control', function() {
        $(this).parent().addClass('form-group--focused');
    })

    forms.on('blur', '.form-group--float .form-control', function() {
        var $this = $(this);
        var form_control = $this.parent();

        form_control.removeClass('form-group--focused');

        if($this.val()) {
            form_control.addClass('form-group--active');
        } else {
            form_control.removeClass('form-group--active');
        }
    });

    forms.find('.form-group--float .form-control').trigger('focus').trigger('blur');

    forms.on('change', '.btn-group-divided .btn-group input', function() {
        $(this).parent().addClass('active').siblings('.btn').removeClass('active');
    });

    $('*[data-text-with-checkbox]').on('change', function() {
        var $this = $(this);

        var target_input = $($this.attr('data-input'));

        if($this.is(":checked")) {
            target_input.attr('readonly', 'readonly');
        } else {
            target_input.removeAttr('readonly');
        }
    });

    // digit fields
    forms.on('keydown', '.digits-field', function(a) {
        var key_code = a.which;
        var special_keys = [8,0];

        if ((key_code >= 48 && key_code <= 57) || (key_code >= 96 && key_code <= 105) || special_keys.indexOf(key_code) != -1) {
            return true;
        }

        return false;
    })

    // digit fields
    forms.on('input', '.digits-field', function() {
        var value = persianToEnglishDigits(this.value);

        if (value.length) {
            showDigitsFieldDividePlaceHolder(this);
        }

        fillPriceFieldPlaceholder(this, value);
    })

    // digit fields
    forms.on('focus', '.digits-field', function() {
        showDigitsFieldDividePlaceHolder(this);
    }).on('blur', '.digits-field', function() {
        hideDigitsFieldDividePlaceHolder(this);
    });

    forms.find('.password-toggle').on('click', function () {
        var $this = $(this);
        var input = $this.siblings('input').first();
        var icon = $this.find('i');

        if (input.attr('type') === 'password') {
            input.attr('type', 'text');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            input.attr('type', 'password');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    })

    scrollToElement('body', 1);
}

/**
 * Translates the given key
 *
 * @param key
 * @param replacement_1
 * @param replacement_2
 * @returns {*}
 * @private
 */
function _e(key, replacement_1, replacement_2) {
    if (! replacement_1) {
        return GLOBE__language[key];
    }

    var string = GLOBE__language[key];

    if (replacement_1) {
        string = string.replace("{%1%}", replacement_1)
    }
    if (replacement_1) {
        string = string.replace("{%2%}", replacement_2)
    }

    return string;
}

/**
 * Redirects user to the given url
 *
 * @param url
 */
function redirectTo(url) {
    document.location.href = url;
}


/**
 * Check if captcha is of type image
 *
 * @returns {boolean}
 */
function isImageCaptcha() {
    return (Globe__captcha_type === 'CAPTCHA');
}

/**
 * Check if captcha is of type google recaptcha
 *
 * @returns {boolean}
 */
function isGoogleRecaptcha() {
    return (Globe__captcha_type === 'GOOGLE_RECAPTCHA');
}

/**
 * Initiates captcha on page
 */
function initCaptcha(captcha_namespace) {
    // for google recaptcha
    if (captcha_namespace && Globe__captcha_type === 'GOOGLE_RECAPTCHA') {
        return function() {
            grecaptcha.render(captcha_namespace, {'sitekey' : Globe__recaptcha_key});
        };
    }

    // for text captcha
    $("*[data-click-updates-captcha]").on('click', function() {
        var $this = $(this);

        var target = $($this.attr('data-target'));

        $this.addClass('fa-spin');

        $.ajax({
            url: Globe__captcha_route,
            dataType: 'json',
            type: 'POST',
            data: {
                namespace: $this.attr('data-namespace')
            },
            success: function(response) {
                if (response.status) {
                    target.attr('src', response.captcha);
                    $this.removeClass('fa-spin');
                }
            }
        });
    });
}

function initiateSelect2Tags(selector) {
    $(selector).select2({
        tags: true,
        dir: (isLtr === 'yes') ? 'ltr' : 'rtl',
        language: "fa"
    });

    // hide unwanted select2tags elements
    $(selector).on('select2:opening select2:close', function(e){
        $('body').toggleClass('kill-all-select2-dropdowns', e.type === 'select2:opening');
    });

    $(".select2-selection--multiple .select2-search__field").on('focus', function() {
        $(this).closest('.select-group--float').addClass('form-group--focused');
    }).on('blur', function() {
        $(this).closest('.select-group--float').removeClass('form-group--focused');
    });
}

/**
 * Initialise location picker based on active map
 *
 * @param selector_id
 * @param lat
 * @param long
 * @param zoom
 */
function initiateLocationPicker(selector_id, lat, long, zoom) {
    if (isGoogleMaps()) {
        initializeGoogleLocationPicker(
            selector_id,
            lat,
            long,
            zoom || 8
        );
    }
    if (isLeafletMaps() || isNeshanMaps()) {
        initialiseAdvancedLeafletLocationPicker(
            selector_id,
            lat,
            long,
            zoom || 8
        );
    }

    $("#show_map").on('change', function() {
        var is_checked = $(this).is(':checked');
        if (is_checked) {
            $("#map-place").slideDown();
        } else {
            $("#map-place").slideUp();
        }
    });
}

function changeUrlParam(paramKey, value)
{
    var vars = [], hash;
    var hashes =  document.URL.split('?')[1];

    if (hashes !== undefined) {

        hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');

        for(var i = 0; i < hashes.length; i++)
        {
            hash = hashes[i].split('=');

            if (hash[0] === 'page' || hash[0].length === 0) {
                continue;
            }

            vars.push({
                'name': hash[0],
                'value': decodeURI(hash[1])
            });
        }
    }

    var paramObject = {
        'name': paramKey,
        'value': value
    };

    var index = findObjectIndexByKey(vars, 'name', paramKey);

    if (index !== null) {
        vars.splice(index, 1);
        vars.push(paramObject);
    } else {
        vars.push(paramObject);
    }

    var currentURL = window.location.href.split('?')[0];

    return currentURL + '?' + decodeURI((jQuery.param(vars)+'').replace(/%2B/g, '+'));
}

function findObjectIndexByKey(array, key, value) {
    for (var i = 0; i < array.length; i++) {
        if (array[i][key] === value) {
            return i;
        }
    }
    return null;
}

$('.collapsable__toggle').on('click', function() {
    var $this = $(this);
    var target = $this.siblings('.collapsable').first();

    if (target.hasClass('open')) {
        target.removeClass('open');
        $this.find('i').removeClass('fa-caret-up').addClass('fa-caret-down')
        $this.find('span').html($this.data('open-text'));
    } else {
        target.addClass('open');
        $this.find('i').removeClass('fa-caret-down').addClass('fa-caret-up')
        $this.find('span').html($this.data('close-text'));
    }
});

function showDigitsFieldDividePlaceHolder(input_object) {
    var value = persianToEnglishDigits(input_object.value);

    if (value.length) {
        fillPriceFieldPlaceholder(input_object, value);
        $(input_object).siblings('.digits-divider').first().fadeIn();
    }
}

function hideDigitsFieldDividePlaceHolder(input_object) {
    $(input_object).siblings('.digits-divider').first().fadeOut();
}

function fillPriceFieldPlaceholder(input_object, value) {
    var formatted_value = Number(value).toLocaleString("ir-IR");
    var placeholder = $(input_object).siblings('.digits-divider').first();

    if (formatted_value && formatted_value !== '0' &&  formatted_value !== 'NaN') {
        placeholder.html(formatted_value);
    } else {
        placeholder.html('');
    }
}

function initiateVoting(post_type, link_id) {
    $('.like-actions a').on('click', function() {
        var $this = $(this);
        var action = $this.attr('data-action');

        var count_placeholder = $this.find('.count');
        var old_count = parseInt(count_placeholder.html());

        count_placeholder.html('<i class="fa fa-spinner fa-spin"></i>');
        $this.parent().find('a').addClass('disabled');

        $.ajax({
            url : GLOBE__site_url + 'ajax/like',
            dataType : 'json',
            type : 'post',
            data : {
                action: action,
                post_type: post_type,
                link_id: link_id
            },
            success : function(response){
                if(response.status) {
                    $this.find('i').removeClass().addClass('fa fa-check');
                    count_placeholder.html(old_count + 1);
                } else {
                    count_placeholder.html(old_count);
                    errorToast(response.errors);
                }
            }
        });
    });
}

function highlightMenu(menu_id) {
    $('#main-menu').find(`#menu-item-${menu_id} a`).addClass('active');
}

function fetchContactInfo() {
    $('*[data-click-fetch-info]').on('click', function(e) {
        e.preventDefault();
        var $this = $(this);

        var info_form = $this.closest('form');

        $.ajax({
            url : info_form.prop('action'),
            dataType : 'json',
            type : 'POST',
            data : info_form.serialize(),

            success : function(response){
                if (response) {
                    info_form.find('ul li.email a').text(response.email);
                    info_form.find('ul li.phone a').text(response.phone);
                }
            }
        });
    });
}