(function() {

    $('body').on('click', '*[data-i-have-coupon]', function() {
        $("#initial-discount").remove();
        $("#discount-cell").addClass('with-input');
        $("#coupon_input_form").show();
        $(this).remove();
    });

    $('body').on('submit', '#coupon_input_form', function(e) {
         e.preventDefault();

         var coupon_form    = $(this);
         var button         = coupon_form.find('.submit-button');
         var initial_price  = $("#initial-price").attr('data-value');

         addPageLoading();
         button.attr("disabled", "disabled").html("اعمال ... <i class='fa fa-spinner fa-spin'></i>");

         $.ajax({
            url : 'process/pr_ajax_calls.php',
            dataType : 'json',
            type : 'post',
            data : coupon_form.serialize() + '&action=check-coupon-code&price=' + initial_price,

            success : function(response){

                removePageLoading();
                button.removeAttr("disabled").html("اعمال");

                if(response.status) {
                    successToast("کد تخفیف با موفقیت اعمال شد");
                    $("#initial-price").addClass('diagonal-strikethrough');
                    $("#final-price").html(response.final_price);
                    $("#coupon_id").val(response.coupon_code);
                    coupon_form.find('.form-group').html("<span class='coupon-discount'>"+response.discount + "</span><br><span class='coupon-description'>" + response.description + "</description>");
                } else {
                    errorToast(response.errors)
                }
            }
        });

    });

})();