/**
 * Handles Submitting of resending of activation link
 */
$('body').on('submit', '*[data-submit-resends-activation-code]', function (e) {
    e.preventDefault();

    var $this = $(this);
    var submit_button = $this.find('button[type="submit"]');
    var resend_wrapper = $this.closest('.resend-wrapper');
    var after_resend_message = resend_wrapper.find('.after-resend-message').first();

    addButtonLoading(submit_button, _e('SENDING_ACTIVATION_CODE'));

    $.ajax({
        url: $this.prop('action'),
        dataType: 'json',
        type: $this.prop('method'),
        data: $this.serialize() + '&action=send-activation-code',
        success: function (response) {

            removeButtonLoading(submit_button);

            if (response.status) {
                infoToast(response.message);
                resend_wrapper.slideUp();
                after_resend_message.html(response.message).slideDown();

                setTimeout(function () {
                    startTimer(response.resend_time, response.method);
                }, 5000);
            } else {
                errorToast(response.errors);
            }
        }
    });
});

/**
 * Handles Submitting of checking activation link form
 *
 * @param activation_modal
 * @param main_form :: instance of validate
 * @param activationSuccessCallback
 */
function handleCheckActivationCode(activation_modal, main_form, activationSuccessCallback) {
    $('body').on('submit', '*[data-click-checks-activation]', function (e) {

        e.preventDefault();
        var activation_form = $(this);

        var button = activation_form.find('button[type="submit"]');

        addButtonLoading(button);

        $.ajax({
            url: activation_form.prop('action'),
            dataType: 'json',
            type: 'POST',
            data: activation_form.serialize() + '&action=check-activation-code',

            success: function (response) {
                if (response.status) {
                    activation_modal.close();
                    removeButtonLoading(button);

                    if (activationSuccessCallback) {
                        activationSuccessCallback(main_form);
                        return false;
                    }

                    main_form.form.parent().slideUp(function(){
                        main_form.message_placeholder.html(response.html).slideDown();
                    });

                    scrollToElement('body');
                } else {
                    removeButtonLoading(button);
                    errorToast(response.errors);
                }
            }
        });
    });
}




/**
 *
 * Handles the timer
 *
 * @param timer
 * @param method
 * @returns {boolean}
 */
function startTimer(timer, method) {

    if (typeof GLOBALS__use_timer !== 'undefined' && GLOBALS__use_timer === 'no') {
        return false;
    }

    var wrapper = $('.resend-wrapper.' + method);

    wrapper.find('.resend-activation-code').slideUp();
    wrapper.find('.after-resend-message').slideUp();
    wrapper.slideDown();
    wrapper.find('.activation-count-down').slideDown();

    wrapper.find('.count-down').countdown(timer, function (event) {
        $(this).html(event.strftime('%M:%S'));
    }).on('finish.countdown', function () {
        wrapper.find('.activation-count-down').slideUp();
        wrapper.find('.resend-activation-code').slideDown();
    });
}