<?php

use App\PolicyReport;
use App\ReCaptcha;
use App\Validate;

if (! isAjax()) {
    redirect(loginLink());
}

if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

$validation = (new Validate())->check($_POST, [
    'report_reason' => [
        'name' => 'نوع مشکل یا تخلف آگهی ',
        'prefix' => 'انتخاب ',
        'required' => true,
    ]
]);

if (! $validation->passed()) {
    return ajaxErrorResponse($validation->errors());
}

$ReCaptcha = new ReCaptcha();
if (! $ReCaptcha->verify('report')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$user_id = (currentUser()->USER_ID) ?: 0;
$report = (new PolicyReport())->createNew($ads->ADS_ID, $user_id, input('report_reason'));

return ajaxSuccessResponse([
    'type' => 'html',
    'html' => _e('POLICY_REPORT_SENT_MESSAGE', true)
]);