<?php
use App\Mailer;
use App\MessageBox;
use App\ReCaptcha;
use App\Template;
use App\Validate;

if (! isAjax()) {
    return false;
}
if (! isCountryAllowed()) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}

if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

if (!$ads || !$ads->is_shown()) {
    return ajaxErrorResponse(_e('ADS_DENY_CONTACT', true));
}

$rules = [
    'message' => [
        'name' => _e('MESSAGE', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 5
    ]
];
if (! $loggedUser || empty($loggedUser->NAME)) {
    $rules['name'] = [
        'name' => _e('NAME', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 3
    ];
}
if (! $loggedUser || ! $loggedUser->hasVerifiedEmail()) {
    $rules['email'] = [
        'name' => _e('EMAIL', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'email' => true
    ];
}
if (! $loggedUser || ! $loggedUser->hasVerifiedMobile()) {
    $rules['phone'] = [
        'name' => _e('PHONE_NUMBER', true),
        'prefix' => _e('ENTERING', true),
        'required' => true
    ];
}

$validation = (new Validate())->check($_POST, $rules);

if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$ReCaptcha = new ReCaptcha();
if (! $ReCaptcha->verify('contact')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$userId = $loggedUser ? $loggedUser->USER_ID : null;
$senderName = $loggedUser ? $loggedUser->publicName() : input('name');
$senderMail =  $loggedUser ? $loggedUser->email() : input('email');
$senderPhone = $loggedUser ? $loggedUser->email() : input('phone');
$to_name = ($user) ? $user->publicName() : '';
$subject = $ads->ADS_TITLE;
$message = input('message');

$mailVariables = array(
    "title" => _e('SENT_FROM_CONTACT_FORM', true) . "-" . setting('SITE_TITLE'),
    "subTitle" => "",
    "senderName" => $senderName,
    "senderMail" => $senderMail,
    "senderPhone" => $senderPhone,
    "subject" => $subject,
    "message" => $message
);
$message = Template::email('contact_us', $mailVariables);

$mailer = new Mailer();
$sent = $mailer->send($owner_email, $message, $subject, $to_name, $senderMail, $senderName);

if ($sent) {
    $MessageBox = new MessageBox('email');
    $MessageBox->createNew([
        'USER_ID' => $userId,
        'TITLE' => $subject,
        'SENDER_NAME' => $senderName,
        'SENDER_MAIL' => $senderMail,
        'MESSAGE' => $message,
        'RECIVER_USER_ID' => $ads->USER_ID,
        'RECIVER_MAIL' => $owner_email,
        'FROM' => 'USER',
        'TO' => 'ADMIN'
    ]);

    return ajaxSuccessResponse([
        'type' => 'html',
        'html' => _e('MESSAGE_SUCCESSFULLY_SENT', true)
    ]);
}

return ajaxErrorResponse(_e('SENDING_FAILED', true));
