<?php
use App\Exception\ImageUploadException;
use App\ImageUploadDynamic;

require_once ('../init.php');

if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if( ! token()->checkForAjax() ) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

try {
    $ImageUploadDynamic = new ImageUploadDynamic([
        'input_name' => 'estateImages',
        'root' => '../images/estate_images/app_temp/',
        'copy_sizes' => $post_image_sizes,
        'add_watermark' => true,
        'watermark_image' => '../images/watermark.png',
        'max_size' => setting('MAX_IMG_SIZE_KB'),
        'valid_formats' => ['jpg','jpeg', 'JPG', "JPEG"],
        'valid_mime_types' => ['image/jpeg'],
        'only_jpg' => true
    ]);

    if ($ImageUploadDynamic->upload('jpg')) {
        $uploaded_name = $ImageUploadDynamic->uploadedBaseName();

        $preview_path = siteroot() . ltrim($ImageUploadDynamic->previewName(), '../') . '?' . rand(1,500);

        return ajaxSuccessResponse(['file_name' => $uploaded_name, 'file_path' => $preview_path]);
    } else {
        return ajaxErrorResponse($ImageUploadDynamic->errors());
    }

} catch (ImageUploadException $e) {
    return ajaxErrorResponse($e->errors());
}
//
//if($image->make())
//{
//    $file_name = removeExtension($image->getFileName());
//    $file_path = siteroot() . ltrim($image->getThumbPath(), '../') . '?' . rand(1,500);
//
//    return ajaxSuccessResponse(['file_name' => $file_name, 'file_path' => $file_path]);
//}else{
//    return ajaxErrorResponse($image->getError());
//}