<?php
use App\Exception\ImageUploadException;
use App\ImageUploadDynamic;

require_once ('../init.php');

if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}

try {
    mkdir('../images/editor_images/');
    mkdir('../images/editor_images/'.date('Y-m').'/');

    $ImageUploadDynamic = new ImageUploadDynamic([
        'input_name' => 'upload',
        'root' => '../images/editor_images/'.date('Y-m').'/',
        'copy_sizes' => $editor_image_sizes,
        'add_watermark' => false,
        'valid_formats' => ['jpg','jpeg', 'JPG', "JPEG"],
        'valid_mime_types' => ['image/jpeg'],
        'only_jpg' => true
    ]);

    if ($ImageUploadDynamic->upload('jpg')) {
        echo json_encode([
            "uploaded" => 1,
            "fileName" => $ImageUploadDynamic->uploadedBaseName(),
            "url" => siteroot() . ltrim($ImageUploadDynamic->previewName(), '../')
        ]);
    }
} catch (ImageUploadException $e) {
    return ajaxErrorResponse($e->errors());
}