<?php
use App\Ads;
use App\CategoryList;
use App\Coupon;
use App\CustomFields;
use App\Favourites;
use App\Like;
use App\LocationList;
use App\MessageBox;
use App\PolicyReport;
use App\ReCaptcha;

require_once '../init.php';
require_once(INC_PATH.'core/check_auth.php');

if (!isAjax()) {
    abort();
}

/**
 * Change color in demo mode
 */
if (inputs()->not_empty('colorName')) {
    if (! in_array(input('colorName'), ['color-1', 'color-2', 'color-3', 'color-4', 'color-5'])) {
        cookie()->delete('koClassified__demo_color');
        return false;
    }

    cookie()->put('koClassified__demo_color', input('colorName'), 14*24*3600);

    return;
}

/**
 * Returns the cities for requested state
 */
if (inputs()->is_set('stateId') && inputs()->isEmpty('action')) {
    $LocationList = new LocationList();
    $cities = $LocationList->citiesFor(input('stateId'));

    $result = "<option value='0'>" . _e('CHOOSE', true) . "</option>";
    /** @var App\Location $city */
    foreach ($cities AS $city) {
        $result .= "<option value='{$city->id()}'>{$city->name()}</option>";
    }

    return ajaxSuccessResponse(compact('result'));
}

/**
 * Save Policy Report in database
 */
if (input('action') === 'send-report' && inputs()->not_empty('ADS_ID')) {

    $ReCaptcha = new ReCaptcha();
    if (! $ReCaptcha->verify('report')) {
        return ajaxErrorResponse($ReCaptcha->error());
    }

    $user_id = ($loggedUser->USER_ID) ?: null;

    $PolicyReport = new PolicyReport();
    $report = $PolicyReport->createNew(inputs()->all());

    return ajaxSuccessResponse(['message' => _e('POLICY_REPORT_SENT_MESSAGE', true)]);
}


/**
 * Add or remove from favourites
 */
if (inputs()->not_empty('adsId') && inputs()->not_empty('userId')) {
    $adsId = input('adsId');
    $userId = input('userId');
    $type = input('type');
    $result['res'] = 0;

    $fav = new Favourites();
    $old = $fav->find($adsId, $userId);

    if (empty($old)) {
        if ($type == "add") {
            if ($fav->add($adsId, $userId) == 1)
                $result['res'] = "added";
        }
    } else {

        if ($type == "remove") {
            if ($old->delete() == 1)
                $result['res'] = "deleted";
        }
    }
    echo json_encode($result);
    exit();
}

/**
 * Returns the subsidiaries for requested subcategory
 */
if (inputs()->not_empty('subcatId') && input('action') === "find-subsidiary") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $Ads = new Ads();
    $subcatId = input('subcatId');


    if ($subcatId != 'any') {
        $catId = $Ads->category_of_subcat($subcatId)->CAT_ID;
        $subsidiaries = $Ads->subcategory_Subsidiaries($subcatId);
        if ($subsidiaries) {
            $output['status'] = true;
            $output['result'] .= "<option value='any' selected disabled style='display: none;'>" . _e('CHOOSE', true) . "</option>";
            foreach ($subsidiaries AS $subsidiary) {
                $output['result'] .= "<option value='{$subsidiary->SUBCAT_ID}'>{$subsidiary->SUBCATEGORY_NAME}</option>";
            }
        } else {
            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForSubcategory($catId, $subcatId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;

                /** @var CustomFields $field */
                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('register', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }
        }
    }
    echo json_encode($output);
}

/**
 * Returns the custom fields for requested subsidiary
 */
if (inputs()->not_empty('subsidiaryId') && input('action') === "find-custom-field-for-subsidiary") {

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $Ads = new Ads();
    $subsidiaryId = input('subsidiaryId');
    $parentId = input('parentId');

    if (!empty($subsidiaryId) && $subsidiaryId != 'any' && !empty($parentId)) {
        $catId = $Ads->category_of_subcat($parentId)->CAT_ID;

        $CustomFields = new CustomFields();
        $custom_fields = $CustomFields->getFieldsForSubsidiary($catId, $subsidiaryId, $parentId);

        if ($custom_fields) {
            $output['custom_field_status'] = true;

            foreach ($custom_fields as $field) {
                $output['custom_field_result'] .= $field->show('register', true);
                $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
            }
        }
    }

    echo json_encode($output);
}

/*------------------------------------------------
* Ajax Results after Selecting category in search
--------------------------------------------------*/
if (inputs()->not_empty('catId') && input('action') === "find-subcategory-for-search") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');

    if (input('catId') != 'any') {
        $CategoryList = new CategoryList();
        $subcategories = $CategoryList->parentSubCategoriesFor($catId);

        if ($subcategories) {
            $output['status'] = true;
            if (input('type') === 'submit') {
                $output['result'] = "<option value='any' disabled selected style='display: none;'>" . _e('CHOOSE', true) . "</option>";
            } else {
                $output['result'] = "<option value='any'>" . _e('ALL', true) . "</option>";
            }

            /** @var App\SubCategory $subcategory */
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->ID}>{$subcategory->name()}</option>";
            }
        } else {

            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForCategory($catId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;

                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('search', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }

        }
    }

    echo json_encode($output);
}

/*------------------------------------------------
* Ajax Results after Selecting subcategory in search
--------------------------------------------------*/
if (inputs()->not_empty('subcatId') && inputs()->not_empty('subcatId') && input('action') === "find-subsidiary-for-search") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');
    $subcatId = input('subcatId');

    if (input('subcatId') != 'any') {

        $Ads = new Ads();
        $subcategories = $Ads->subcategory_Subsidiaries($subcatId);

        if ($subcategories) {
            $output['status'] = true;
            $output['result'] = "<option value='any'>" . _e('ALL', true) . "</option>";
            /** @var Ads $subcategory */
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }

        } else {

            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForSubcategory($catId, $subcatId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;

                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('search', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }
        }
    }

    echo json_encode($output);
}

/*--------------------------------------------------
* Ajax Results after Selecting subsidiary in search
----------------------------------------------------*/
if (inputs()->not_empty('subsidiaryId') && input('action') === "find-final-result-for-search") {

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');
    $subcatId = input('subcatId');
    $subsidiaryId = input('subsidiaryId');

    $CustomFields = new CustomFields();


    if ($subsidiaryId != 'any') {
        $custom_fields = $CustomFields->getFieldsForSubsidiary($catId, $subcatId, $subsidiaryId);

    } else {
        $custom_fields = $CustomFields->getFieldsForSubcategory($catId, $subcatId);
    }

    if ($custom_fields) {
        $output['custom_field_status'] = true;

        foreach ($custom_fields as $field) {
            $output['custom_field_result'] .= $field->show('search', true);
            $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
        }
    }

    echo json_encode($output);
}

/**-----------------------------------------------
 * ajax result for ads type change in submit item
 ------------------------------------------------*/
if (input('action') == 'ads-type-changed') {
    $plan = (new Ads())->plan_by_id(input('planId'));
    $output = [
        'is_text' => ($plan->is_text()) ? true : false,
        'is_free' => ($plan->is_free()) ? true : false,
        'has_link' => ($plan->has_link()) ? true : false,
        'images_count' => $plan->MAX_IMG_COUNT,
        'tags_count' => $plan->MAX_KEYWORD_COUNT,
    ];

    echo json_encode($output);
    return false;
}

/**
 * Returns the extension options for requested plan
 */
if (inputs()->not_empty('plan_id') && input('action') === "fetch-extension-plans") {
    $Ads = new Ads();
    $plan = $Ads->plan_by_id(input('plan_id'));
    $ads_id = input('ads_id');

    return ajaxSuccessResponse(['html' => $plan->show_extension_options()]);
}


/*--------------------------------------------------
*     Checks for login parameter in submit page
----------------------------------------------------*/
if (input('action') === "check-login-param") {

    $login_param = input('login_param');
    $username_type = usernameType();

    if (is_email($login_param) && ($username_type === 'email' || $username_type === 'all')) {
        $user = $User->findByEmail($login_param);
    }
    if (is_mobile($login_param) && ($username_type === 'mobile' || $username_type === 'all')) {
        $user = $User->findByMobile($login_param);
    }

    $found = (isset($user) && !empty($user)) ? true : false;
    return ajaxSuccessResponse(['found' => $found]);
}

/*--------------------------------------------------
*     Checks for login parameter in submit page
----------------------------------------------------*/
if (input('action') === "check-coupon-code") {

    if (!isAjax()) {
        return ajaxErrorResponse('امکان اجرای این درخواست وجود ندارد');
    }

    $Coupon = new Coupon();
    $Ads = new Ads();

    $coupon = $Coupon->byCode(input('coupon_code'));
    $price = (int)input('price');

    if ($coupon) {
        $discount = $coupon->discountFor($price);
        $final_price = $coupon->applyOn($price);
        $description = "کد تخفیف {$coupon->code} - " . $coupon->discountDescription();
        return ajaxSuccessResponse(['coupon_code' => $coupon->code, 'description' => $description, 'discount' => '- ' . price_format($discount), 'final_price' => price_format($final_price)]);
    }

    return ajaxErrorResponse('کد تخفیف مورد نظر یافت نشد');
}

/**
 * Set Sessions and cookies when popup closed
 */
if (input('action') === 'close-popup') {

    if (setting('POPUP__SHOW_PERIOD') === 'SESSION') {
        session()->put(config('popup/session'), 'ON');
    }
    if (setting('POPUP__SHOW_PERIOD') === 'DAILY') {
        cookie()->put(config('popup/cookie'), 'ON', 86400); // 1day
    }

    return ajaxSuccessResponse();
}

