<?php
use App\Mailer;
use App\MessageBox;
use App\ReCaptcha;
use App\Template;
use App\Validate;

if (! isAjax()) {
    return false;
}
if (! isCountryAllowed()) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

$validation = new Validate();
$rules = [
    'subject' => [
        'name' => _e('SUBJECT', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 2
    ],
    'message' => [
        'name' => _e('MESSAGE', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 5
    ]
];
if (! $loggedUser || empty($loggedUser->NAME)) {
    $rules['name'] = [
        'name' => _e('NAME', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 3
    ];
}
if (! $loggedUser || empty($loggedUser->EMAIL)) {
    $rules['email'] = [
        'name' => _e('EMAIL', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'email' => true
    ];
}
if (! $loggedUser || empty($loggedUser->TEL)) {
    $rules['phone'] = [
        'name' => _e('PHONE_NUMBER', true),
        'prefix' => _e('ENTERING', true),
        'required' => true
    ];
}

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);
if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$ReCaptcha = new ReCaptcha();
if (! $ReCaptcha->verify('contact')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$userId = null;
$senderName = input('name');;
$senderMail = input('email');
$senderPhone = input('phone');
$subject = input('subject');
$message = input('message');

if ($loggedUser) {
    $userId = $loggedUser->USER_ID;

    $senderName = $loggedUser->username();
    if (not_empty($loggedUser->NAME)) {
        $senderName = $loggedUser->NAME;
    }
    if (not_empty($loggedUser->EMAIL)) {
        $senderMail = $loggedUser->EMAIL;
    }
    if (not_empty($loggedUser->TEL)) {
        $senderPhone = $loggedUser->TEL;
    }
}

$email_subject = emailSubject(_e('SENT_FROM_CONTACT_FORM', true));
$mailVariables = array(
    "title" => $email_subject,
    "subTitle" => "",
    "senderName" => $senderName,
    "senderMail" => $senderMail,
    "senderPhone" => $senderPhone,
    "subject" => $subject,
    "message" => $message
);
$message = Template::email('contact_us', $mailVariables);

$mailer = new Mailer();
$sent = $mailer->send(setting('EMAIL'), $message, $email_subject, setting('SITE_TITLE'), $senderMail, $senderName);

if ($sent) {
    $MessageBox = new MessageBox('email');
    $MessageBox->createNew([
        'USER_ID' => $userId,
        'TITLE' => $subject,
        'SENDER_NAME' => $senderName,
        'SENDER_MAIL' => $senderMail,
        'MESSAGE' => $message,
        'RECIVER_USER_ID' => $users,
        'RECIVER_MAIL' => $emails,
        'FROM' => 'USER',
        'TO' => 'ADMIN'
    ]);

    return ajaxSuccessResponse([
        'type' => 'html',
        'html' => _e('CONTACT_MESSAGE_SENT_SUCCESSFUL', true)
    ]);
}

return ajaxErrorResponse(_e('SENDING_FAILED', true));
