<?php

use App\Comment;
use App\ReCaptcha;
use App\Validate;

if (! isAjax()) {
    return false;
}

if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

if (! $loggedUser) {
    return ajaxErrorResponse(_e('COMMENT_LOGIN', true));
}

$validation = new Validate();
$rules = [
    'comment_body' => [
        'name' => _e('MESSAGE', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 5
    ]
];

$validation = $validation->check($_POST, $rules);
if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$ReCaptcha = new ReCaptcha();
if (! $ReCaptcha->verify('comment')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$comment = new Comment();
$data = [
    'post_id' => $item_id,
    'user_id' => $loggedUser->USER_ID,
    'parent_id' => 0,
    'status' => 1,
    'text' => input('comment_body'),
    'created_at' => now(),
    'ip' => getRealIp()
];

if ($comment->insert($data, $comment_type)) {
    return ajaxSuccessResponse([
        'type' => 'html',
        'html' => _e('COMMENT_SEND_SUCCESS', true),
        'message' => _e('COMMENT_SEND_SUCCESS', true)
    ]);
}

return ajaxErrorResponse(_e('OPERATION_FAILED', true));