<?php

use App\ReCaptcha;
use App\User;
use App\Validate;

if (! isAjax()) {
    redirect(registerLink());
}

if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

$register_param_type = input('register_param');

$rules = [
    'register_param' => array(
        'name' => _e('MOBILE_OR_EMAIL', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'unique' => 'tbl_users'
    ),
    'password' => array(
        'name' => _e('PASSWORD', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 6
    ),
    'password_confirm' => array(
        'name' => _e('PASSWORD_CONFIRMATION', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'matches' => 'password'
    )
];

if (registerNeedsActivation() && isActivateWithOnlyEmail()) {

    $rules['register_param']['email'] = true;
    $rules['register_param']['unique_column'] = 'EMAIL';
} elseif (registerNeedsActivation() && isActivateWithOnlySms()) {

    $rules['register_param']['mobile'] = true;
    $rules['register_param']['unique_column'] = 'TEL';
} else {

    $rules['register_param']['username'] = true;
    if (is_mobile($register_param_type)) {
        $rules['register_param']['unique_column'] = 'TEL';
    }
    if (is_email($register_param_type)) {
        $rules['register_param']['unique_column'] = 'EMAIL';
    }
}

// if (! $User->isUniqueUsername($register_param_type)) {
//     $validate->addError(_e('NOT_UNIQUE_USERNAME', true));
// }

$validation = new Validate();
$validation = $validation->check($_POST, $rules);

if (! $validation->passed()) {
    return ajaxErrorResponse($validation->errors());
}

$ReCaptcha = new ReCaptcha();
if (! $ReCaptcha->verify('register')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$activation_code = null;

$refererId = input('referer_id');
if (cookie()->exists('COOK_KODESIGN_REFERAL')) {
    $User = new User();
    $referer = $User->findByUuid(cookie()->get('COOK_KODESIGN_REFERAL'));
    $refererId = $referer->USER_ID;
}

$username = en_digits($register_param_type);
$email = $mobile = $verified_email = $verified_mobile = null;
if (is_email($username)) {
    $email = $username;
}
if (is_mobile($username)) {
    $mobile = $username;
}
if (! registerNeedsActivation()) {
    $verified_mobile = $mobile;
    $verified_email = $email;
}

try {
    $userId = $User->register($username, input('password'), $email, $mobile, $refererId, $verified_email, $verified_mobile);

    $user = $User->findById($userId);

    cookie()->delete('COOK_KODESIGN_REFERAL');

    $register_method = 'email';
    if (is_mobile($username)) {
        $register_method = 'mobile';
    }

    if (registerNeedsActivation()) {
        if (($register_method == 'email' || ($register_method == 'ALL' && is_email($username))) && canActivateWithEmail()) {
            $activation_code = $user->createAuthToken('activation_full', $user->EMAIL);
            $user->sendActivationCodeWithAccountInfoEmail($activation_code, input('password'), 'full');
        }
        if (($register_method == 'mobile' || ($register_method == 'ALL' && is_mobile($username))) && canActivateWithSms()) {
            $user->sendActivationCodeWithAccountInfoSms(input('password'));
        }
    }

    if (! registerNeedsActivation()) {
        if ($register_method == 'email' && setting('SEND_EMAIL_AFTER_REGISTER') === "YES") {
            $user->sendWelcomeEmail(input('password'));
        }

        if ($register_method == 'mobile' && setting('SEND_SMS_AFTER_REGISTER') === "YES") {
            $user->sendWelcomeSms();
        }
    }

    if (! registerNeedsActivation() && setting('LOGIN_AFTER_REGISTER') === "YES") {
        $user->login();

        return ajaxSuccessResponse([
            'type' => 'redirect',
            'url' => myListingsLink(),
            'message' => _e('REGISTER_SUCCESS_REDIRECTING', true)
        ]);
    }

    if (! registerNeedsActivation() && setting('LOGIN_AFTER_REGISTER') !== "YES") {
        return ajaxSuccessResponse([
            'type' => 'html',
            'html' => _e('USER_REGISTER_SUCCESS', true)
        ]);
    }

    if ($register_method == 'email' && canActivateWithEmail()) {
        return ajaxSuccessResponse([
            'type' => 'html',
            'html' => _e('CONFIRMATION_MAIL_SENT', true)
        ]);
    }
    if ($register_method == 'mobile' && canActivateWithSMS()) {
        $user->login();

        return ajaxSuccessResponse([
            'type' => 'redirect',
            'url' => smsActivationLink()
        ]);
    }
} catch (PDOException $e) {
    return ajaxErrorResponse(_e('REGISTRATION_FAILED_ERROR', true));
}
