<?php

use App\ReCaptcha;
use App\User;
use App\Validate;

if (! isAjax()) {
    redirect(loginLink());
}
if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

$rules = [
    'username' => [
        'name' => _e('USERNAME', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
    ],
    'password' => [
        'name' => _e('PASSWORD', true),
        'prefix' => _e('ENTERING', true),
        'required' => true
    ]
];

$validation = new Validate();
$validation = $validation->check($_POST, $rules);

if (! $validation->passed()) {
    return ajaxErrorResponse($validation->errors());
}

$ReCaptcha = new ReCaptcha();
if (! $ReCaptcha->verify('login')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$login_param = en_digits(input('username'));

$User = new User();
$user = $User->findForLogin($login_param, input('password'));

if ($user && $user->hasCorrectAccessLevel()) {

    if (registerNeedsActivation() && $user->isPendingActivation()) {
        $activate_with_email = $activate_with_mobile = false;

        if (is_email($login_param) && canActivateWithEmail()) {
            $activate_with_email = true;
            $email_to_activate = $login_param;
        }
        if (is_mobile($login_param) && canActivateWithSMS()) {
            $activate_with_mobile = true;
        }

        if (is_email($login_param) && !canActivateWithEmail()) {
            if ($user->hasAnyMobileForActivation() && canActivateWithSms()) {
                $activate_with_mobile = true;
            } else {
                return ajaxErrorResponse(_e('USER_ACCOUNT_SHOULD_ACTIVATE_BY_ADMIN', true));
            }
        }

        if (is_mobile($login_param) && !canActivateWithSMS()) {

            if ($user->hasAnyEmailForActivation() && canActivateWithEmail()) {
                $activate_with_email = true;
                $email_to_activate = $user->hasAnyEmailForActivation();
            } else {
                return ajaxErrorResponse(_e('USER_ACCOUNT_SHOULD_ACTIVATE_BY_ADMIN', true));
            }
        }

        if ($activate_with_email) {
            if ($user->canSendAuthTokenMessage('activation')) {
                $activation_code = $user->createAuthToken('activation_full', $email_to_activate);
                $user->sendActivationCodeEmail($activation_code, 'full', $email_to_activate);
            }

            $error = _e('USER_IS_AWAITING_ACTIVATION_EMAIL', true);

            return ajaxErrorResponse($error);
        }

        if ($activate_with_mobile) {
            $user->login();

            return ajaxSuccessResponse([
                'type' => 'redirect',
                'url'  => smsActivationLink(),
                'message' => _e('REDIRECTING', true)
            ]);
        }

    }

    if (! registerNeedsActivation() && $user->isPendingActivation()) {
        return ajaxErrorResponse(_e('USER_ACCOUNT_SHOULD_ACTIVATE_BY_ADMIN', true));
    }


    if ($user->isRejected()) {
        return ajaxErrorResponse(_e('USER_ACCOUNT_SUSPENDED', true));
    }

    $user->login();
    if (! $user->isPendingActivation() && inputs()->is_set('remember')) {
        $user->remember();
    }

    return ajaxSuccessResponse([
        'type' => 'redirect',
        'url'  => $user->isCommonUser() ? myListingsLink() : adminroot(),
        'message' => _e('REDIRECTING', true)
    ]);

} else {
    return ajaxErrorResponse(_e('INCORRECT_USERNAME_AND_PASSWORD', true));
}