<?php

use App\ReCaptcha;
use App\Validate;

if (!isAjax()) {
    redirect(loginLink());
}

if (!token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

if (isDemoMode()) {
    return ajaxErrorResponse(_e('DEMO_VERSION_NOTICE', true));
}

$validation = new Validate();
$validation = $validation->check($_POST, array(
    'forget_param' => array(
        'name' => usernameTitle(true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
    ),
));


if (!$validation->passed()) {
    return ajaxErrorResponse($validation->errors());
}

$ReCaptcha = new ReCaptcha();
if (!$ReCaptcha->verify('forgot')) {
    return ajaxErrorResponse($ReCaptcha->error());
}

$forgot_parameter = input('forget_param');
$param_type = (is_mobile($forgot_parameter)) ? 'mobile' : 'email';

$user = $User->findForForgotPassword($forgot_parameter);

if ($user && $user->canSendAuthTokenMessage('forgot')) {

    if ($param_type === 'mobile' && canActivateWithSMS() && $user->hasVerifiedMobile()) {

        $user->sendResetPasswordSms();

        return ajaxSuccessResponse([
            'type' => 'redirect',
            'url' => forgotPasswordVerifyCodeLink(),
            'message' => _e('REDIRECTING', true)
        ]);
    }

    if ($param_type === 'email') {

        $email = $user->hasAnyEmailForActivation();
        if (canActivateWithEmail()) {
            $email = $user->officialEmail();
        }

        $token = $user->createAuthToken('forgot', $email);
        $user->sendResetPasswordEmail($token, $email);
    }

}

$message = _e('FORGOT_PASSWORD_REQUEST_SENT', true);
if (!registerNeedsActivation()) {
    $message = _e('FORGOT_PASSWORD_EMAIL_SENT', true);
}

return ajaxSuccessResponse([
    'type' => 'html',
    'html' => $message
]);
