<?php
use App\User;

require_once '../../init.php';

$User = new User();
$loggedUser = $User->findById(session()->get('SESS_USER_ID'));
if( ! $loggedUser || ! $loggedUser->hasCorrectAccessLevel()){
    $loggedUser = null;
}

if (! isAjax()) {
    abort();
}

/*--------------------------------------------------
*           Checks for activation code
----------------------------------------------------*/
if(input('action') === "check-activation-code") {

    if( ! isAjax() || ! token()->check() || ! $loggedUser ) {
        return ajaxErrorResponse(_e('CANT_OPERATE', true));
    }

    if( $loggedUser->verifyActivationCode(input('activation_code')) ) {
        $html = includeFile(LANG_PATH.'includes'.DS.'page_contents'.DS.'account'.DS.'_modal_submitting.php');

        return ajaxSuccessResponse(['html' => $html]);
    }

    return ajaxErrorResponse(_e('WRONG_CODE', true));
}

/*--------------------------------------------------
*           Send activation code
----------------------------------------------------*/
if(input('action') === "send-activation-code") {

    $method = input('activation_method');
    if( ! isAjax() || ! token()->check() || ! $loggedUser || ! in_array($method, ['email', 'mobile']) ) {
        return ajaxErrorResponse('امکان اجرای عملیات وجود ندارد');
    }

    if( $loggedUser->canSendAuthTokenMessage('activation') ) {
        if($method === 'mobile' && canActivateWithSMS()) {
            $loggedUser->sendActivationCodeSms();
            return ajaxSuccessResponse(['resend_time' => $loggedUser->resendAuthTokenTime(), 'method' => $method, 'message' => "کد فعالسازی شما به شماره {$loggedUser->hasAnyMobileForActivation()} ارسال شده است"]);
        }
        if($method === 'email' && canActivateWithEmail()) {
            $activation_code = $loggedUser->createAuthToken('activation', $loggedUser->hasAnyEmailForActivation());
            $loggedUser->sendActivationCodeEmail($activation_code);
            return ajaxSuccessResponse(['resend_time' => $loggedUser->resendAuthTokenTime(), 'method' => $method, 'message' => "کد فعالسازی شما به آدرس ایمیل {$loggedUser->hasAnyEmailForActivation()} ارسال شده است"]);
        }

    }

    return ajaxErrorResponse('لطفا تا زمان اتمام شمارشگر منتظر بمانید');
}
