<?php
require '../../init.php';

if (setting('MAP__SOURCE') === 'CEDAR') {
    $token = setting('MAP__CEDAR_API_TOKEN');
    $address = "https://api.cedarmaps.com/v1/geocode/cedarmaps.streets/" . input('q') . "?access_token={$token}&limit=20";
    $results = json_decode(file_get_contents($address));
}

if (setting('MAP__SOURCE') === 'OSM') {
    $address = "https://nominatim.openstreetmap.org/search.php?q=" . input('q') . "&format=json&addressdetails=0&namedetails=1&accept-language=fa&email=info@kodesign.ir";
    $results = json_decode(file_get_contents($address));
}

if (setting('MAP__SOURCE') === 'NESHAN') {
    $curl = curl_init();

    $address = 'https://api.neshan.org/v1/search?term='.urlencode(input('q')).'&lat=51.05923800000005&lng=51.05923800000005';

    curl_setopt_array($curl, array(
        CURLOPT_URL => $address,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'api-key: '. setting('MAP__NESHAN_SERVICES_TOKEN')
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $results = optional(json_decode($response))->items;
}

//$results = '[{"place_id":275392143,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"relation","osm_id":6558660,"boundingbox":["31.3559793","31.6149008","51.259598","51.5720449"],"lat":"31.4865404","lon":"51.37751114789563","display_name":"ونک, بخش مرکزی سمیرم, شهرستان سمیرم, استان اصفهان, ایران","class":"boundary","type":"administrative","importance":0.5321243884598816,"icon":"https://nominatim.openstreetmap.org/images/mapicons/poi_boundary_administrative.p.20.png","namedetails":{"name":"ونک"}},{"place_id":47420983,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"node","osm_id":3721985029,"boundingbox":["34.6566817","34.6966817","49.5094575","49.5494575"],"lat":"34.6766817","lon":"49.5294575","display_name":"ونک, تلخاب, بخش خنجین, شهرستان فراهان, استان مرکزی, ایران","class":"place","type":"village","importance":0.385,"icon":"https://nominatim.openstreetmap.org/images/mapicons/poi_place_village.p.20.png","namedetails":{"name":"ونک"}},{"place_id":45260784,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"node","osm_id":3339506503,"boundingbox":["31.5080386","31.5480386","51.3037006","51.3437006"],"lat":"31.5280386","lon":"51.3237006","display_name":"ونک, بخش مرکزی سمیرم, شهرستان سمیرم, استان اصفهان, ایران","class":"place","type":"village","importance":0.385,"icon":"https://nominatim.openstreetmap.org/images/mapicons/poi_place_village.p.20.png","namedetails":{"name":"ونک","name:en":"Vanak","name:fa":"ونک"}},{"place_id":40398173,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"node","osm_id":3019041323,"boundingbox":["25.5165447","25.5565447","58.8563047","58.8963047"],"lat":"25.5365447","lon":"58.8763047","display_name":"ونک, پی وشک, بخش لیردوف, شهرستان جاسک, هرمزگان, ایران","class":"place","type":"village","importance":0.385,"icon":"https://nominatim.openstreetmap.org/images/mapicons/poi_place_village.p.20.png","namedetails":{"name":"ونک"}},{"place_id":275385471,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"relation","osm_id":8321834,"boundingbox":["35.7496533","35.7802167","51.3868831","51.4243279"],"lat":"35.764663","lon":"51.4058606","display_name":"ونک, منطقه ۳, منطقه ۳ شهر تهران, تهران, بخش مرکزی شهرستان تهران, شهرستان تهران, استان تهران, ایران","class":"boundary","type":"administrative","importance":0.30999999999999994,"icon":"https://nominatim.openstreetmap.org/images/mapicons/poi_boundary_administrative.p.20.png","namedetails":{"name":"ونک","name:en":"Vanak","name:fa":"ونک"}},{"place_id":196500981,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"way","osm_id":505309720,"boundingbox":["35.7603143","35.7614224","51.4037897","51.4056017"],"lat":"35.7605192","lon":"51.405268","display_name":"ونک, منطقه ۳, منطقه ۳ شهر تهران, تهران, بخش مرکزی شهرستان تهران, شهرستان تهران, استان تهران, 1994766411, ایران","class":"highway","type":"secondary","importance":0.21,"namedetails":{"name":"ونک","name:en":"Vanak Street","name:fa":"ونک"}},{"place_id":121034541,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"way","osm_id":153259338,"boundingbox":["35.765134","35.7658948","51.3965345","51.3977451"],"lat":"35.765134","lon":"51.3977451","display_name":"ونک, منطقه ۳, منطقه ۳ شهر تهران, تهران, بخش مرکزی شهرستان تهران, شهرستان تهران, استان تهران, 1991818, ایران","class":"highway","type":"secondary","importance":0.21,"namedetails":{"name":"ونک","name:en":"Vanak Street","name:fa":"ونک"}},{"place_id":81599316,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"way","osm_id":4299807,"boundingbox":["35.7578398","35.7603143","51.4056017","51.4096035"],"lat":"35.759525","lon":"51.4068787","display_name":"ونک, منطقه ۳, منطقه ۳ شهر تهران, تهران, بخش مرکزی شهرستان تهران, شهرستان تهران, استان تهران, 1969943911, ایران","class":"highway","type":"secondary","importance":0.21,"namedetails":{"name":"ونک","name:en":"Vanak Street","name:fa":"ونک"}},{"place_id":195191868,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"way","osm_id":502365955,"boundingbox":["38.0311818","38.0314182","46.3569288","46.3573398"],"lat":"38.0314182","lon":"46.3573398","display_name":"ونک, مرز محله, رجایی شهر, تبریز, بخش مرکزی شهرستان تبریز, شهرستان تبریز, استان آذربایجان شرقی, 5157857934, ایران","class":"highway","type":"residential","importance":0.21,"namedetails":{"name":"ونک"}},{"place_id":161023472,"licence":"Data © OpenStreetMap contributors, ODbL 1.0. https://osm.org/copyright","osm_type":"way","osm_id":307582113,"boundingbox":["38.0569","38.0569015","46.3187279","46.3193878"],"lat":"38.0569","lon":"46.3193878","display_name":"ونک, گلگشت, کوی انقلاب, تبریز, بخش مرکزی شهرستان تبریز, شهرستان تبریز, استان آذربایجان شرقی, 51658, ایران","class":"highway","type":"residential","importance":0.21,"namedetails":{"name":"ونک"}}]';
//$results = json_decode($results);

$output = [];
foreach ($results as $result) {
    if (setting('MAP__SOURCE') === 'CEDAR') {
        list($latitude, $longitude) = explode(',', $result->location->center);

        $title = "";
        $title .= (! empty($result->name)) ? "<strong>{$result->name}, </strong>" : '';
        $title .= (! empty($result->components->country)) ? "{$result->components->country}, " : '';
        $title .= (! empty($result->components->province)) ? "{$result->components->province}, " : '';
        $title .= (! empty($result->components->city)) ? "{$result->components->city}, " : '';
        $title .= (! empty($result->address)) ? "{$result->address}, " : '';
    }

    if (setting('MAP__SOURCE') === 'OSM') {
        $title = $result->display_name;
        $latitude = $result->lat;
        $longitude = $result->lon;
    }

    if (setting('MAP__SOURCE') === 'NESHAN') {
        $title = "<strong>{$result->title}</strong> ";
        $latitude = $result->location->y;
        $longitude = $result->location->x;

        $title .= (! empty($result->region)) ? ", {$result->region}" : '';
    }

    $output[] = [
        'loc' => [$latitude, $longitude],
        'title' => $title
    ];
}

return ajaxSuccessResponse(['result' => $output], JSON_NUMERIC_CHECK);