<?php

use App\Like;

require_once '../../init.php';

if (! isAjax()) {
    return false;
}

$Like = new Like();

$action = input('action');
$link_id = input('link_id');
$allowed_post_types = ['ads', 'post'];
$post_type = input('post_type');

if (!in_array($post_type, $allowed_post_types)) {
    return ajaxErrorResponse(_e('INVALID_OPERATION', true));
}

if (cookie()->exists($Like->cookieName($post_type, $link_id))) {
    return ajaxErrorResponse(_e('ALREADY_VOTED', true));
}


if ( ($action == 'like' && $Like->addLike($link_id, $post_type)) ||
     ($action == 'dislike' && $Like->addDislike($link_id, $post_type)))
{
    cookie()->put($Like->cookieName($post_type, $link_id), 1, 86400);

    return ajaxSuccessResponse(['type' => $action]);
}

return ajaxErrorResponse(_e('INVALID_OPERATION', true));



