<?php

require_once '../../init.php';
include '../../includes/core/check_auth.php';

if (! isAjax()) {
    return false;
}

if (! currentUser()) {
    return ajaxErrorResponse(_e('LOGIN_FOR_ADD_TO_FAVOURITES', true));
}

$ads = ads()->byIdSimple(input('link_id'));

if (! $ads) {
    return ajaxErrorResponse(_e('INVALID_OPERATION', true));
}

$favourite = $ads->isFavouredByCurrentUser();

if ($favourite) {
    $favourite->delete();

    return ajaxSuccessResponse([
       'action' => 'deleted'
    ]);
}

if (currentUser()->addAdsToFavourites($ads->id())) {
    return ajaxSuccessResponse([
        'action' => 'added'
    ]);
}

return ajaxErrorResponse(_e('INVALID_OPERATION', true));



