<?php

use App\CategoryList;
use App\CustomFields;

require_once '../../init.php';

if (!isAjax()) {
    return false;
}

$category_id = input('category');
$subcategory_id = input('subcategory');
$subsidiary_id = input('subsidiary');

$custom_fields = "";

if (!empty($category_id) && !$subcategory_id) {
    $CategoryList = new CategoryList();
    $subcategories = $CategoryList->parentSubCategoriesFor($category_id);

    foreach ($subcategories as $subcategory) {
        $result .= "<li class='dropdown-list-item' data-category='{$category_id}' data-subcategory='{$subcategory->id()}'>{$subcategory->name()}</li>";
    }
}

if (!empty($category_id) && !empty($subcategory_id) && !$subsidiary_id) {
    $CategoryList = new CategoryList();
    $subcategories = $CategoryList->childSubCategoriesFor($subcategory_id);

    foreach ($subcategories as $subcategory) {
        $result .= "<li class='dropdown-list-item' data-category='{$subcategory->parentCategoryId()}' data-subcategory='{$subcategory_id}' data-subsidiary='{$subcategory->id()}'>{$subcategory->name()}</li>";
    }
}

if (empty($result)) {
    $CustomFields = new CustomFields();
    $found_custom_fields = $CustomFields->getFieldsSmartly($category_id, $subcategory_id, $subsidiary_id);

    $show_type = inputs()->not_empty('type') ? input('type') : 'search';

    foreach ($found_custom_fields as $field) {
        $custom_fields .= $field->show($show_type, true);
        $custom_fields .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
    }
}

return ajaxSuccessResponse(compact('result', 'custom_fields'));
