<?php
use App\Ads;
use App\Input;
use App\Session;
use App\Token;

require_once '../../init.php';
require_once (INC_PATH.'check_auth_account.php');

if( ! isPost() || ! inputs()->not_empty('id') ) {
    redirect('restrict');
}

if( ! token()->check() ) {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

$Ads = new Ads();
$ads = $Ads->ads_by_id(input('id'), false);

if( ! $ads || ! $loggedUser->owns($ads) || $ads->updateCountLeft() == 0 ) {
    redirect(404);
}

if(!$ads || $ads->updateCountLeft() == 0){
        abort();
        exit();
    }

try{
    $ads->mutate();
    session()->alert( 'success', _e( 'MUTATE_SUCCESS', true, ['{%1%}' => $ads->ADS_ID] ) );
}catch(Exception $e) {
    session()->alert('error',  _e('OPERATION_FAILED', true));
}

redirect('refer');
