<?php
use App\Session;
use App\WithdrawalRequest;

checkUserCountry();

/** @var App\User $loggedUser */
$affiliates = $loggedUser->affiliates(1);
if( ! $affiliates ) {
    $error = _e('NO_ACTIVE_COMMISION', true);
    session()->alert('error', $error);
    redirect(affiliateHistoryLink());
}

$referal_ids = array();
$price = 0;

if(empty($loggedUser->CREDIT_CARD) || trim($loggedUser->CREDIT_CARD) == ""){
    $error = _e('WITHDRAWAL_CREDIT_CARD_ERROR', true);
    session()->alert('error', $error);
    redirect(affiliateHistoryLink());
}

try
{
    $db->beginTransaction();

    /** @var App\Affiliate $affiliate */
    foreach ($affiliates as $affiliate) {
        $affiliate->update($affiliate->id, 'suspend');
        $referal_ids[] = $affiliate->id;
        $price += $affiliate->commision;
    }

    if( $price < setting('MIN_AFFILIATE_WITHDRAWAL_COST') ) {
        $error = _e('WITHDRAWAL_MINIMUM_ERROR', true, array("{%1%}", number_format(setting('MIN_AFFILIATE_WITHDRAWAL_COST'))));
        session()->alert('error', $error);
        redirect('refer');
    }

    $referal_ids = json_encode($referal_ids);
    $WithdrawalRequest = new WithdrawalRequest();
    $WithdrawalRequest->insert($loggedUser->USER_ID, $price, $referal_ids);

    $db->commit();

    if( setting('SEND_EMAIL_AFTER_WITHDRAWAL_REQUEST') === "YES" ) {
        $Affiliate->sendWithdrawalRequestEmailToUser(currentUser()->EMAIL, currentUser()->NAME, currentUser()->USER_ID);
    }

    $error = _e('WITHDRAWAL_REQUEST_SENT_SUCESSFUL', true);
    session()->alert('success', $error);

}catch(PDOException $e){
    $db->rollBack();
    session()->error(_e('WITHDRAWAL_REQUEST_FAILED', true));
}

redirect(affiliateHistoryLink());
