<?php

use App\Validate;

if (!isAjax() || !token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

if (!$loggedUser) {
    return ajaxErrorResponse(_e('NO_PERMISSION_WARNING', true));
}

$rules = [
    'name' => [
        'name' => _e('FULL_NAME', true),
        'max' => 100,
    ],
    'website' => [
        'url' => true
    ],
    'email' => [
        'name' => _e('EMAIL', true),
        'email' => true,
        'unique' => 'tbl_users',
        'unique_column' => "EMAIL|{$loggedUser->USER_ID}"
    ],
    'phone' => [
        'name' => _e('MOBILE', true),
        'mobile' => true,
        'unique' => 'tbl_users',
        'unique_column' => "TEL|{$loggedUser->USER_ID}"
    ]
];

$website = input('website');
$_POST['website'] = addHttp($website);

$validation = (new Validate())->check($_POST, $rules);

if (! $validation->passed()) {
    return ajaxErrorResponse($validation->errors());
}

try {
    $should_change_mobile = (! canActivateWithSms() && !$loggedUser->hasVerifiedMobile() && !is_mobile($loggedUser->USERNAME));
    $should_change_email = (! canActivateWithEmail() && !is_email($loggedUser->EMAIL));

    if (! is_email($loggedUser->EMAIL) && ! is_email(input('email'))) {
        $_POST['email'] = $loggedUser->hasAnyEmailForActivation();
        $should_change_email = true;
    }

    $loggedUser->updateGeneralInfo(
        input('name'),
        input('phone'),
        strip_tags(input('credit_card')),
        strip_tags(input('address')),
        strip_tags(input('biography')),
        $website,
        $should_change_mobile,
        $should_change_email,
        input('email')
    );

    $loggedUser->updateMetas(inputs()->metas());

    return ajaxSuccessResponse([
        'message' => _e('ACTION_COMPLETED', true),
        'type' => 'html',
        'html' => _e('ACTION_COMPLETED', true)
    ]);
} catch (PDOException $e) {
    return ajaxErrorResponse(_e('ACTION_FAILED', true));
}





