<?php
use App\Validate;

if (!isAjax() || !token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

if (!$loggedUser) {
    return ajaxErrorResponse(_e('NO_PERMISSION_WARNING', true));
}

if( ! $loggedUser->verifyPassword(input('old_password')) ) {
    return ajaxErrorResponse(_e('INVALID_OLD_PASSWORD', true));
}

$rules = array(
    'password' => array(
        'name' => _e('PASSWORD', true),
        'prefix' => _e('ENTERING', true),
        'required' => true
    ),
    'password_confirm' => array(
        'name' => _e('PASSWORD_CONFIRMATION', true),
        'prefix' => _e('ENTERING', true),
        'required' => true ,
        'matches' => 'password'
    )
);

$validation = (new Validate())->check($_POST, $rules);

if( ! $validation->passed() ) {
    return ajaxErrorResponse($validation->errors());
}

try {
    $loggedUser->changePassword(input('password'));
    session_regenerate_id(true);

    return ajaxSuccessResponse([
       'type' => 'html',
       'html' =>  _e('ACTION_COMPLETED', true),
       'message' => _e('ACTION_COMPLETED', true)
    ]);

} catch(PDOException $e) {
    return ajaxErrorResponse(_e('ACTION_FAILED', true));
}