<?php

checkUserCountry();

if( ! token()->check() ) {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

if( ! $loggedUser ) {
    redirect('refer');
}

try{
    /* move uploaded image to it's real destination */
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));
    $images_root  = "images/users_images/{$loggedUser->USER_ID}/";

    if( ! empty($uploaded_images) && count($uploaded_images) == 1) {
        $image = data_get($uploaded_images, 0);

        $source       = "images/estate_images/app_temp/{$image->name}.jpg";
        $destination  = $images_root . "1.jpg";

        unlink($destination);

        if( is_file($source) ) {
            if( ! is_dir($images_root) ){
                mkdir($images_root);
            }

            rename($source, $destination);

            $key = array_search($image->name, $all_uploaded_images);
            if( $key == 0 || $key != false) {
                unset($all_uploaded_images[$key]);
            }
        }
    }

    /* delete redundant uploaded images */
    foreach($all_uploaded_images as $image) {

        if(empty($image)) {
            continue;
        }

        $source  = "images/estate_images/app_temp/{$image}.jpg";
        if( is_file($source) ) {
            unlink($source);
        }

    }

    session()->success(_e('ACTION_COMPLETED', true));

}catch(Exception $e) {
    session()->error($e->getMessage());
}

redirect(changeAvatarLink());
