<?php

use App\Image;
use App\Validate;

if (! isAjax()) {
    return false;
}
if (! isCountryAllowed()) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if (! $loggedUser) {
    return ajaxErrorResponse(_e('SUBMIT__LOGIN_VALIDATION_ERROR', true));
}

$validation = new Validate();
$rules = [
    'frm_title' => [
        'name' => _e('ADS_TITLE', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 10,
        'max' => 200
    ],
    'category' => [
        'name' => _e('ADS_CATEGORY', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'numeric' => true
    ],
    'subcategory' => [
        'name' => _e('ADS_CATEGORY', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'numeric' => true,
        'not_any' => true
    ],
    'frm_description' => [
        'name' => _e('ADS_DESCRIPTION', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 20,
    ],
    'frm_discount' => [
        'name' => _e('DISCOUNT', true),
        'percent' => true
    ],
    'state' => [
        'name' => _e('STATE', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'not_any' => true,
        'numeric' => true
    ],
    'city' => [
        'name' => _e('CITY', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'not_any' => true,
        'numeric' => true
    ],
    'frm_email' => [
        'name' => _e('ADS_EMAIL', true),
        'email' => true
    ]
];

$catId = input('category');
$subcatId = input('subcategory');
$subsidiaryId = input('subsidiary');
$has_subsidiary = $Ads->hasSubsidiary($subcatId);

if ($has_subsidiary && (!$subsidiaryId || $subsidiaryId == 'any')) {
    $error = _e('SUBMIT__SUBSIDIARY_VALIDATION_ERROR', true);
    $validation->addError($error);
}

if ($has_subsidiary) {
    $custom_fields = $CustomFields->getFieldsForSubsidiary($catId, $subsidiaryId, $subcatId);
} else {
    $custom_fields = $CustomFields->getFieldsForSubcategory($catId, $subcatId);
}

/** @var App\CustomFields $field */
foreach ($custom_fields as $field) {
    if ($field->field_type == 'price') {
        $rules = $field->set_price_field_rule($rules);
    } else {
        $rules[$field->field_name] = $field->rules();
    }
}

$slug_name = slug(input('frm_title'));
$slug_name = $Ads->slug($slug_name);

if (empty($slug_name) || trim($slug_name) == '') {
    $error = _e('ADS_TITLE_ERROR', true);
    $validation->addError($error);
}
if (strlen($slug_name) > 250) {
    $error = _e('ADS_TITLE_LENGTH_ERROR', true);
    $validation->addError($error);
}

$validation = $validation->check($_POST, $rules);
/** @var App\Validate $validation */
if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$categoryId = $subcatId;
if ($has_subsidiary) {
    $categoryId = $subsidiaryId;
}

$description = strip_tags(input('frm_description'), '<br><br/>');
$discount = $price = $link = null;
if (inputs()->not_empty('frm_discount')) {
    $discount = (int)input('frm_discount');
}

if (! $custom_fields) {
    if (inputs()->not_empty('frm_price_deal')) {
        $price = 'DEAL';
    } elseif (inputs()->not_empty('frm_price')) {
        $price = money_to_num(en_digits(input('frm_price')));
    }
}

if ($current_plan->has_link()) {
    $link = input('frm_link');
}

$owner_email = $ads->ADS_OWNER_EMAIL;
$owner_phone = $ads->ADS_OWNER_PHONE;
if (!canActivateWithEmail()) {
    $owner_email = en_digits(input('frm_email'));
}
if (!canActivateWithSms()) {
    $owner_phone = en_digits(input('frm_tel'));
}

try {
    $adsId = $ads->ADS_ID;

    $db->beginTransaction();
    /**
     * Update ads
     */
    $ads->update(inputs()->all(), $owner_email, $owner_phone, $categoryId, $link, $price, $discount);

    /**
     * Save Custom Fields
     */
    $CustomFields->deleteAllAdsItem($adsId);
    if ($custom_fields) {
        foreach ($custom_fields as $field) {
            $field->save($adsId);
        }
    }

    $ads->make_deActive();
    $ads->make_hide();

    $ads_status = $ads->ads_general_status(true);

    if ($ads_status == 2 || $ads_status == 6 || $ads_status == 7) {
        $ads->make_edited();
    }


    /**
     * Handling Tags
     */
    /** @var App\Tag $Tags */
    if (inputs()->not_empty('frm_keywords')) {
        $current_tags_array = $Tags->listsFor($adsId, 'ads');
        if (!isArrayEqual($current_tags_array, input('frm_keywords'))) {
            $Tags->deleteAll($adsId);
            $Tags->handle(input('frm_keywords'), $adsId, 'ads', $current_plan->MAX_KEYWORD_COUNT);
        }
    } else {
        $Tags->deleteAll($adsId);
    }


    /* move uploaded images to it's real destination */
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));

    $ImageDb = new Image();

    $source_root = "images/estate_images/app_temp/";
    $destination_root = "images/estate_images/{$adsId}/";

    if (!is_dir($destination_root)) {
        mkdir($destination_root);
    }

    foreach ($ads_images as $ads_image) {
        $ads_image = removeSizeFromImageName($ads_image);

        if (!in_array(removeExtension(basename($ads_image)), array_column($uploaded_images, 'name'))) {
            unlink($ads_image);

            foreach ($image_sizes as $size_name => $size_options) {
                unlink(imageNameForSize($ads_image, $size_name));
            }
        }
    }

    $ads->deleteImagesFromDatabase();

    $db_images = [];
    $i = 1;
    foreach ($uploaded_images as $image) {

        if ($i > $current_plan->MAX_IMG_COUNT) {
            continue;
        }

        $source_main = "{$source_root}{$image->name}.jpg";
        $destination_main = "{$destination_root}{$image->name}.jpg";

        if (file_exists($destination_main)) {
            $db_images[] = $ImageDb->createNew($adsId, $destination_main);
            $i++;
            continue;
        }

        if (!is_file($source_main)) {
            continue;
        }

        rename($source_main, $destination_main);

        $db_images[] = $ImageDb->createNew($adsId, $destination_main);

        foreach ($image_sizes as $size_name => ['size' => $size]) {
            $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";
            $sized_destination = "{$destination_root}{$image->name}-{$size_name}.jpg";

            if (!is_file($sized_source)) {
                continue;
            }

            rename($sized_source, $sized_destination);
        }

        $key = array_search($image->name, $all_uploaded_images);
        if ($key == 0 || $key != false) {
            unset($all_uploaded_images[$key]);
        }

        $i++;
    }

    /* delete redundant uploaded images */
    foreach ($all_uploaded_images as $image) {

        if (empty($image)) {
            continue;
        }

        $source_main = "{$source_root}{$image->name}.jpg";

        if (is_file($source_main)) {
            unlink($source_main);
        }

        foreach ($image_sizes as $size_name => ['size' => $size]) {
            $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";

            if (is_file($sized_source)) {
                unlink($sized_source);
            }
        }
    }


    $ads = $Ads->ads_by_id($adsId, false);

    $ads->setFeaturedImage($db_images[0]);

    $db->commit();

    $html = includeFile('languages/includes/page_contents/edit_ads/_successful_edit.php', [
        'ads_status' => $ads->ads_general_status(),
        'listing_link' => myListingsLink(),
    ]);

    return ajaxSuccessResponse(['type' => 'html', 'html' => $html]);

} catch (PDOException $e) {
    return ajaxErrorResponse($e->getMessage());
} catch (Exception $e) {
    return ajaxErrorResponse($e->getMessage());
}
