<?php
use App\Token;
use App\Validate;

if( ! isAjax() || ! isPost()) {
    return false;
}
if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if( ! token()->checkForAjax() ) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if( $loggedUser->hasVerifiedMobile() ) {
    return ajaxErrorResponse(_e('INVALID_OPERATION', true));
}

$validation = new Validate();

$rules = [
    'submit_param' => [
        'name' => _e('MOBILE_PHONE_NUMBER', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'mobile' => true,
        'unique' => 'tbl_users',
        'unique_column' => 'VERIFIED_MOBILE'
    ]
];

$validation = (new Validate())->check($_POST, $rules);
if( ! $validation->passed() ) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

if( $loggedUser->canSendAuthTokenMessage('activation') ) {
    $loggedUser->sendActivationCodeSmsForAccountSubmitMobile(input('submit_param'));
}

return ajaxSuccessResponse([
    'resend_time' => $loggedUser->resendAuthTokenTime(),
    'method'      => 'mobile'
]);
