<?php
use App\Validate;

if( ! isAjax() || ! isPost()) {
    return false;
}
if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if( ! token()->checkForAjax() ) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if( $loggedUser->hasVerifiedEmail() ) {
    return ajaxErrorResponse(_e('INVALID_OPERATION', true));
}

$rules = [
    'submit_param' => [
        'name' => _e('EMAIL', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'email' => true,
        'unique' => 'tbl_users',
        'unique_column' => 'VERIFIED_EMAIL'
    ]
];

$validation = (new Validate())->check($_POST, $rules);
if( ! $validation->passed() ) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

if( $loggedUser->canSendAuthTokenMessage('activation') ) {
    $activation_code = $loggedUser->createAuthToken('activation', input('submit_param'));
    $loggedUser->sendActivationCodeForAccountSubmitEmail($activation_code, input('submit_param'));
}

return ajaxSuccessResponse([
    'resend_time' => $loggedUser->resendAuthTokenTime(),
    'method'      => 'email'
]);
