<?php
use App\Exception\GateWayException;
use App\GateWay;
use App\Validate;

if( ! isAjax() ) {
    return false;
}
if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if( ! token()->checkForAjax() ) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if( ! $loggedUser ) {
    return ajaxErrorResponse(_e('SUBMIT__LOGIN_VALIDATION_ERROR', true));
}
if( ! $ads || ! $period || ! periodExists($period) || ! $loggedUser->owns($ads) ) {
    return ajaxErrorResponse(_e('SUBMIT__WRONG_ADS_ERROR', true));
}

$validate = new Validate();
$validation = $validate->check($_POST,array(
    'payment_method' => array(
        'name'     => _e('PAYMENT_TYPE', true),
        'prefix'   => _e('SELECTION', true),
        'required' => true
    )
));

if( ! $validation->passed() ) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$coupon      = null;
$coupon_code = null;
$discount    = 0;

$orderId = time() + rand(1,5000);
$comment = _e('EXTENSION_PAYMENT_NOTE', true, ["{%1%}" => $ads->ADS_ID,"{%2%}" => $period,"{%3%}" => $current_plan->PLAN_TITLE]);
if($ads->is_expired()) {
    $comment = _e('EXTENSION_EXPIRED_PAYMENT_NOTE', true, ["{%1%}" => $ads->ADS_ID,"{%2%}" => $period,"{%3%}" => $current_plan->PLAN_TITLE]);
}
$payment_nature = 'extend';
$new_plan_id = 0;
if($ads->is_expired()) {
    $payment_nature = 'extend-expired';
    $new_plan_id = $current_plan->ID;
}

$payment_info = [
    'ads_id'      => $ads->ADS_ID,
    'ads_title'   => $ads->ADS_TITLE,
    'total'       => $price,
    'subtotal'    => $price,
    'discount'    => $discount,
    'coupon_code' => $coupon_code,
    'payment_action' => $comment
];

$method = input('payment_method');
$gateway_namespace = "App\\{$method}";

try {
    $GateWay = new GateWay($gateway_namespace, $method, inputs());
    $result = $GateWay->sendToGateway($payment_info, $orderId, $new_plan_id, $payment_nature, $period);

    return ajaxSuccessResponse($result);
}catch (GateWayException $e) {
    return ajaxErrorResponse($e->errors());
}