<?php
use App\Ads;
use App\Coupon;
use App\Exception\GateWayException;
use App\GateWay;
use App\Validate;

if (! isAjax()) {
    return false;
}
if (! isCountryAllowed()) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if (! $loggedUser) {
    return ajaxErrorResponse(_e('SUBMIT__LOGIN_VALIDATION_ERROR', true));
}

if (! $ads || !$new_plan || ! $loggedUser->owns($ads) || $new_plan->isFree() || $new_plan->ID == $ads->PLAN_ID) {
    return ajaxErrorResponse(_e('SUBMIT__WRONG_ADS_ERROR', true));
}

$validate = new Validate();
$validation = $validate->check($_POST, array(
    'payment_method' => array(
        'name' => _e('PAYMENT_TYPE', true),
        'prefix' => _e('SELECTION', true),
        'required' => true
    )
));

if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$Ads = new Ads();
$Coupon = new Coupon();

$coupon = null;
$discount = 0;
$coupon_code = null;
$period = 0;

if (!empty(input('coupon_id'))) {
    $coupon = $Coupon->byCode(input('coupon_id'));
}

if ($coupon) {
    $discount = $coupon->discountFor($new_plan->finalPrice($period));
    $coupon_code = $coupon->code;
}

$orderId = time() + rand(1, 5000);
$comment = _e('CHANGE_PLAN_TYPE_PAYMENT_NOTE', true, ["{%1%}" => $ads->ADS_ID, "{%2%}" => $ads->PLAN_TITLE, "{%3%}" => $new_plan->PLAN_TITLE]);
$price = $new_plan->finalPrice($period, false, $coupon);
$payment_nature = 'change-plan';

$payment_info = [
    'ads_id' => $ads->ADS_ID,
    'ads_title' => $ads->ADS_TITLE,
    'total' => $price,
    'subtotal' => $new_plan->finalPrice($period),
    'discount' => $discount,
    'coupon_code' => $coupon_code,
    'payment_action' => $comment
];

$method = input('payment_method');
$gateway_namespace = "App\\{$method}";

try {
    $GateWay = new GateWay($gateway_namespace, $method, inputs());
    $result = $GateWay->sendToGateway($payment_info, $orderId, $new_plan->ID, $payment_nature, $period);

    return ajaxSuccessResponse($result);
}catch (GateWayException $e) {
    return ajaxErrorResponse($e->errors());
}