<?php
if( ! isAjax() ) {
    return false;
}
if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if( ! $loggedUser || ! token()->check()) {
    return ajaxErrorResponse(_e('SUBMIT__LOGIN_VALIDATION_ERROR', true));
}

$auth_token = $loggedUser->verifyActivationCode(input('activation_code'));
if( ! $auth_token )  {
    return ajaxErrorResponse(_e('WRONG_CODE', true));
}

$submitted_param = $auth_token->data;
if( ! is_email($submitted_param) && ! is_mobile($submitted_param) ) {
    return ajaxErrorResponse(_e('INVALID_OPERATION', true));
}

$message = _e('EMAIL_SUBMITTED', true, ['{%1%}' => $submitted_param]);
if( is_mobile($submitted_param) ) {
    $message = _e('MOBILE_SUBMITTED', true, ['{%1%}' => $submitted_param]);
}

return ajaxSuccessResponse(['html' => $message]);