<?php
use App\Ads;
use App\CustomFields;
use App\Image;
use App\Special;
use App\Tag;
use App\Validate;

if (! isAjax()) {
    return false;
}
if (! isCountryAllowed()) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if (! token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if (needsRegisterBeforeSubmit() && !$loggedUser) {
    return ajaxErrorResponse(_e('SUBMIT__LOGIN_VALIDATION_ERROR', true));
}

$already_logged_in = false;

/** @var App\User $loggedUser */
if ($loggedUser) {
    $already_logged_in = true;
}

$Ads = new Ads();
$CustomFields = new CustomFields();
$validation = new Validate();

$rules = [
    'frm_title' => [
        'name' => _e('ADS_TITLE', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 10,
        'max' => 200
    ],
    'category' => [
        'name' => _e('ADS_CATEGORY', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'numeric' => true,
        'not_any' => true
    ],
    'subcategory' => [
        'name' => _e('ADS_CATEGORY', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'numeric' => true,
        'not_any' => true
    ],
    'frm_plan_type' => [
        'name' => _e('ADS_PLAN', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'numeric' => true
    ],
    'frm_description' => [
        'name' => _e('ADS_DESCRIPTION', true),
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'min' => 20,
    ],
    'frm_discount' => [
        'name' => _e('DISCOUNT', true),
        'percent' => true
    ],
    'state' => [
        'name' => _e('STATE', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'not_any' => true,
        'numeric' => true
    ],
    'city' => [
        'name' => _e('CITY', true),
        'prefix' => _e('SELECTION', true),
        'required' => true,
        'not_any' => true,
        'numeric' => true
    ],
    'accept_terms' => [
        'name' => _e('SITE_RULES', true),
        'prefix' => _e('ACCEPTING', true),
        'required' => true
    ],
    'frm_email' => [
        'name' => _e('ADS_EMAIL', true),
        'email' => true
    ]
];

if (! needsRegisterBeforeSubmit() && !$already_logged_in) {
    $rules['register_param'] = [
        'name' => 'شماره موبایل یا آدرس ایمیل ',
        'prefix' => _e('ENTERING', true),
        'required' => true,
    ];
    if (isActivateWithOnlyEmail()) {
        $rules['register_param']['email'] = true;
    } elseif (isActivateWithOnlySms()) {
        $rules['register_param']['mobile'] = true;
    } else {
        $rules['register_param']['username'] = true;
    }
}

$catId = input('category');
$subcatId = input('subcategory');
$subsidiaryId = input('subsidiary');
$has_subsidiary = $Ads->hasSubsidiary($subcatId);

if ($has_subsidiary && (! $subsidiaryId || empty($subsidiaryId) || $subsidiaryId == 'any')) {
    $validation->addError(_e('SUBMIT__SUBSIDIARY_VALIDATION_ERROR', true));
}

if ($has_subsidiary) {
    $custom_fields = $CustomFields->getFieldsForSubsidiary($catId, $subsidiaryId, $subcatId);
} else {
    $custom_fields = $CustomFields->getFieldsForSubcategory($catId, $subcatId);
}

/** @var App\CustomFields $field */
foreach ($custom_fields as $field) {
    if ($field->field_type == 'price') {
        $rules = $field->set_price_field_rule($rules);
    } else {
        $rules[$field->field_name] = $field->rules();
    }
}

$slug_name = slug(input('frm_title'));
$slug_name = $Ads->slug($slug_name);

if (empty($slug_name) || trim($slug_name) == '') {
    $validation->addError(_e('ADS_TITLE_ERROR', true));
}
if (strlen($slug_name) > 250) {
    $validation->addError(_e('ADS_TITLE_LENGTH_ERROR', true));
}

$validation = $validation->check($_POST, $rules);

if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}


if (! needsRegisterBeforeSubmit() && ! $already_logged_in) {

    $register_param = en_digits(input('register_param'));

    if (is_mobile($register_param)) {
        $register_method = 'mobile';
    }

    if (is_email($register_param)) {
        $register_method = 'email';
    }

    $found_user = $User->findByEmailOrMobile($register_param);

    if ($found_user && ! $found_user->verifyPassword(input('login_password'))) {
        return ajaxErrorResponse(_e('WRONG_PASSWORD', true));
    }

    if ($found_user && $found_user->verifyPassword(input('login_password'))) {
        $current_user = $found_user;
    }

    if (! $found_user) {
        $username = $email = $mobile = $register_param;

        if (is_email($username)) {
            $mobile = null;
        }
        if (is_mobile($username)) {
            $email = null;
        }

        $password = generate_password(8, 'small_letters+numbers');

        $user_id = $User->quickCreate($username, $email, $mobile, $password, true);

        $current_user = $User->findById($user_id);

        $is_user_created = true;
    }

    /** @var App\User $current_user */
    if (! registerNeedsActivation() && $current_user->isPendingActivation()) {
        return ajaxErrorResponse([_e('USER_ACCOUNT_SHOULD_ACTIVATE_BY_ADMIN', true)]);
    }

    $current_user->login();
    $loggedUser = $current_user;

    if (registerNeedsActivation() && $current_user->isPendingActivation()) {
        if ($is_user_created) {
            if ($register_method === 'email' && canActivateWithEmail()) {
                $activation_code = $loggedUser->createAuthToken('activation', $register_param);
                $loggedUser->sendActivationCodeWithAccountInfoEmail($activation_code, $password);
            }
            if ($register_method === 'mobile' && canActivateWithSMS()) {
                $loggedUser->sendActivationCodeWithAccountInfoSMS($password, $register_param);
            }
        } else {
            if ($register_method === 'email' && canActivateWithEmail()) {
                $activation_code = $loggedUser->createAuthToken('activation', $register_param);
                $loggedUser->sendActivationCodeEmail($activation_code);
            }
            if ($register_method === 'mobile' && canActivateWithSMS()) {
                $loggedUser->sendActivationCodeSMS();
            }
        }

        ob_start();
        include(INC_PATH . 'theme/components/_account_menu.php');
        $menu_html = ob_get_contents();
        ob_end_clean();

        return ajaxErrorResponse(['needs_activation' => true, 'resend_time' => $loggedUser->resendAuthTokenTime(), 'menu_html' => $menu_html, 'method' => $register_method]);
    }

    if (!registerNeedsActivation() && $is_user_created) {
        if ($register_method === 'email' && setting('SEND_EMAIL_AFTER_REGISTER') === 'YES') {
            $loggedUser->sendWelcomeEmail($password);
        }
        if ($register_method === 'mobile' && setting('SEND_SMS_AFTER_REGISTER') === "YES") {
            $loggedUser->sendWelcomeWithPasswordSms($password);
        }
    }
}

$categoryId = $subcatId;
if ($has_subsidiary) {
    $categoryId = $subsidiaryId;
}

$expiration_days = setting('EXPIRE_DAYS');

$plan = $Ads->plan_by_id(input('frm_plan_type'));
if ($plan->is_free()) {
    $expiration_days = $plan->PLAN_DAYS;
}

/**
 * Check for free ads left
 */
if ($plan->is_free() && ! $loggedUser->has_free_ads_left()) {
    return ajaxErrorResponse(_e('FREE_ADS_LIMIT_REACHED', true));
}

$discount = $price = $link = null;
if (inputs()->not_empty('frm_discount')) {
    $discount = (int)input('frm_discount');
}
if (! $custom_fields) {
    if (inputs()->not_empty('frm_price_deal')) {
        $price = 'DEAL';
    } elseif (inputs()->not_empty('frm_price')) {
        $price = money_to_num(en_digits(input('frm_price')));
    }
}

if ($plan->has_link()) {
    $link = input('frm_link');
}

$owner_email = $owner_phone = null;
if (!canActivateWithEmail()) {
    $owner_email = input('frm_email');
}
if (!canActivateWithSms()) {
    $owner_phone = input('frm_tel');
}
if (canActivateWithEmail()) {
    $owner_email = $loggedUser->officialEmail();
}
if (canActivateWithSms()) {
    $owner_phone = $loggedUser->officialMobile();
}

try {
    /**
     * Start Transaction
     */
    $db->beginTransaction();

    /**
     * Create New Ads
     */
    $adsId = $Ads->createNew(inputs()->all(), $slug_name, $owner_email, $owner_phone, $categoryId, $link, $price, $discount);



    /**
     * Create Special Record
     */
    $Special = new Special();
    $Special->createNew($adsId, input('frm_plan_type'), $expiration_days);

    /**
     * Save Custom Fields
     */
    foreach ($custom_fields as $field) {
        $field->save($adsId);
    }

    /**
     * Inserting Tags
     */
    $Tag = new Tag();
    $Tag->handle(input('frm_keywords'), $adsId, 'ads', $plan->MAX_KEYWORD_COUNT);

    /**
     * Increment counts of free ads for current user
     */
    if ($plan->is_free()) {
        $loggedUser->incrementFreeAdsCount();
    }

    /**
     * End Transaction
     */
    $db->commit();


    /* move uploaded images to it's real destination */
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));

    $ImageDb = new Image();
    $db_images = [];

    $i = 1;
    foreach ($uploaded_images as $image) {
        if (empty($image->name) || $i > $plan->MAX_IMG_COUNT) {
            continue;
        }

        $source_root = 'images/estate_images/app_temp/';
        $destination_root = "images/estate_images/{$adsId}/";

        $source_main = "{$source_root}{$image->name}.jpg";
        $destination_main = "{$destination_root}{$image->name}.jpg";

        if (! is_file($source_main) ) {
            continue;
        }

        if (! is_dir($destination_root)) {
            mkdir($destination_root);
        }

        rename($source_main, $destination_main);

        $db_images[] = $ImageDb->createNew($adsId, $destination_main);

        foreach ($image_sizes as $size_name => ['size' => $size]) {
            $sized_source =  "{$source_root}{$image->name}-{$size_name}.jpg";
            $sized_destination =  "{$destination_root}{$image->name}-{$size_name}.jpg";

            if (! is_file($sized_source)) {
                continue;
            }

            rename($sized_source, $sized_destination);
        }

        $key = array_search($image->name, $all_uploaded_images);
        if ($key == 0 || $key != false) {
            unset($all_uploaded_images[$key]);
        }

        $i++;
    }

    /* delete redundant uploaded images */
    foreach ($all_uploaded_images as $image) {
        if (empty($image)) {
            continue;
        }

        $source_root = 'images/estate_images/app_temp/';

        $source_main = "{$source_root}{$image->name}.jpg";

        if (is_file($source_main)) {
            unlink($source_main);
        }

        foreach ($image_sizes as $size_name => ['size' => $size]) {
            $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";

            if (is_file($sized_source)) {
                unlink($sized_source);
            }
        }
    }

    /**
    * Fetch newly created ads
    */
    $ads = $Ads->ads_by_id($adsId, false);

    $ads->setFeaturedImage($db_images[0]);

    $html = null;
    if ($plan->is_free()) {
        $needs_to_pay = false;
        $html = includeFile('languages/includes/page_contents/add_ads/_submit__free_success.php', [
            'promote_link' => $ads->promoteLink(),
            'view_link' => $ads->viewLink()
        ]);

        $ads->send_success_free_email($loggedUser->officialEmail());
    }
    if (! $plan->is_free()) {
        $needs_to_pay = true;
        $period = 0;
        $payment_price = $ads->finalPrice($period);

        $html = includeFile('languages/includes/page_contents/add_ads/_submit__special_success.php', [
            'edit_link' => $ads->editLink(),
            'title' => $ads->ADS_TITLE,
            'category' => $ads->categoryTree(),
            'plan' => $ads->PLAN_TITLE,
            'pure_price' => $payment_price,
            'formatted_price' => price_format($payment_price)
        ]);
    }

    $menu_html = null;
    if (!needsRegisterBeforeSubmit() && !$already_logged_in) {
        ob_start();
        include(INC_PATH.'theme/components/_account_menu.php');
        $menu_html = ob_get_contents();
        ob_end_clean();
    }

    return ajaxSuccessResponse([
        'message' => _e('ADS_SUBMITTED_SUCCESSFULLY', true),
        'needs_to_pay' => $needs_to_pay,
        'ads_id' => $ads->ADS_ID,
        'html' => $html,
        'menu_html' => $menu_html
    ]);
} catch (PDOException $e) {
    return ajaxErrorResponse($e->getMessage());
}
