<?php
use App\Ads;
use App\Coupon;
use App\GateWay;
use App\Validate;
use App\Exception\GateWayException;

if (!isAjax()) {
    return false;
}
if (!isCountryAllowed()) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if (!token()->checkForAjax()) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}
if (!$loggedUser) {
    return ajaxErrorResponse(_e('SUBMIT__LOGIN_VALIDATION_ERROR', true));
}
$validate = new Validate();
$validation = $validate->check($_POST,array(
    'payment_method' => array(
        'name'     => _e('PAYMENT_TYPE', true),
        'prefix'   => _e('SELECTION', true),
        'required' => true
    )
));

if (!inputs()->not_empty('ads_id') || !is_numeric(input('ads_id'))) {
    $validation->addError(_e('SUBMIT__WRONG_ADS_ERROR', true));
}

if (! $validation->passed()) {
    return ajaxErrorResponse(implode('<br>', $validation->errors()));
}

$Ads = new Ads();
$Coupon = new Coupon();

$ads = $Ads->ads_by_id(input('ads_id'), false);

if (! $ads || ! $loggedUser->owns($ads) || $ads->ads_general_status(true) != 3) {
    return ajaxErrorResponse(_e('SUBMIT__WRONG_ADS_ERROR', true));
}

$coupon = null;
$coupon_code = null;
$discount = 0;
$period = 0;

if (! empty(input('coupon_id'))) {
    $coupon = $Coupon->byCode(input('coupon_id'));
}
if ($coupon) {
    $discount = $coupon->discountFor($ads->finalPrice($period));
    $coupon_code = $coupon->code;
}

$orderId = time() + rand(1, 5000);
$comment = "ثبت آگهی با پلان ویژه {$ads->PLAN_TITLE}";
$price = $ads->finalPrice($period, false, $coupon);
$payment_nature = 'add-new';

$payment_info = [
    'ads_id' => $ads->ADS_ID,
    'ads_title' => $ads->ADS_TITLE,
    'total' => $price,
    'subtotal' => $ads->finalPrice($period),
    'discount' => $discount,
    'coupon_code' => $coupon_code,
    'payment_action' => $comment
];

$method = input('payment_method');
$gateway_namespace = "App\\{$method}";

try {
    $GateWay = new GateWay($gateway_namespace, $method, inputs());
    $result = $GateWay->sendToGateway($payment_info, $orderId, 0, $payment_nature, $period);

    return ajaxSuccessResponse($result);
}catch (GateWayException $e) {
    return ajaxErrorResponse($e->errors());
}