<?php
include 'init.php';

$page_types = [
    'page-404',
    'page-403',
    'page-demo-restrict',
    'page-restrict',
    'all-categories',
    'callback',
    'pricing',
    'profile-view',
    'rss-list',
    'rss-content'
];

if (in_array(input('page_type'), $page_types)) {
    $page_slug = input('page_type');
}

if (input('page_type') === 'dynamic-page') {
    $page_slug = trim(input('page_slug'));
}

include 'includes/core/check_auth.php';

/** @var App\Page $current_page */
if (! $current_page) {
    abort();
}

if (! in_array(input('page_type'), $page_types) && ! $current_page->isDynamic()) {
    abort();
}

if ($current_page->getOptions()->controller) {
    include "{$current_page->getOptions()->controller}";
} else {
    include "includes/core/pages/pages/dynamic_controller.php";
}

if ($current_page->isProcessPage()) {
    exit();
}

if (isset($ajax_response)) {
    return $ajax_response;
}
?>

<?php include 'includes/core/head.php' ?>

<?php include 'includes/theme/header.php' ?>

<?php
if ($current_page->getOptions()->content) {
    include "{$current_page->getOptions()->content}";
} else {
    include "includes/theme/pages/pages/dynamic.php";
}
?>

<?php include 'includes/theme/footer.php' ?>