<?php
session_start();
ob_start();

require_once(__DIR__ . '/vendor/autoload.php');

ini_set("display_errors", 0);
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

require_once('funcs/config.ini.php');
include('bootstrap/database.php');
$pageType = 'maintenance';

$sql = "SELECT SETTING, VALUE FROM tbl_settings";
$stmt = $db->prepare($sql);
$stmt->execute();
$options = (object) $stmt->fetchAll(PDO::FETCH_KEY_PAIR);


include 'languages/' . $options->SITE_LANGUAGE_SIGN . '.php';

$now = time();
$reopen = DateTime::createFromFormat('Y-m-d H:i:s', $options->REOPEN_DATE);
$reopen_timestamp = $reopen->format('U');

if($options->MAINTENANCE_MODE === "OFF" || $now > $reopen_timestamp  || $_SESSION['SESS_USER_LEVEL']=="admin"){
    header("location:".siteroot());
    exit();
}
?>
<!DOCTYPE html>
<html lang="<?php echo $options->SITE_LANGUAGE_SIGN ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex">
    <title> <?php _e('MAINTENANCE_MODE') ?>|<?= $options->SEO_TITLE ?> </title>
    <meta name="keywords" content="<?= $options->SEO_KEYWORDS ?>" >
    <meta name="description" content="<?= $options->SEO_DESCRIPTION ?>" >
    <meta name="author" content="<?= $options->SITE_AUTHOR ?>">
    <base href="<?= siteroot() ?>" />

    <link type="text/css" rel="stylesheet" href="public/theme/css/plugins.css">
    <link href="public/maintenance/css/animate.css" rel="stylesheet" media="screen">
    <link href="public/maintenance/css/maintenance.css" rel="stylesheet" media="screen">

    <style>
        .list-inline, .list-unstyled {
            padding-left: 0;
            list-style: none;
        }
        .list-inline>li {
            display: inline-block;
            padding: 0;
        }
    </style>
</head>
<body>

<div id="preloader">
    <div id="status">
        <div class="status-area"></div>
    </div>
</div>

<div class="layout">
    <div class="container">
        <div class="main">
            <div class="overlay">

                <div class="logo"></div>

                <h1 class="title"><?php echo setting('SITE_TITLE') ?></h1>

                <div class="slogan">
                    <?php echo $options->MAINTENANCE_TEXT ?>
                </div>

                <div class="countdown-time animated fadeInUp" data-date="<?php echo $options->REOPEN_DATE ?>" data-timer="900"></div>

                <div class="social">
                    <ul class="list-inline">
                        <?php
                        if(!empty($options->FACEBOOK_URL) && trim($options->FACEBOOK_URL) != '')
                            $socials .= "<li><a href='" . $options->FACEBOOK_URL . "' data-toggle='tooltip' data-placement='top' title='Facebook'><i class='fab fa-facebook'></i></a></li>";
                        if(!empty($options->TWITTER_URL) && trim($options->TWITTER_URL) != '')
                            $socials .= "<li><a href='" . $options->TWITTER_URL . "' data-toggle='tooltip' data-placement='top' title='Twitter'><i class='fab fa-twitter'></i></a></li>";
                        if(!empty($options->GOOGLEPLUS_URL) && trim($options->GOOGLEPLUS_URL) != '')
                            $socials .= "<li><a href='" . $options->GOOGLEPLUS_URL . "' data-toggle='tooltip' data-placement='top' title='googleplus'><i class='fab fa-google-plus'></i></a></li>";
                        if(!empty($options->LINKEDIN_URL) && trim($options->LINKEDIN_URL) != '')
                            $socials .= "<li><a href='" . $options->LINKEDIN_URL . "' data-toggle='tooltip' data-placement='top' title='linkedin'><i class='fab fa-linkedin'></i></a></li>";
                        if(!empty($options->GITHUB_URL) && trim($options->GITHUB_URL) != '')
                            $socials .= "<li><a href='" . $options->GITHUB_URL . "' data-toggle='tooltip' data-placement='top' title='instagram'><i class='fab fa-instagram'></i></a></li>";
                        if(!empty($options->PINTEREST_URL) && trim($options->PINTEREST_URL) != '')
                            $socials .= "<li><a href='" . $options->PINTEREST_URL . "' data-toggle='tooltip' data-placement='top' title='pinterest'><i class='fab fa-pinterest'></i></a></li>";
                        if(!empty($options->TELEGRAM_URL) && trim($options->TELEGRAM_URL) != '')
                            $socials .= "<li><a href='" . $options->TELEGRAM_URL . "' data-toggle='tooltip' data-placement='top' title='telegram'><i class='fa fa-paper-plane'></i></a></li>";

                        echo $socials;

                        ?>

                    </ul>
                </div>
                <div class="copyright text-center">
                    <?php echo $options->MAINTENANCE_COPYRIGHT ?>
                </div>

            </div>
        </div>
    </div>

</div>

<script type="text/javascript" src="public/maintenance/js/jquery-1.11.0.min.js"></script>
<script type="text/javascript" src="public/maintenance/js/bootstrap.min.js"></script>
<script type="text/javascript" src="public/maintenance/js/countdown.js"></script>
<script type="text/javascript" src="public/maintenance/js/jquery.vegas.min.js"></script>
<script type="text/javascript" src="public/maintenance/js/scripts.js"></script>


<script>
    var LANG__DAY = "<?php echo $language['DAY'] ?>";
    var LANG__HOUR = "<?php echo $language['HOUR'] ?>";
    var LANG__MIN = "<?php echo $language['MINUTE'] ?>";
    var LANG__SEC = "<?php echo $language['SECOND'] ?>";
    $(function(){
        $(".time_circles .textDiv_Days h4").html(LANG__DAY);
        $(".time_circles .textDiv_Hours h4").html(LANG__HOUR);
        $(".time_circles .textDiv_Minutes h4").html(LANG__MIN);
        $(".time_circles .textDiv_Seconds h4").html(LANG__SEC);
    })
</script>

</body>

</html>