<?php

use Carbon\Carbon;
use Illuminate\Container\Container;

session_start();
ob_start();

require_once(__DIR__ . '/vendor/autoload.php');
date_default_timezone_set("Asia/Tehran");

defined('DS')             ? null : define('DS',             DIRECTORY_SEPARATOR);
defined('SITE_ROOT')       ? null : define('SITE_ROOT',      dirname(__FILE__) . DS);
defined('LIB_PATH')        ? null : define('LIB_PATH',       SITE_ROOT . 'funcs' . DS);
defined('INC_PATH')        ? null : define('INC_PATH',       SITE_ROOT . 'includes' . DS);
defined('LANG_PATH')        ? null : define('LANG_PATH',      SITE_ROOT . 'languages' . DS);
defined('IMAGES_PATH')    ? null : define('IMAGES_PATH',    SITE_ROOT . 'images' . DS);
defined('VENDOR_PATH')    ? null : define('VENDOR_PATH',    SITE_ROOT . 'vendor' . DS);
defined('TEMPLATES_PATH') ? null : define('TEMPLATES_PATH', SITE_ROOT . 'templates' . DS);
defined('CACHE_PATH')     ? null : define('CACHE_PATH',     SITE_ROOT . 'cache');


$iniFile = LIB_PATH . 'config.ini.php';
if (!file_exists($iniFile)) {
    redirect("setup/");
}
include($iniFile);
include(SITE_ROOT . 'bootstrap/database.php');
include(SITE_ROOT . 'bootstrap/config.php');

Carbon::setLocale('fa');

/*---------------------------
| Instantiate the Container
----------------------------*/
$app = new Container();

/*-------------------------
| Instantiate Input Class
---------------------------*/
$app->singleton('input', function () {
    return new App\Input();
});

/*----------------------------------------
| Instantiate the cache manager
------------------------------------------*/
$app->singleton('cache', function () {
    return new App\Cache();
});

/*----------------------------------------
| Instantiate the Session Class
------------------------------------------*/
$app->singleton('session', function () {
    return new App\Session();
});

/*----------------------------------------
| Instantiate the Cookie Class
------------------------------------------*/
$app->singleton('cookie', function () {
    return new App\Cookie();
});

/*-------------------------
| Instantiate Token Class
---------------------------*/
$app->singleton('token', function () {
    return new App\Token();
});

/*-------------------------
| Instantiate Input Class
---------------------------*/
$app->singleton('ads', function () {
    return new App\Ads();
});

/*----------------------------------------
| Fetch Site Settings
------------------------------------------*/
$Setting = new App\Setting();
$options = $Setting->all();

include(LANG_PATH . lang() . '.php');
include(SITE_ROOT . 'shared/data.php');
include(SITE_ROOT . 'shared/routes.php');
include(INC_PATH . 'theme/functions.php');

// error_reporting(E_ALL);
// ini_set('display_errors', '1');
ini_set("display_errors", 0);
