<div class="remodal extension-modal" data-remodal-id="report-modal">

    <div class="remodal-header">
        <button data-remodal-action="close" class="remodal-close"></button>

        <h5 class="remodal-title"><i class="fal fa-flag"></i> <?php _e('POLICY_TITLE') ?></h5>
    </div>

    <div class="form-message-placeholder colorful"></div>

    <div class="auth-form-wrapper remodal-body">

        <form action="<?= $ads->viewLink() ?>" method="POST" id="report-form" class="darker-form">

            <?= csrf_field() ?>
            <input type="hidden" name="action" value="send-report">

            <div class="modal-body report-modal">

                <h4> مشکل یا تخلف در کدام قسمت آگهی است؟ </h4>
                <p>نزدیک ترین گزینه را انتخاب کنید. کارشناسان ما گزارش شما را بررسی می کنند.</p>

                <div class="form-group form-group-checkbox">
                    <ul class="radio-group report-reasons">
                        <?php foreach ($report_reasons as $key => $title) : ?>
                            <li>
                                <label class="pretty-radio">
                                    <?= $title ?>
                                    <input type="radio" name="report_reason" value="<?= $key ?>">
                                    <span class="checkmark"></span>
                                </label>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <p class="help-block" id="report-help" style="clear: both"></p>
                </div>

                <?php if (isImageCaptcha()) : ?>
                    <div class="image-captcha">
                        <img src="<?= captcha()->show('report') ?>" id="report_captcha" alt="report captcha"
                             style="margin-bottom: 15px">
                        <div class="captcha-update-handler">
                            <i class="fa fa-repeat" data-click-updates-captcha data-namespace="report"
                               data-target="#report_captcha"></i>
                        </div>
                    </div>
                    <div class="col-xs-12 form-div">
                        <div class="form-group form-group--float form-group--icon form-group-static">
                            <input type="text" name="captcha" id="report_captcha_input" autocomplete="off" class="form-control captcha-field">
                            <span class="input-icon-addon top-3"> <i class="fa fa-codiepie"></i> </span>
                            <label for="report_captcha_input"><?php _e('CAPTCHA_CODE') ?></label>
                            <p class="help-block"></p>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (isRecaptcha()) : ?>
                    <div class="g-recaptcha" id="report-recaptcha"></div>
                <?php endif; ?>

                <div class="text-center">
                    <button type="submit" class="btn color2-bg no-shadow" data-default-text="<?php _e('SEND') ?>"> <?php _e('SEND') ?> <i class="fas fa-caret-left"></i></button>
                </div>
            </div>
        </form>

    </div>
</div>