<div class="list-single-main-item fl-wrap block_box">
    <div class="list-single-main-item-title no-border no-caret mb-0 level">
        <div>
            <h1><?= safe($ads->ADS_TITLE) ?></h1>
            <div class='listing-rating gray-stars'><?= $ads->starRate() ?></div>
        </div>
        <?php if ($current_page->setting('enable-voting') === 'YES') : ?>
            <div class="like-actions">
                <a href="javascript:" class="like <?= $ads->hasBeenVotedByCurrentVisitor() ? 'disabled' : '' ?>" data-action="like" title="Like"><i class="fal fa-thumbs-up"></i> <span class="count"><?= $ads->likes() ?></span></a>
                <a href="javascript:" class="dislike <?= $ads->hasBeenVotedByCurrentVisitor() ? 'disabled' : '' ?>" data-action="dislike" title="Dislike"><i class="fal fa-thumbs-down"></i><span class="count"><?= $ads->dislikes() ?></span></a>
            </div>
        <?php endif; ?>
    </div>
    <div class="row single--custom-fields list-single-main-item_content fl-wrap">
        <?php
        if ($custom_fields) {
            foreach ($custom_fields as $field) {
                if (empty(trim($field->info_value))) {
                    continue;
                }

                if ($field->type === 'link') {
                    echo "<div class='col-xs-12 single--custom-field-item'>";
                    echo "<span>{$field->title}:</span><a href='" . addHttp($field->show_value()) . "'> " . $field->show_value() . " </a>";
                    echo "</div>";
                    continue;
                }

                echo "<div class='col-sm-6 col-xs-12 single--custom-field-item'>";
                echo "<span>{$field->title}:</span> {$field->show_value()} ";

                echo "</div>";
            }
        }
        ?>

        <?php if ($ads->has_link() && not_empty($ads->ADS_LINK)) : ?>
            <div class='col-sm-6 col-xs-12 single--custom-field-item'>
                <span><?php _e('LINK') ?>: </span>
                <a href="<?= safe(addHttp($ads->ADS_LINK)) ?>" target='_blank' rel='nofollow'>
                    <i class="fa fa-external-link"></i>
                    <?= safe($ads->ADS_LINK) ?>
                </a>
            </div>
        <?php endif; ?>

        <?php if (!$custom_fields && not_empty($ads->ADS_PRICE)) : ?>
            <div class='col-sm-6 col-xs-12 single--custom-field-item'>
                <span><?php _e('PRICE') ?>: </span>
                <?= ($ads->ADS_PRICE === 'DEAL') ? _e('DEAL', true) : safe(showPrice($ads->ADS_PRICE, true, true, true)) ?>
            </div>
        <?php endif; ?>

        <?php if (not_empty($ads->ADS_DISCOUNT)) : ?>
            <div class='col-sm-6 col-xs-12 single--custom-field-item'>
                <span><?php _e('DISCOUNT') ?>:</span>
                <?= safe($ads->ADS_DISCOUNT) ?> درصد
            </div>
        <?php endif; ?>
    </div>

    <div class="list-single-main-item_content fl-wrap">
        <?= safe_text($ads->ADS_DESCRIPTION) ?>
    </div>


    <span class="fw-separator"></span>
    <div class="row">

        <div class="col-md-12 col-sm-12 col-xs-12">
            <?php if (! empty($tags) & count($tags) > 0) : ?>
                <div class="list-single-tags tags-stylwrap">
                    <span class="tags-title"><i class="fas fa-tag"></i> <?php _e('TAGS') ?> </span>
                    <?php
                    /** @var App\Tag $tag */
                    foreach ($tags as $tag) {
                        echo "<a href='{$tag->viewLink()}' target='_blank'>{$tag->TAG_NAME}</a>";
                    }
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12 item-details-page">
            <div class="details-actions">


            </div>
        </div>

    </div>
</div>