<div class="box-widget-item fl-wrap block_box">
    <div class="box-widget-item-header">
        <h3>اطلاعات تماس</h3>
    </div>

    <?php if (! $should_show_partial) : ?>
        <?php if ($user->ID) : ?>
            <div class="box-widget">
                <div class="box-widget-author fl-wrap">
                    <div class="box-widget-author-title">
                        <div class="box-widget-author-title-img">
                            <img src="<?= $user->avatar() ?>" alt="">
                        </div>
                        <div class="box-widget-author-title_content">
                            <a href="<?= $user->profileLink() ?>"><?= $user->publicName(false) ?></a>
                            <span><?= _e('MEMBER_SINCE', false, ['{%1%}' => elapsedTime($user->USER_DATE_CREATED)]) ?></span>
                        </div>
                        <div class="box-widget-author-title_opt">
                            <a href="<?= $user->profileLink() ?>" class="tolt green-bg medium" data-microtip-position="top" data-tooltip="<?php _e('VIEW_PROFILE') ?>"><i class="fas fa-user"></i></a>
                            <?php if($owner_email) : ?>
                                <a href="javascript:" data-remodal-target="contact-modal" class="tolt color-bg medium" data-microtip-position="top" data-tooltip="<?= _e('SEND_EMAIL_TO', false, ['{%1%}' => $user->publicName(false)]) ?>"><i class="fas fa-comments-alt"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="box-widget-content bwc-nopad">
            <div class="list-author-widget-contacts list-item-widget-contacts bwc-padside">
                <form action="<?= $ads->viewLink() ?>?action=fetch-info">
                    <?= csrf_field() ?>
                    <ul class="no-list-style info-box">
                        <li><span><i class="fal fa-map-marker"></i><?php _e('LOCATION') ?>: </span><?= $ads->address() ?></li>
                        <?php if ($owner_phone) : ?><li class="phone"><span><i class="fal fa-phone"></i> تلفن :</span> <a href="tel:<?= $owner_phone ?>" data-click-fetch-info><?= shortenString($owner_phone, 4, 2) ?></a></li><?php endif; ?>
                        <?php if ($owner_email) : ?><li class="email"><span><i class="fal fa-envelope"></i> ایمیل :</span> <a href="mailto:<?= $owner_email ?>" data-click-fetch-info data-remodal-target="contact-modal"><?= shortenString($owner_email) ?></a></li><?php endif; ?>
                    </ul>
                </form>
            </div>

            <div class="box-widget">
                <?php if (! $should_show_partial && $ads->shouldShowMap() && setting('SUBMIT__ENABLE_LOCATION_PICKER') === 'YES') : ?>
                    <div class="map-container">
                        <div id="singleMap"></div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php else : ?>
            <div class="box-widget-content expired-item-description">
                <div style='margin-top:60px;'></div>
                <p class='rtl' style="text-align:center;font-size:22px;">
                    <i class='fa fa-times-circle' style='font-size:80px;color:#E92028'></i>
                    <br><br><?php ($is_expired) ? _e('EXPIRED_ADS_ERROR') : _e('DISABLED_BY_USER_ADS_ERROR') ?>
                </p>
                <div style='margin-top:100px;'></div>
            </div>
    <?php endif; ?>


</div>
