<div id="wrapper">
    <div class="content">

        <section class="gray-bg mini-padding">
            <div class="container">

                <div class="breadcrumbs inline-breadcrumbs fl-wrap block-breadcrumbs">
                    <?php breadcrumbs($breadcrumbs) ?>
                </div>

                <div class="fl-wrap">
                    <div class="pricing-wrap fl-wrap">
                        <?php
                        /** @var App\Plan $plan */
                        foreach ($plans as $plan) :
                        ?>
                            <div class="price-item col-md-4 col-sm-6 col-xs-12">
                                <div class="price-head <?= empty($plan->COLOR) ? 'gradient-bg' : false ?>" style="background: linear-gradient(to left, <?= $plan->COLOR ?>, <?= $plan->COLOR ?>);">
                                    <h3><?= $plan->PLAN_TITLE ?></h3>
                                    <div class="price-num col-dec-1 fl-wrap">
                                        <div class="price-num-item">
                                            <?php if (! $plan->isFree()) : ?>
                                                <?= number_format($plan->PLAN_PRICE) ?> <span class="curen"><?= setting('CURRENCY_EXHIBITIVE') ?></span>
                                            <?php endif; ?>
                                            <?php if ($plan->isFree()) : ?>
                                                <?php _e('FREE') ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="price-num-desc">
                                            <?php if ($plan->hasStars()) : ?>
                                                <span class="mouth-cont rating"><?= $plan->starRate(false) ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="circle-wrap" style="right:20%;top:50px;"  >
                                        <div class="circle_bg-bal circle_bg-bal_versmall" data-scrollax="properties: { translateY: '50px' }"></div>
                                   </div>
                                 <div class="circle-wrap" style="right:75%;top:90px;"  >
                                        <div class="circle_bg-bal circle_bg-bal_versmall"></div>
                                    </div>
                                    <div class="footer-wave">
                                        <svg viewbox="0 0 100 25">
                                            <path fill="#fff" d="M0 30 V12 Q30 17 55 12 T100 11 V30z" />
                                        </svg>
                                    </div>
                                    <div class="footer-wave footer-wave2">
                                        <svg viewbox="0 0 100 25">
                                            <path fill="#fff" d="M0 90 V12 Q30 7 45 12 T100 11 V30z" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="price-content fl-wrap">
                                    <div class="price-desc fl-wrap">
                                        <ul class="no-list-style">
                                            <li class="valued-feature">
                                                <span class="feature"><?= ($plan->isFree()) ? _e('PLAN_DAYS', true) : _e('PLAN_SPECIAL_DAYS', true) ?></span>
                                                <span class="value special"><i><?= $plan->toMonth()->time ?></i> <?= $plan->toMonth()->period ?></span>
                                            </li>
                                            <li class="valued-feature">
                                                <span class="feature"><?php _e('PLAN_IMAGES_COUNT') ?></span>
                                                <span class="value"><i><?= $plan->MAX_IMG_COUNT ?></i></span>
                                            </li>
                                            <li class="valued-feature">
                                                <span class="feature"><?php _e('PLAN_TAGS_COUNT') ?></span>
                                                <span class="value"><i><?= $plan->MAX_KEYWORD_COUNT ?></i></span>
                                            </li>
                                            <li class="valued-feature">
                                                <span class="feature"><?php _e('PLAN_UPDATE_COUNT') ?></span>
                                                <span class="value"><i><?= $plan->PLAN_UPDATE_TIMES ?></i></span>
                                            </li>
                                            <li class="valued-feature">
                                                <span class="feature"><?php _e('PLAN_PRIORITY') ?></span>
                                                <span class="value small"><i><?= $plan->priorityText() ?></i></span>
                                            </li>
                                            <li class="feature <?= (! $plan->isSlider()) ? 'no-support' : false ?>">
                                                <span><?php _e('PLAN_MAIN_PAGE_SPECIAL') ?></span>
                                            </li>
                                            <li class="feature <?= (! $plan->hasRibbon()) ? 'no-support' : false ?>">
                                                <span><?php _e('PLAN__HAS_RIBBON', false, ['{%1%}' => $plan->RIBBON_TEXT]) ?></span>
                                            </li>
                                            <li class="feature <?= (! $plan->has_link()) ? 'no-support' : false ?>">
                                                <span><?php _e('PLAN_HAS_LINK') ?></span>
                                            </li>
                                            <li class="feature <?= (! $plan->hasTelegram()) ? 'no-support' : false ?>">
                                                <span><?php _e('PLAN__HAS_TELEGRAM') ?></span>
                                            </li>
                                        </ul>
                                        <?php if ($current_page->setting('order-button-text')) : ?>
                                            <a href="<?= submitLink() ?>?plan_id=<?= $plan->ID ?>" class="price-link <?= (empty($plan->COLOR)) ? 'green-bg' : false ?>" style="<?= (! empty($plan->COLOR)) ? "background-color: {$plan->COLOR}" : false ?>"><?= $current_page->setting('order-button-text') ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php if (not_empty($current_page->setting('description'))) : ?>
                        <span class="section-separator"></span>

                        <div class="features-box-container fl-wrap">
                            <div class="row">

                                <div class="col-md-12">
                                    <div class="features-box">
                                        <div class="time-line-icon">
                                            <i class="fal fa-info"></i>
                                        </div>
                                        <h3><?php _e('IMPORTANT_NOTES') ?></h3>
                                        <?= $current_page->setting('description') ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                    <?php endif; ?>

                </div>

            </div>
        </section>
    </div>

</div>