<div class="form-message-placeholder colorful">
    <?= (isset($success_message)) ? $success_message : _e('CONTACT_MESSAGE_SENT_SUCCESSFUL', true) ?>
</div>

<div id="form-wrapper">

    <form id="contact-form" class="contact__form" method="POST">

        <?= csrf_field() ?>

        <div class="form__content">

            <div class="contact__form_description">
                <?= $contact_form_description ?>
            </div>

            <?php if( ! $loggedUser || empty($loggedUser->NAME) ) : ?>
                <div class="col-sm-12 form-div p-0">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="name" name="name" class="form-control" value="<?= input('name') ?>">
                        <span class="input-icon-addon"> <i class="fa fa-user"></i> </span>
                        <label for="name"><?php _e('FULL_NAME') ?></label>
                        <p class="help-block"></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if( ! $loggedUser || empty($loggedUser->EMAIL)) : ?>
                <div class="col-sm-12 form-div p-0">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="email" name="email" class="form-control" value="<?= input('email') ?>">
                        <span class="input-icon-addon"> <i class="fa fa-envelope"></i> </span>
                        <label for="email"><?php _e('YOUR_EMAIL') ?></label>
                        <p class="help-block"></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if( ! $loggedUser || empty($loggedUser->TEL)) : ?>
                <div class="col-sm-12 form-div p-0">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="phone" name="phone" class="form-control" value="<?= input('phone') ?>">
                        <span class="input-icon-addon"> <i class="fa fa-phone"></i> </span>
                        <label for="phone"><?php _e('PHONE_NUMBER') ?></label>
                        <p class="help-block"></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if( ! isset($show_subject) || $show_subject ) : ?>
                <div class="col-sm-12 form-div p-0">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="subject" name="subject" class="form-control" value="<?= input('subject') ?>">
                        <span class="input-icon-addon"> <i class="fa fa-edit"></i> </span>
                        <label for="subject"><?php _e('SUBJECT') ?></label>
                        <p class="help-block"></p>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-sm-12 form-div p-0 mb-40">
                <div class="form-group form-group--float form-group--icon">
                    <textarea name="message" id="message" class="form-control medium"><?= input('message') ?></textarea>
                    <label for="message"><?php _e('MESSAGE') ?></label>
                    <p class="help-block"></p>
                </div>
            </div>

            <?php if (isImageCaptcha()) : ?>
                <div class="image-captcha form-div">
                    <img src="<?= captcha()->show('contact') ?>" id="contact_captcha" alt="contact captcha">
                    <div class="captcha-update-handler">
                        <i class="fa fa-repeat" data-click-updates-captcha data-namespace="contact" data-target="#contact_captcha"></i>
                    </div>
                </div>
                <div class="col-sm-12 p-0 form-div">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="captcha" name="captcha" class="form-control captcha-field">
                        <span class="input-icon-addon top-3"> <i class="fa fa-shield-alt"></i> </span>
                        <label for="captcha"><?php _e('CAPTCHA_CODE') ?></label>
                        <p class="help-block"></p>
                    </div>
                </div>
            <?php endif; ?>


            <?php if (isRecaptcha()) : ?>
                <div class="clearfix"></div>
                <div class="g-recaptcha" id="contact-recaptcha"></div>
                <div class="mini-next-line"></div>
            <?php endif; ?>

            <div class="col-sm-12 form-div text-center <?= (isRecaptcha() ? 'mt-20' : false) ?>">
                <button type="submit" class="btn color2-bg no-shadow" data-default-text="<?php _e('SEND') ?> <i class='fas fa-caret-left'></i>"> <?php _e('SEND') ?> <i class='fas fa-caret-left'></i></button>
            </div>

            <div class="clearfix"></div>

        </div>
    </form>

</div>