<div id="wrapper">
    <div class="content">
        <section class="gray-bg mini-padding">
            <div class="container">
                <div class="fl-wrap">
                    <div class="row">

                        <?php if ($successful_payment) : ?>
                            <div class="card minimal card-success top-message">
                                <h3><?php _e('SUCCESSFUL_PAYMENT') ?></h3>
                                <p><?php _e('SHOW_ITEM_AFTER_ADMIN_ACCEPT') ?></p>
                            </div>
                        <?php endif; ?>

                        <?php if (! $successful_payment) : ?>
                            <div class="card minimal card-danger top-message">
                                <h3><?php _e('FAILED_PAYMENT') ?></h3>
                                <?php
                                switch ($error) {
                                    case 'FAILED_PAYMENT':
                                        echo "<p>" . _e('PAY_AGAIN_FROM_USER_PANEL', true) . "</p>";
                                        break;
                                    case 'INVALID_PAYMENT':
                                        echo "<p>" . _e('PAYMENT_ACCEPT_ERROR', true) . "</p>";
                                        break;
                                    case 'NOT_VERIFIED':
                                        echo "<p>" . _e('PAYMENT_ACCEPT_ERROR', true) . "</p>";
                                        echo "<p>" . data_get($errors_array, 'payment_error') . "</p>";
                                        break;
                                    case 'UPDATE_ORDER_ERROR':
                                        echo "<p>" . data_get($errors_array, 'payment_error') . "</p>";
                                        echo "<p>" . _e('ERROR_AT_SAVING_PAYMENT_IN_DATABASE', true) . "</p>";
                                        break;
                                }
                                ?>
                            </div>
                        <?php endif; ?>

                        <?php
                        if ($order = $GateWay->order()) {
                            include 'includes/theme/components/_invoice.php';
                        }
                        ?>

                    </div>

                    <div class="text-center" style="margin-top: 25px;">
                        <a href="<?= myListingsLink() ?>" class="btn color2-bg no-shadow">
                            <i class="far fa-home"></i> <?= _e('BACK_TO_MY_LISTING') ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>