<form method="GET" action="<?= searchLink() ?>">

    <div class="card no-radius minimal fl-wrap">
        <div class="row list-search">

            <div class="col-lg-4 col-md-4 col-sm-12 p-0">
                <div class="form-group form-group--float form-group--icon form-group--active no-left-radius">
                    <input type="text" id="keyword" name="keyword" class="form-control" value="<?= strip_tags(htmlspecialchars(input('keyword'))) ?>">
                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                    <label for="keyword"><?php _e('SEARCH_KEYWORD') ?></label>
                </div>
            </div>

            <div class="col-lg-3 col-md-3 col-sm-12 p-0" id="category-dynamic-select">

                <div class="form-group form-group--float form-group--icon form-group--active select-group--dynamic no-radius">
                    <div class="dynamic-select" data-default-text="<?php _e('ALL_CATEGORIES') ?>">
                        <?= ($has_category_filter) ?: _e('ALL_CATEGORIES', true) ?>
                    </div>
                    <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                    <span class="remove-selected-item" style="<?= ($has_category_filter) ? 'display: block' : 'display: none' ?>"> <i class="fa fa-times"></i> </span>
                    <label><?php _e('CATEGORY') ?></label>
                </div>

                <div class="dynamic-select-dropdown">
                    <div class="dropdown-header">
                        <i class="fa fa-times close-dropdown"></i>
                    </div>
                    <div class="dropdown-body">
                        <ul class="dropdown-list no-list-style">
                            <?php
                            foreach ($categories as $category) {
                                echo "<li class='dropdown-list-item' data-category='{$category->ID}'>{$category->logoMarkup('dynamic-select-icon')}{$category->CATEGORY_NAME}</li>";
                            }
                            ?>
                        </ul>
                        <div class="dropdown-inputs">
                            <input type="hidden" name="category" value="<?= optional($current_category)->id() ?>">
                            <input type="hidden" name="subcategory" value="<?= optional($current_subcategory)->id() ?>">
                            <input type="hidden" name="subsidiary" value="<?= optional($current_subsidiary)->id() ?>">
                        </div>

                        <div class="dropdown-template" style="display: none">
                            <?php
                            foreach ($categories as $category) {
                                echo "<li class='dropdown-list-item' data-category='{$category->ID}'>{$category->logoMarkup('dynamic-select-icon')}{$category->CATEGORY_NAME}</li>";
                            }
                            ?>
                        </div>
                    </div>

                </div>
            </div>


            <div class="col-lg-3 col-md-3 col-sm-12 p-0" id="location-dynamic-select">
                <div class="form-group form-group--float form-group--icon form-group--active select-group--dynamic no-radius">
                    <div class="dynamic-select" data-default-text="<?php _e('ALL_LOCATIONS') ?>">
                        <?= ($has_location_filter) ?: _e('ALL_LOCATIONS', true) ?>
                    </div>
                    <span class="input-icon-addon top-3"> <i class="fa fa-location"></i> </span>
                    <span class="remove-selected-item"  style="<?= ($has_location_filter) ? 'display: block' : 'display: none' ?>"> <i class="fa fa-times"></i> </span>
                    <label><?php _e('LOCATION') ?></label>
                </div>

                <div class="dynamic-select-dropdown">
                    <div class="dropdown-header">
                        <i class="fa fa-times close-dropdown"></i>

                        <div class="dropdown-search">
                            <div class="form-group form-group--float form-group--icon form-group--active">
                                <input type="text" id="location_search" name="location_search" class="form-control dropdown-search-input">
                                <span class="input-icon-addon top-3"> <i class="fa fa-search"></i> </span>
                                <label for="location_search"><?php _e('SEARCH_IN_LIST') ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="dropdown-body">
                        <ul class="dropdown-list no-list-style">
                            <?php
                            foreach ($states as $location) {
                                $states_output .= "<li class='dropdown-list-item' data-state='{$location->id()}'>{$location->name()}</li>";
                            }

                            echo $states_output;
                            ?>
                        </ul>
                        <div class="dropdown-inputs">
                            <input type="hidden" name="state" value="<?= optional($current_state)->id() ?>">
                            <input type="hidden" name="city" value="<?= optional($current_city)->id() ?>">
                        </div>

                        <div class="dropdown-template" style="display: none">
                            <?php
                            foreach ($LocationList->states() as $location) {
                                echo "<li class='dropdown-list-item' data-state='{$location->id()}'>{$location->name()}</li>";
                            }
                            ?>
                        </div>
                    </div>

                </div>
            </div>


            <div class="col-lg-2 text-left col-md-2 col-sm-12 p-0 pos-inherit">
                <button class="search-button color2-bg" onclick="window.location.href='listing.html'"><i class="far fa-search"></i> جستجو </button>
            </div>

        </div>
    </div>

    <div class="card no-radius fl-wrap" id="custom-fields-wrapper" style="<?= empty($custom_fields) ? 'display: none' : false ?>">
        <div class="row custom-fields-placeholder">

            <?php
            foreach ($custom_fields as $field) {
                $field->show('search');
            }
            ?>

        </div>

        <button class="btn btn-small color-bg no-shadow submit-button">اعمال فیلترها</button>
    </div>
</form>